/*
 * Decompiled with CFR 0.152.
 */
package net.magik6k.bitbuffer;

import net.magik6k.bitbuffer.SimpleBitBuffer;

class ArrayBitBuffer
extends SimpleBitBuffer {
    private byte[] bytes;

    protected ArrayBitBuffer(long bits) {
        this.bytes = new byte[(int)((bits + (8L - bits % 8L)) / 8L)];
        this.limit = bits;
    }

    protected ArrayBitBuffer(byte[] bytes) {
        this.bytes = bytes;
        this.limit = (long)bytes.length * 8L;
    }

    @Override
    protected byte rawGet(long index) {
        return this.bytes[(int)index];
    }

    @Override
    protected void rawSet(long index, byte value) {
        this.bytes[(int)index] = value;
    }

    @Override
    protected long rawLength() {
        return this.bytes.length;
    }
}

