/*
 * Decompiled with CFR 0.152.
 */
package net.magik6k.bitbuffer;

import java.util.ArrayList;
import net.magik6k.bitbuffer.SimpleBitBuffer;

class AutomaticBitBuffer
extends SimpleBitBuffer {
    private ArrayList<Byte> bytes;

    protected AutomaticBitBuffer() {
        this.bytes = new ArrayList();
    }

    protected AutomaticBitBuffer(long initialCapacity) {
        this.bytes = new ArrayList((int)((initialCapacity + (8L - initialCapacity % 8L)) / 8L));
        while (initialCapacity > (long)this.bytes.size()) {
            this.bytes.add((byte)0);
        }
    }

    @Override
    protected byte rawGet(long index) {
        if (index >= (long)this.bytes.size()) {
            this.bytes.ensureCapacity((int)index + 1);
            while (index >= (long)this.bytes.size()) {
                this.bytes.add((byte)0);
            }
        }
        return this.bytes.get((int)index);
    }

    @Override
    protected void rawSet(long index, byte value) {
        if (index >= (long)this.bytes.size()) {
            this.bytes.ensureCapacity((int)index + 1);
            while (index >= (long)this.bytes.size()) {
                this.bytes.add((byte)0);
            }
        }
        this.bytes.set((int)index, value);
    }

    @Override
    protected long rawLength() {
        return this.bytes.size() * 8;
    }
}

