/*
 * Decompiled with CFR 0.152.
 */
package net.magik6k.bitbuffer;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.magik6k.bitbuffer.ArrayBitBuffer;
import net.magik6k.bitbuffer.AutomaticBitBuffer;
import net.magik6k.bitbuffer.DirectBitBuffer;
import net.magik6k.bitbuffer.IBufferInsert;

public abstract class BitBuffer {
    public abstract BitBuffer putBoolean(boolean var1);

    public BitBuffer putBit(boolean bit) {
        return this.putBoolean(bit);
    }

    public abstract BitBuffer putByte(byte var1);

    public abstract BitBuffer putByte(byte var1, int var2);

    public BitBuffer putInt(int i) {
        this.putByte((byte)((i & 0xFF000000) >>> 24));
        this.putByte((byte)((i & 0xFF0000) >>> 16));
        this.putByte((byte)((i & 0xFF00) >>> 8));
        this.putByte((byte)(i & 0xFF));
        return this;
    }

    public BitBuffer putLong(long l) {
        this.putByte((byte)((l & 0xFF00000000000000L) >>> 56));
        this.putByte((byte)((l & 0xFF000000000000L) >>> 48));
        this.putByte((byte)((l & 0xFF0000000000L) >>> 40));
        this.putByte((byte)((l & 0xFF00000000L) >>> 32));
        this.putByte((byte)((l & 0xFF000000L) >>> 24));
        this.putByte((byte)((l & 0xFF0000L) >>> 16));
        this.putByte((byte)((l & 0xFF00L) >>> 8));
        this.putByte((byte)(l & 0xFFL));
        return this;
    }

    public BitBuffer putInt(int i, int bits) {
        if (bits == 0) {
            return this;
        }
        do {
            if (bits > 7) {
                this.putByte((byte)((i & 255 << bits - 8) >>> bits - 8));
                bits -= 8;
                continue;
            }
            this.putByte((byte)(i & 255 >> -(bits - 8)), bits);
            bits = 0;
        } while (bits > 0);
        return this;
    }

    public BitBuffer putLong(long l, int bits) {
        if (bits == 0) {
            return this;
        }
        do {
            if (bits > 31) {
                this.putInt((int)((l & 0xFFFFFFFFL << (int)((long)bits - 32L)) >>> (int)((long)bits - 32L)));
                bits -= 32;
                continue;
            }
            this.putInt((int)(l & 0xFFFFFFFFL >> (int)(-((long)bits - 32L))), bits);
            bits = 0;
        } while (bits > 0);
        return this;
    }

    public BitBuffer putFloat(float f) {
        this.putInt(Float.floatToRawIntBits(f));
        return this;
    }

    public BitBuffer putDouble(double d) {
        this.putLong(Double.doubleToLongBits(d));
        return this;
    }

    public BitBuffer putString(String s) {
        for (byte ch : s.getBytes(StandardCharsets.UTF_8)) {
            this.putByte(ch);
        }
        return this;
    }

    public BitBuffer putString(String s, int bitsPerChar) {
        for (byte ch : s.getBytes(StandardCharsets.UTF_8)) {
            this.putByte(ch, bitsPerChar);
        }
        return this;
    }

    public BitBuffer put(boolean bit) {
        return this.putBoolean(bit);
    }

    public BitBuffer put(byte number) {
        return this.putByte(number);
    }

    public BitBuffer put(int number) {
        return this.putInt(number);
    }

    public BitBuffer put(long number) {
        return this.putLong(number);
    }

    public BitBuffer put(String string) {
        return this.putString(string);
    }

    public BitBuffer put(BitBuffer buffer) {
        while (buffer.limit() - buffer.position() > 0L) {
            if (buffer.limit() - buffer.position() < 8L) {
                this.put(buffer.getBoolean());
                continue;
            }
            this.put(buffer.getByte());
        }
        return this;
    }

    public BitBuffer put(ByteBuffer buffer) {
        while (buffer.remaining() > 1) {
            this.put(buffer.get());
        }
        return this;
    }

    public BitBuffer put(IBufferInsert data) {
        data.instert(this);
        return this;
    }

    public abstract boolean getBoolean();

    public abstract byte getByte();

    public abstract byte getByte(int var1);

    public int getInt() {
        return (this.getByte() & 0xFF) << 24 | (this.getByte() & 0xFF) << 16 | (this.getByte() & 0xFF) << 8 | this.getByte() & 0xFF;
    }

    public long getLong() {
        return ((long)this.getByte() & 0xFFL) << 56 | ((long)this.getByte() & 0xFFL) << 48 | ((long)this.getByte() & 0xFFL) << 40 | ((long)this.getByte() & 0xFFL) << 32 | ((long)this.getByte() & 0xFFL) << 24 | ((long)this.getByte() & 0xFFL) << 16 | ((long)this.getByte() & 0xFFL) << 8 | (long)this.getByte() & 0xFFL;
    }

    public int getInt(int bits) {
        if (bits == 0) {
            return 0;
        }
        int res = 0;
        do {
            if (bits > 7) {
                res = res << 8 | this.getByte() & 0xFF;
                bits -= 8;
                continue;
            }
            res = (res << bits) + (this.getByte(bits) & 0xFF);
            bits -= bits;
        } while (bits > 0);
        return res;
    }

    public long getLong(int bits) {
        if (bits == 0) {
            return 0L;
        }
        long res = 0L;
        do {
            if (bits > 31) {
                res = res << 8 | (long)this.getInt() & 0xFFFFFFFFL;
                bits -= 32;
                continue;
            }
            res = res << bits | (long)this.getInt(bits) & 0xFFFFFFFFL;
            bits -= bits;
        } while (bits > 0);
        return res;
    }

    public float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    public double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    public String getString(int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.getByte();
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public String getString(int length, int bitsPerChar) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.getByte(bitsPerChar);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public abstract void flip();

    public abstract boolean canRead();

    public abstract boolean canWrite();

    public byte[] asByteArray() {
        byte[] result = new byte[(int)this.limit()];
        long startPos = this.position();
        boolean reflip = false;
        if (!this.canRead()) {
            this.flip();
            reflip = true;
        }
        this.setPosition(0L);
        int i = 0;
        while ((long)(i * 8) < this.limit()) {
            result[i] = this.getByte();
            ++i;
        }
        if (reflip) {
            this.flip();
        }
        this.setPosition(startPos);
        return result;
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.asByteArray());
    }

    public BitBuffer putToByteBuffer(ByteBuffer bb) {
        bb.put(this.asByteArray());
        return this;
    }

    public abstract long size();

    public abstract long limit();

    public abstract long position();

    public abstract BitBuffer setPosition(long var1);

    public static BitBuffer allocate(long bits) {
        return new ArrayBitBuffer(bits);
    }

    public static BitBuffer allocateDirect(long bits) {
        return new DirectBitBuffer(bits);
    }

    public static BitBuffer allocateDynamic() {
        return new AutomaticBitBuffer();
    }

    public static BitBuffer allocateDynamic(int preallocateBits) {
        return new AutomaticBitBuffer(preallocateBits);
    }

    public static BitBuffer wrap(byte[] array) {
        return new ArrayBitBuffer(array);
    }
}

