/*
 * Decompiled with CFR 0.152.
 */
package net.magik6k.bitbuffer;

import java.lang.reflect.Field;
import java.nio.BufferOverflowException;
import net.magik6k.bitbuffer.SimpleBitBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;

class DirectBitBuffer
extends SimpleBitBuffer {
    private static final Unsafe unsafe;
    private long address;
    private final long size;
    private final Deallocator dealloc;
    final Cleaner finalizer;

    protected DirectBitBuffer(long bits) {
        Deallocator dall;
        long bytes = (bits + (8L - bits % 8L)) / 8L;
        this.address = unsafe.allocateMemory(bytes);
        this.dealloc = dall = new Deallocator(this.address);
        this.finalizer = Cleaner.create((Object)this, (Runnable)dall);
        unsafe.setMemory(this.address, bytes, (byte)0);
        this.size = bytes;
    }

    protected void reallocate(long newBits) {
        long newsize = (newBits + (8L - newBits % 8L)) / 8L;
        long oldsize = this.size;
        if (newsize > oldsize) {
            long newaddress;
            long oldaddress = this.address;
            this.dealloc.address = newaddress = unsafe.reallocateMemory(oldaddress, newsize);
            this.address = newaddress;
            unsafe.setMemory(newaddress + oldsize, newsize - oldsize, (byte)0);
        } else if (newsize < oldsize) {
            long newaddress;
            this.dealloc.address = newaddress = unsafe.reallocateMemory(this.address, newsize);
            this.address = newaddress;
        }
    }

    @Override
    protected byte rawGet(long index) {
        if (index >= this.size) {
            throw new BufferOverflowException();
        }
        return unsafe.getByte(this.address + index);
    }

    @Override
    protected void rawSet(long index, byte value) {
        if (index >= this.size) {
            throw new BufferOverflowException();
        }
        unsafe.putByte(this.address + index, value);
    }

    @Override
    protected long rawLength() {
        return this.size;
    }

    static {
        Unsafe us = null;
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            us = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new Error(Unsafe.class.getName() + " is not accessible", e);
        }
        unsafe = us;
    }

    static class Deallocator
    implements Runnable {
        volatile long address;

        public Deallocator(long adr) {
            this.address = adr;
        }

        @Override
        public void run() {
            long address = this.address;
            if (address == 0L) {
                return;
            }
            unsafe.freeMemory(address);
            this.address = 0L;
        }
    }
}

