/*
 * Decompiled with CFR 0.152.
 */
package net.magik6k.bitbuffer;

import net.magik6k.bitbuffer.BitBuffer;

abstract class SimpleBitBuffer
extends BitBuffer {
    private boolean read = false;
    private long position;
    protected long limit;

    SimpleBitBuffer() {
    }

    protected abstract byte rawGet(long var1);

    protected abstract void rawSet(long var1, byte var3);

    protected abstract long rawLength();

    @Override
    public BitBuffer putBoolean(boolean b) {
        this.rawSet(this.position / 8L, (byte)((this.rawGet(this.position / 8L) & ~(128 >>> (int)(this.position % 8L))) + ((b ? 128 : 0) >>> (int)(this.position % 8L))));
        ++this.position;
        return this;
    }

    @Override
    public BitBuffer putByte(byte b) {
        byte old = (byte)(this.rawGet(this.position / 8L) & (byte)(~(255 >>> (int)(this.position % 8L))));
        this.rawSet(this.position / 8L, (byte)(old | (byte)((b & 0xFF) >>> (int)(this.position % 8L))));
        if (this.position % 8L > 0L) {
            this.rawSet(this.position / 8L + 1L, (byte)((b & 0xFF) << (int)(8L - this.position % 8L)));
        }
        this.position += 8L;
        return this;
    }

    @Override
    public BitBuffer putByte(byte b, int bits) {
        b = (byte)(0xFF & (b & 255 >>> 8 - bits) << 8 - bits);
        this.rawSet(this.position / 8L, (byte)(0xFF & (this.rawGet(this.position / 8L) & 255 << (int)(8L - this.position % 8L) | (b & 0xFF) >>> (int)(this.position % 8L))));
        if (8L - this.position % 8L < (long)bits) {
            this.rawSet(this.position / 8L + 1L, (byte)(0xFF & (b & 0xFF) << (int)(8L - this.position % 8L)));
        }
        this.position += (long)bits;
        return this;
    }

    @Override
    public boolean getBoolean() {
        boolean result = (this.rawGet(this.position / 8L) & 128 >>> (int)(this.position % 8L)) > 0;
        ++this.position;
        return result;
    }

    @Override
    public byte getByte() {
        byte b = (byte)((this.rawGet(this.position / 8L) & 255 >>> (int)(this.position % 8L)) << (int)(this.position % 8L));
        b = this.position % 8L > 0L ? (byte)(b | (0xFF & this.rawGet(this.position / 8L + 1L)) >>> (int)(8L - this.position % 8L)) : b;
        this.position += 8L;
        return b;
    }

    @Override
    public byte getByte(int bits) {
        boolean sign = (this.rawGet(this.position / 8L) & 128 >>> (int)(this.position % 8L)) > 0;
        ++this.position;
        short mask = (short)((65280 << 8 - --bits & 0xFFFF) >>> (int)(this.position % 8L));
        int b = (this.rawGet(this.position / 8L) & (mask & 0xFF00) >>> 8) << (int)(this.position % 8L);
        if (8L - this.position % 8L < (long)bits) {
            b = (byte)(b | (0xFF & (this.rawGet(this.position / 8L + 1L) & (mask & 0xFF))) >>> (int)((long)bits - (this.position % 8L + (long)bits - 8L)));
        }
        b = (byte)((b & 0xFF) >>> 8 - bits);
        this.position += (long)bits;
        return (byte)(sign ? 255 << bits & 0xFF | b : b);
    }

    @Override
    public byte getByteUnsigned(int bits) {
        short mask = (short)((65280 << 8 - bits & 0xFFFF) >>> (int)(this.position % 8L));
        byte b = (byte)((this.rawGet(this.position / 8L) & (mask & 0xFF00) >>> 8) << (int)(this.position % 8L));
        if (8L - this.position % 8L < (long)bits) {
            b = (byte)(b | (0xFF & (this.rawGet(this.position / 8L + 1L) & (mask & 0xFF))) >>> (int)((long)bits - (this.position % 8L + (long)bits - 8L)));
        }
        b = (byte)((b & 0xFF) >>> 8 - bits);
        this.position += (long)bits;
        return b;
    }

    @Override
    public BitBuffer flip() {
        boolean bl = this.read = !this.read;
        if (this.read) {
            this.limit = this.position;
        }
        this.position = 0L;
        return this;
    }

    @Override
    public boolean canRead() {
        return this.read;
    }

    @Override
    public boolean canWrite() {
        return !this.read;
    }

    @Override
    public long size() {
        return this.rawLength();
    }

    @Override
    public long limit() {
        return this.read ? this.limit : this.rawLength();
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public BitBuffer setPosition(long newPosition) {
        this.position = newPosition;
        return this;
    }
}

