/*
 * Decompiled with CFR 0.152.
 */
package net.magik6k.bitbuffer;

import net.magik6k.bitbuffer.SimpleBitBuffer;

class AutomaticBitBuffer
extends SimpleBitBuffer {
    private static final int DEFAULT_CAPACITY = 128;
    private byte[] bytes;

    protected AutomaticBitBuffer() {
        this.bytes = new byte[128];
    }

    protected AutomaticBitBuffer(long initialCapacity) {
        this.bytes = new byte[(int)AutomaticBitBuffer.toBytes(initialCapacity)];
    }

    private static long toBytes(long bits) {
        return (int)Math.ceil((double)bits / 8.0);
    }

    @Override
    protected byte rawGet(long index) {
        if (index >= (long)this.bytes.length) {
            this.ensureCapacity((int)index + 1);
        }
        return this.bytes[(int)index];
    }

    private void ensureCapacity(int toBytes) {
        byte[] newBytes = new byte[toBytes];
        System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
        this.bytes = newBytes;
    }

    @Override
    protected void rawSet(long index, byte value) {
        if (index >= (long)this.bytes.length) {
            this.ensureCapacity((int)index + 1);
        }
        this.bytes[(int)index] = value;
    }

    @Override
    protected long rawLength() {
        return this.bytes.length;
    }
}

