/*
 * Decompiled with CFR 0.152.
 */
package net.magik6k.jwwf.ace;

import net.magik6k.jwwf.ace.AceMode;
import net.magik6k.jwwf.ace.AceTheme;
import net.magik6k.jwwf.core.action.Actions;
import net.magik6k.jwwf.event.InputEvent;
import net.magik6k.jwwf.event.input.TextInputEvent;
import net.magik6k.jwwf.handlers.TextHandler;
import net.magik6k.jwwf.util.Json;
import net.magik6k.jwwf.widgets.basic.input.generic.BasicInput;

public class AceEditor
extends BasicInput {
    private String text;
    private int width = 800;
    private int height = 600;
    private TextHandler handler;
    private AceMode mode = AceMode.TEXT;
    private AceTheme theme = AceTheme.MONOKAI;
    private boolean sendTextUpdate = true;

    public AceEditor() {
        super(Actions.TEXT_INPUT);
    }

    public AceEditor(String text) {
        super(Actions.TEXT_INPUT);
        this.text = text;
    }

    public AceEditor(String text, TextHandler handler) {
        super(Actions.TEXT_INPUT);
        this.text = text;
        this.handler = handler;
    }

    public AceEditor(TextHandler handler) {
        super(Actions.TEXT_INPUT);
        this.handler = handler;
    }

    public AceEditor(String text, int width, int height) {
        super(Actions.TEXT_INPUT);
        this.text = text;
        this.width = width;
        this.height = height;
    }

    public AceEditor(String text, TextHandler handler, int width, int height) {
        super(Actions.TEXT_INPUT);
        this.text = text;
        this.handler = handler;
        this.width = width;
        this.height = height;
    }

    public AceEditor(TextHandler handler, int width, int height) {
        super(Actions.TEXT_INPUT);
        this.handler = handler;
        this.width = width;
        this.height = height;
    }

    public AceEditor(AceMode mode) {
        super(Actions.TEXT_INPUT);
        this.mode = mode;
    }

    public AceEditor(String text, AceMode mode) {
        super(Actions.TEXT_INPUT);
        this.text = text;
        this.mode = mode;
    }

    public AceEditor(String text, TextHandler handler, AceMode mode) {
        super(Actions.TEXT_INPUT);
        this.text = text;
        this.handler = handler;
        this.mode = mode;
    }

    public AceEditor(TextHandler handler, AceMode mode) {
        super(Actions.TEXT_INPUT);
        this.handler = handler;
        this.mode = mode;
    }

    public AceEditor(String text, int width, int height, AceMode mode) {
        super(Actions.TEXT_INPUT);
        this.text = text;
        this.width = width;
        this.height = height;
        this.mode = mode;
    }

    public AceEditor(String text, TextHandler handler, int width, int height, AceMode mode) {
        super(Actions.TEXT_INPUT);
        this.text = text;
        this.handler = handler;
        this.width = width;
        this.height = height;
        this.mode = mode;
    }

    public AceEditor(TextHandler handler, int width, int height, AceMode mode) {
        super(Actions.TEXT_INPUT);
        this.handler = handler;
        this.width = width;
        this.height = height;
        this.mode = mode;
    }

    public AceEditor(AceTheme theme) {
        super(Actions.TEXT_INPUT);
        this.theme = theme;
    }

    public AceEditor(String text, AceTheme theme) {
        super(Actions.TEXT_INPUT);
        this.text = text;
        this.theme = theme;
    }

    public AceEditor(String text, TextHandler handler, AceTheme theme) {
        super(Actions.TEXT_INPUT);
        this.text = text;
        this.handler = handler;
        this.theme = theme;
    }

    public AceEditor(TextHandler handler, AceTheme theme) {
        super(Actions.TEXT_INPUT);
        this.handler = handler;
        this.theme = theme;
    }

    public AceEditor(String text, int width, int height, AceTheme theme) {
        super(Actions.TEXT_INPUT);
        this.text = text;
        this.width = width;
        this.height = height;
        this.theme = theme;
    }

    public AceEditor(String text, TextHandler handler, int width, int height, AceTheme theme) {
        super(Actions.TEXT_INPUT);
        this.text = text;
        this.handler = handler;
        this.width = width;
        this.height = height;
        this.theme = theme;
    }

    public AceEditor(TextHandler handler, int width, int height, AceTheme theme) {
        super(Actions.TEXT_INPUT);
        this.handler = handler;
        this.width = width;
        this.height = height;
        this.theme = theme;
    }

    public AceEditor(AceMode mode, AceTheme theme) {
        super(Actions.TEXT_INPUT);
        this.mode = mode;
        this.theme = theme;
    }

    public AceEditor(String text, AceMode mode, AceTheme theme) {
        super(Actions.TEXT_INPUT);
        this.text = text;
        this.mode = mode;
        this.theme = theme;
    }

    public AceEditor(String text, TextHandler handler, AceMode mode, AceTheme theme) {
        super(Actions.TEXT_INPUT);
        this.text = text;
        this.handler = handler;
        this.mode = mode;
        this.theme = theme;
    }

    public AceEditor(TextHandler handler, AceMode mode, AceTheme theme) {
        super(Actions.TEXT_INPUT);
        this.handler = handler;
        this.mode = mode;
        this.theme = theme;
    }

    public AceEditor(String text, int width, int height, AceMode mode, AceTheme theme) {
        super(Actions.TEXT_INPUT);
        this.text = text;
        this.width = width;
        this.height = height;
        this.mode = mode;
        this.theme = theme;
    }

    public AceEditor(String text, TextHandler handler, int width, int height, AceMode mode, AceTheme theme) {
        super(Actions.TEXT_INPUT);
        this.text = text;
        this.handler = handler;
        this.width = width;
        this.height = height;
        this.mode = mode;
        this.theme = theme;
    }

    public AceEditor(TextHandler handler, int width, int height, AceMode mode, AceTheme theme) {
        super(Actions.TEXT_INPUT);
        this.handler = handler;
        this.width = width;
        this.height = height;
        this.mode = mode;
        this.theme = theme;
    }

    public AceEditor setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.sendElement();
        return this;
    }

    public AceEditor setText(String text) {
        this.text = text;
        this.sendTextUpdate = true;
        this.sendElement();
        return this;
    }

    public AceEditor setTextHandler(TextHandler handler) {
        this.handler = handler;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public String getName() {
        return "AceEditor";
    }

    public String getData() {
        return "{\"width\":" + String.valueOf(this.width) + ",\"height\":" + String.valueOf(this.height) + ",\"theme\":\"" + this.theme.theme + "\", \"mode\": \"" + this.mode.mode + "\"" + (this.sendTextUpdate ? ",\"text\":" + Json.escapeString((String)this.text) : "") + "}";
    }

    public void handleData(String data) {
        if (data == null) {
            return;
        }
        this.text = data;
        this.sendEvent((InputEvent)new TextInputEvent(this.user, this.getPayload(), data));
        if (this.handler != null) {
            this.handler.onType(data);
        }
    }
}

