/*
 * Decompiled with CFR 0.152.
 */
package net.meku.chameleon.memory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.meku.chameleon.spi.ConfigRefreshAction;
import net.meku.chameleon.spi.ConfigRefreshActionFactory;
import org.apache.commons.lang3.StringUtils;

public class MemoryRefreshActionFactory
implements ConfigRefreshActionFactory {
    private Map<String, Set<ConfigRefreshAction>> actionMap = new HashMap<String, Set<ConfigRefreshAction>>();

    @Override
    public void registerAction(String key, ConfigRefreshAction action) {
        if (StringUtils.isBlank((CharSequence)key) || action == null) {
            return;
        }
        Set<ConfigRefreshAction> actions = this.actionMap.get(key);
        if (actions == null) {
            actions = new HashSet<ConfigRefreshAction>();
            this.actionMap.put(key, actions);
        }
        actions.add(action);
    }

    @Override
    public void removeActions(String key) {
        this.actionMap.remove(key);
    }

    void onRefresh(String key) {
        Set<ConfigRefreshAction> actions = this.actionMap.get(key);
        if (actions == null || actions.isEmpty()) {
            return;
        }
        actions.forEach(action -> action.onRefresh());
    }
}

