/*
 * Decompiled with CFR 0.152.
 */
package net.meku.chameleon.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.meku.chameleon.core.CacheableConfig;
import net.meku.chameleon.util.ReflectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.annotation.Value;

public class CacheableBeanResolver {
    public List<String> resolve(Object bean) {
        Method[] methods;
        ArrayList<String> cacheableKeys = new ArrayList<String>();
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        Class targetClass = this.getBeanClass(bean);
        CacheableConfig annotation = targetClass.getAnnotation(CacheableConfig.class);
        if (annotation != null && !annotation.ignore()) {
            methods = targetClass.getMethods();
            if (methods != null && methods.length > 0) {
                for (Method method : methods) {
                    if (!this.isMatchedMethodInAnnotatedClass(method)) continue;
                    annotatedMethods.add(method);
                }
            }
        } else {
            for (Method method : methods = targetClass.getMethods()) {
                if (!this.isMatchedMethodInNonAnnotatedClass(method)) continue;
                annotatedMethods.add(method);
            }
        }
        for (Method method : annotatedMethods) {
            String keyEL;
            Value value;
            Field field = ReflectUtils.getFieldForGetter(method);
            if (field == null || (value = field.getAnnotation(Value.class)) == null || StringUtils.isBlank((CharSequence)(keyEL = value.value())) || !keyEL.startsWith("${") && !keyEL.endsWith("}")) continue;
            String key = keyEL.substring(2, keyEL.length() - 1);
            cacheableKeys.add(key);
        }
        return cacheableKeys;
    }

    private Class getBeanClass(Object bean) {
        Class<?> clazz = AopProxyUtils.ultimateTargetClass((Object)bean);
        String className = clazz.getName();
        if (className.indexOf("$$") > 0) {
            className = StringUtils.split((String)className, (String)"$$")[0];
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    private boolean isMatchedMethodInAnnotatedClass(Method method) {
        CacheableConfig annotation = method.getAnnotation(CacheableConfig.class);
        return (annotation == null || !annotation.ignore()) && ReflectUtils.isGetter(method);
    }

    private boolean isMatchedMethodInNonAnnotatedClass(Method method) {
        CacheableConfig annotation = method.getAnnotation(CacheableConfig.class);
        return annotation != null && !annotation.ignore() && ReflectUtils.isGetter(method);
    }
}

