/*
 * Decompiled with CFR 0.152.
 */
package net.meku.chameleon.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.meku.chameleon.core.CacheableBeanResolver;
import net.meku.chameleon.core.ConfigPojo;
import net.meku.chameleon.core.Configable;
import net.meku.chameleon.spi.ConfigCacheResolver;
import net.meku.chameleon.spi.ConfigManager;
import net.meku.chameleon.spi.ConfigPersistResolver;
import net.meku.chameleon.util.SpringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class ConfigManagerImpl
implements ConfigManager,
InitializingBean,
BeanPostProcessor,
Ordered {
    private Map<String, String> propertiesConfigs = new HashMap<String, String>();
    @Autowired
    private ConfigCacheResolver cacheResolver;
    @Autowired
    private ConfigPersistResolver persistResolver;
    @Autowired
    private CacheableBeanResolver cacheableBeanResolver;
    @Autowired
    private SpringUtils springUtils;

    @Override
    public List<Configable> listAll() {
        List<Configable> list = this.cacheResolver.list();
        Collections.sort(list, (o1, o2) -> o1.getKey().compareTo(o2.getKey()));
        return list;
    }

    @Override
    public boolean exists(String key) {
        return this.cacheResolver.exists(key);
    }

    @Override
    public String getString(String key) {
        return this.cacheResolver.get(key);
    }

    @Override
    public boolean getBool(String key) {
        String value = this.getString(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public int getInt(String key) {
        String value = this.getString(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    @Override
    public long getLong(String key) {
        String value = this.getString(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return 0L;
        }
        return Long.parseLong(value);
    }

    @Override
    public double getDouble(String key) {
        String value = this.getString(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    @Override
    public List<Configable> reload() {
        List<Configable> properties = this.initializePropertiesList();
        List<Configable> persists = this.persistResolver.load();
        List<Configable> list = this.mergeConfigList(properties, persists);
        this.cacheResolver.clear();
        list.forEach(config -> this.cacheResolver.set((Configable)config));
        return list;
    }

    private List<Configable> initializePropertiesList() {
        ArrayList<Configable> list = new ArrayList<Configable>();
        for (String key : this.propertiesConfigs.keySet()) {
            ConfigPojo pojo = new ConfigPojo();
            pojo.setKey(key);
            pojo.setValue(this.propertiesConfigs.get(key));
            list.add(pojo);
        }
        return list;
    }

    private List<Configable> mergeConfigList(List<Configable> properties, List<Configable> persists) {
        for (Configable configable : properties) {
            if (this.existsInList(configable.getKey(), persists)) continue;
            persists.add(configable);
        }
        return persists;
    }

    private boolean existsInList(String key, List<Configable> list) {
        for (Configable configable : list) {
            if (!key.equals(configable.getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Configable save(Configable configable) {
        Configable saved = this.persistResolver.save(configable);
        this.cacheResolver.set(saved);
        return saved;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        List<String> keys = this.cacheableBeanResolver.resolve(bean);
        if (!keys.isEmpty()) {
            keys.forEach(key -> this.setConfigFromProperties((String)key));
        }
        return bean;
    }

    private void setConfigFromProperties(String key) {
        String value = this.springUtils.getProperty(key);
        this.propertiesConfigs.put(key, value);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void afterPropertiesSet() throws Exception {
        this.reload();
    }
}

