/*
 * Decompiled with CFR 0.152.
 */
package net.meku.chameleon.memory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.meku.chameleon.core.Configable;
import net.meku.chameleon.memory.MemoryRefreshActionFactory;
import net.meku.chameleon.spi.ConfigCacheResolver;
import net.meku.chameleon.spi.ConfigRefreshActionFactory;
import net.meku.chameleon.util.ChameleonUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class MemoryCacheResolver
implements ConfigCacheResolver {
    private Map<String, String> cache = new HashMap<String, String>();
    @Autowired(required=false)
    private ConfigRefreshActionFactory refreshActionFactory;

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void set(Configable configable) {
        if (configable == null) {
            return;
        }
        this.cache.put(configable.getKey(), configable.getValue());
        if (this.refreshActionFactory != null && this.refreshActionFactory instanceof MemoryRefreshActionFactory) {
            ((MemoryRefreshActionFactory)this.refreshActionFactory).onRefresh(configable.getKey());
        }
    }

    @Override
    public void set(List<? extends Configable> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        list.forEach(configable -> this.set((Configable)configable));
    }

    @Override
    public String get(String key) {
        return this.cache.get(key);
    }

    @Override
    public boolean exists(String key) {
        return this.cache.containsKey(key);
    }

    @Override
    public List<Configable> list() {
        return ChameleonUtils.fromMap(this.cache);
    }
}

