/*
 * Decompiled with CFR 0.152.
 */
package net.meku.chameleon.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.meku.chameleon.core.CacheableConfig;
import net.meku.chameleon.spi.ConfigManager;
import net.meku.chameleon.util.ReflectUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Aspect
public class CacheableConfigAspect {
    @Autowired
    private ConfigManager configManager;
    private List<String> ignoreMethods = new ArrayList<String>();
    private Map<String, String> keyMaps = new HashMap<String, String>();

    @Pointcut(value="@annotation(net.meku.chameleon.core.CacheableConfig) || @within(net.meku.chameleon.core.CacheableConfig)")
    public void process() {
    }

    @Around(value="process()")
    public Object round(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String aopKey = joinPoint.toLongString();
        if (this.keyMaps.containsKey(aopKey)) {
            return this.getCacheConfig(this.keyMaps.get(aopKey), signature.getReturnType());
        }
        if (this.isInIgnoreList(aopKey)) {
            return joinPoint.proceed();
        }
        String configKey = this.getConfigKey(signature);
        if (configKey == null) {
            this.ignoreMethods.add(aopKey);
            return joinPoint.proceed();
        }
        this.keyMaps.put(aopKey, configKey);
        return this.getCacheConfig(configKey, signature.getReturnType());
    }

    private boolean isInIgnoreList(String aopKey) {
        if (this.ignoreMethods.isEmpty()) {
            return false;
        }
        return this.ignoreMethods.stream().anyMatch(item -> item.equals(aopKey));
    }

    private String getConfigKey(MethodSignature methodSignature) {
        Method method = methodSignature.getMethod();
        CacheableConfig config = method.getAnnotation(CacheableConfig.class);
        if (config != null && config.ignore()) {
            return null;
        }
        Field field = ReflectUtils.getFieldForGetter(method);
        if (field == null) {
            return null;
        }
        Value value = field.getAnnotation(Value.class);
        if (value == null) {
            return null;
        }
        String keyEL = value.value();
        if (StringUtils.isBlank((CharSequence)keyEL)) {
            return null;
        }
        if (!keyEL.startsWith("${") && !keyEL.endsWith("}")) {
            return null;
        }
        return keyEL.substring(2, keyEL.length() - 1);
    }

    private Object getCacheConfig(String key, Class type) {
        String value = this.configManager.getString(key);
        if (type == String.class) {
            return value;
        }
        return ConvertUtils.convert((String)value, (Class)type);
    }
}

