/*
 * Decompiled with CFR 0.152.
 */
package net.meku.chameleon.demo.web;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import net.meku.chameleon.core.Configable;
import net.meku.chameleon.demo.web.ConfigView;
import net.meku.chameleon.spi.ConfigManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="Config API")
@RequestMapping(value={"/configs"})
@RestController
public class ConfigController {
    @Autowired
    private ConfigManager configManager;

    @ApiOperation(value="Get all config items.")
    @GetMapping
    public List<ConfigView> listAll() {
        List pojos = this.configManager.listAll();
        return this.from(pojos);
    }

    @ApiOperation(value="Reload all config items.")
    @PostMapping(value={"/reload"})
    public List<ConfigView> reload() {
        List pojos = this.configManager.reload();
        return this.from(pojos);
    }

    @ApiOperation(value="Update a config item.")
    @PutMapping
    public ConfigView update(ConfigView view) {
        Configable saved = this.configManager.save((Configable)view);
        return this.from(saved);
    }

    private ConfigView from(Configable configable) {
        ConfigView view = new ConfigView();
        if (configable != null) {
            view.setId(configable.getKey());
            view.setValue(configable.getValue());
        }
        return view;
    }

    private List<ConfigView> from(List<Configable> pojos) {
        ArrayList<ConfigView> views = new ArrayList<ConfigView>();
        pojos.forEach(pojo -> views.add(this.from((Configable)pojo)));
        return views;
    }
}

