/*
 * Decompiled with CFR 0.152.
 */
package net.meku.chameleon.persist;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.meku.chameleon.core.Configable;
import net.meku.chameleon.persist.JsonFileHandler;
import net.meku.chameleon.spi.ConfigPersistResolver;
import net.meku.chameleon.util.ChameleonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FilePersistResolver
implements ConfigPersistResolver {
    private static final Log LOGGER = LogFactory.getLog(JsonFileHandler.class);
    @Autowired
    private JsonFileHandler jsonFileHandler;

    public List<Configable> load() {
        Map<String, String> map = this.jsonFileHandler.read();
        return ChameleonUtils.fromMap(map);
    }

    public Configable save(Configable configable) {
        try {
            this.jsonFileHandler.write(configable.getKey(), configable.getValue());
        }
        catch (IOException e) {
            LOGGER.error((Object)("Failed to save config" + configable.getKey()), (Throwable)e);
        }
        return configable;
    }
}

