/*
 * Decompiled with CFR 0.152.
 */
package net.meku.chameleon.persist;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JsonFileHandler {
    private static final Log LOGGER = LogFactory.getLog(JsonFileHandler.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Value(value="${chameleon.persist.json.path:configs.json}")
    private String filePath = "configs.json";

    public Map<String, String> read() {
        File file = new File(this.filePath);
        if (!file.exists()) {
            return Collections.EMPTY_MAP;
        }
        try {
            return (Map)this.objectMapper.readValue(file, Map.class);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Failed to convert file to Map.", (Throwable)e);
            return Collections.EMPTY_MAP;
        }
    }

    public Map<String, String> write(String key, String value) throws IOException {
        File file = new File(this.filePath);
        Map<String, String> map = !file.exists() ? new HashMap<String, String>() : (Map)this.objectMapper.readValue(file, Map.class);
        map.put(key, value);
        this.objectMapper.writeValue(file, map);
        return map;
    }
}

