/*
 * Decompiled with CFR 0.152.
 */
package net.meku.chameleon.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.meku.chameleon.core.ConfigPojo;
import net.meku.chameleon.core.Configable;
import net.meku.chameleon.redis.RedisCacheConfig;
import net.meku.chameleon.spi.ConfigCacheResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCacheResolver
implements ConfigCacheResolver {
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private RedisCacheConfig redisCacheConfig;

    public void clear() {
        Set keys = this.redisTemplate.keys((Object)(this.redisCacheConfig.getKeyPrefix() + "*"));
        this.redisTemplate.delete((Collection)keys);
    }

    public void set(Configable configable) {
        this.redisTemplate.opsForValue().set((Object)this.getFullKey(configable.getKey()), (Object)configable.getValue());
    }

    public String get(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)this.getFullKey(key));
    }

    public boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)this.getFullKey(key));
    }

    public List<Configable> list() {
        ArrayList<Configable> list = new ArrayList<Configable>();
        Set keys = this.redisTemplate.keys((Object)(this.redisCacheConfig.getKeyPrefix() + "*"));
        ArrayList orderKeys = new ArrayList();
        keys.forEach(key -> orderKeys.add(key));
        List values = this.redisTemplate.opsForValue().multiGet(orderKeys);
        int prefixLength = this.redisCacheConfig.getKeyPrefix().length();
        for (int i = 0; i < values.size(); ++i) {
            ConfigPojo pojo = new ConfigPojo();
            pojo.setKey(((String)orderKeys.get(i)).substring(prefixLength));
            pojo.setValue((String)values.get(i));
            list.add((Configable)pojo);
        }
        return list;
    }

    private String getFullKey(String shortKey) {
        return this.redisCacheConfig.getKeyPrefix() + shortKey;
    }
}

