/*
 * Decompiled with CFR 0.152.
 */
package net.meku.chameleon.redis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.meku.chameleon.redis.RedisCacheConfig;
import net.meku.chameleon.spi.ConfigRefreshAction;
import net.meku.chameleon.spi.ConfigRefreshActionFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.listener.KeyspaceEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

public class RedisRefreshActionFactory
extends KeyspaceEventMessageListener
implements ConfigRefreshActionFactory {
    private static final String KEY_EVENT = "__keyevent@";
    private static final String KEY_OPERATION = ":set";
    private Map<String, Set<ConfigRefreshAction>> actionMap = new HashMap<String, Set<ConfigRefreshAction>>();
    private RedisCacheConfig redisCacheConfig;

    public RedisRefreshActionFactory(RedisMessageListenerContainer listenerContainer, RedisCacheConfig redisCacheConfig) {
        super(listenerContainer);
        this.redisCacheConfig = redisCacheConfig;
    }

    protected void doHandleMessage(Message message) {
        if (message == null || message.getBody() == null || message.getChannel() == null) {
            return;
        }
        String body = new String(message.getBody());
        String channel = new String(message.getChannel());
        String prefix = this.redisCacheConfig.getKeyPrefix();
        if (body.startsWith(prefix) && channel.startsWith(KEY_EVENT) && channel.endsWith(KEY_OPERATION)) {
            this.onRefresh(body.substring(prefix.length()));
        }
    }

    private void onRefresh(String configId) {
        Set<ConfigRefreshAction> actions = this.actionMap.get(configId);
        if (actions == null || actions.isEmpty()) {
            return;
        }
        actions.forEach(action -> action.onRefresh());
    }

    public void registerAction(String key, ConfigRefreshAction action) {
        if (StringUtils.isBlank((CharSequence)key) || action == null) {
            return;
        }
        Set<ConfigRefreshAction> actions = this.actionMap.get(key);
        if (actions == null) {
            actions = new HashSet<ConfigRefreshAction>();
            this.actionMap.put(key, actions);
        }
        actions.add(action);
    }

    public void removeActions(String key) {
        this.actionMap.remove(key);
    }
}

