/*
 * Decompiled with CFR 0.152.
 */
package net.meku.chameleon.starter;

import net.meku.chameleon.memory.MemoryCacheResolver;
import net.meku.chameleon.memory.MemoryRefreshActionFactory;
import net.meku.chameleon.persist.FilePersistResolver;
import net.meku.chameleon.redis.RedisCacheResolver;
import net.meku.chameleon.redis.RedisRefreshActionFactoryBuilder;
import net.meku.chameleon.spi.ConfigCacheResolver;
import net.meku.chameleon.spi.ConfigPersistResolver;
import net.meku.chameleon.spi.ConfigRefreshActionFactory;
import net.meku.chameleon.spi.ConfigService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ConfigService.class})
public class ChameleonAutoConfiguration {
    @ConditionalOnProperty(value={"chameleon.cache"}, havingValue="redis")
    @Bean
    public ConfigCacheResolver redisCacheResolver() {
        return new RedisCacheResolver();
    }

    @ConditionalOnMissingBean(value={ConfigCacheResolver.class})
    @Bean
    public ConfigCacheResolver memoryCacheResolver() {
        return new MemoryCacheResolver();
    }

    @ConditionalOnMissingBean(value={ConfigPersistResolver.class})
    @Bean
    public ConfigPersistResolver filePersistResolver() {
        return new FilePersistResolver();
    }

    @ConditionalOnProperty(value={"chameleon.cache"}, havingValue="redis")
    @Bean
    public ConfigRefreshActionFactory redisRefreshActionFactory() {
        RedisRefreshActionFactoryBuilder builder = new RedisRefreshActionFactoryBuilder();
        return builder.build();
    }

    @ConditionalOnMissingBean(value={ConfigRefreshActionFactory.class})
    @Bean
    public ConfigRefreshActionFactory memoryRefreshActionFactory() {
        return new MemoryRefreshActionFactory();
    }
}

