/*
 * Decompiled with CFR 0.152.
 */
package net.meku.cylone;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.meku.cylone.ConvertedPage;
import net.meku.cylone.PojoConverter;
import org.springframework.data.domain.Page;

public abstract class AbstractPojoConverter<T, S>
implements PojoConverter<T, S> {
    protected T createEmptyTarget(S source) {
        Class type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public T toPojo(S source) {
        if (source == null) {
            return null;
        }
        T target = this.createEmptyTarget(source);
        this.toPojo(source, target);
        return target;
    }

    @Override
    public List<T> toList(List<S> sourceList) {
        if (sourceList == null) {
            return Collections.emptyList();
        }
        ArrayList targetList = new ArrayList(sourceList.size());
        sourceList.forEach(source -> targetList.add(this.toPojo(source)));
        return targetList;
    }

    @Override
    public Page<T> toPage(Page<S> sourcePage) {
        if (sourcePage == null) {
            return null;
        }
        List<T> targetList = this.toList(sourcePage.getContent());
        ConvertedPage<T> targetPage = new ConvertedPage<T>(sourcePage, targetList);
        return targetPage;
    }
}

