/*
 * Decompiled with CFR 0.152.
 */
package net.middell;

import net.middell.OffsetRange;
import org.xml.sax.Attributes;

public abstract class Markup {
    public final Type type;
    public final OffsetRange sourceRange;

    protected Markup(Type type, OffsetRange sourceRange) {
        this.type = type;
        this.sourceRange = sourceRange;
    }

    public Start asStart() {
        return (Start)this;
    }

    public End asEnd() {
        return (End)this;
    }

    public Text asText() {
        return (Text)this;
    }

    public String toString() {
        return String.format("%s [%s]", new Object[]{this.sourceRange, this.type});
    }

    public static String escapeText(String text) {
        return "'" + text.replaceAll("'", "\\'").replaceAll("[\r\n]", "\u00b6") + "'";
    }

    public static class Text
    extends Markup {
        public final String text;

        public Text(OffsetRange sourceRange, String text) {
            super(Type.TEXT, sourceRange);
            this.text = text;
        }

        @Override
        public String toString() {
            return super.toString() + " " + Text.escapeText(this.text);
        }
    }

    public static class End
    extends Markup {
        public final Element element;

        public End(OffsetRange sourceRange, Element element) {
            super(Type.END, sourceRange);
            this.element = element;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.element.toString();
        }
    }

    public static class Start
    extends Markup {
        public final Element element;

        public Start(OffsetRange sourceRange, Element element) {
            super(Type.START, sourceRange);
            this.element = element;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.element.toString();
        }
    }

    public static class EndDocument
    extends Markup {
        protected EndDocument(OffsetRange sourceRange) {
            super(Type.END_DOCUMENT, sourceRange);
        }
    }

    public static class StartDocument
    extends Markup {
        protected StartDocument(OffsetRange sourceRange) {
            super(Type.START_DOCUMENT, sourceRange);
        }
    }

    public static class Element {
        public final String nsUri;
        public final String localName;
        public final Attributes attributes;

        public Element(String nsUri, String localName, Attributes attributes) {
            this.nsUri = nsUri;
            this.localName = localName;
            this.attributes = attributes;
        }

        public String toString() {
            return String.format("{%s}%s[%s]", this.nsUri, this.localName, Element.toString(this.attributes));
        }

        protected static String toString(Attributes attributes) {
            StringBuilder builder = new StringBuilder();
            int al = attributes.getLength();
            for (int ac = 0; ac < al; ++ac) {
                builder.append(String.format("@%s='%s'", attributes.getQName(ac), attributes.getValue(ac)));
                if (builder.length() <= 0) continue;
                builder.append(", ");
            }
            return builder.toString();
        }
    }

    public static enum Type {
        START_DOCUMENT,
        END_DOCUMENT,
        START,
        END,
        TEXT;


        public String toString() {
            switch (this) {
                case START_DOCUMENT: {
                    return "{";
                }
                case END_DOCUMENT: {
                    return "}";
                }
                case START: {
                    return "<";
                }
                case END: {
                    return ">";
                }
                case TEXT: {
                    return ".";
                }
            }
            throw new IllegalStateException();
        }
    }
}

