/*
 * Decompiled with CFR 0.152.
 */
package net.middell;

import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Predicate;
import net.middell.Markup;

public interface MarkupFilter {
    public static Predicate<Markup> contextual(Predicate<Markup> exclude, Predicate<Markup> include) {
        return MarkupFilter.contextual(exclude, include, ms -> ms.type == Markup.Type.START, ms -> ms.type == Markup.Type.END);
    }

    public static Predicate<Markup> contextual(final Predicate<Markup> exclude, final Predicate<Markup> include, final Predicate<Markup> contextStart, final Predicate<Markup> contextEnd) {
        return new Predicate<Markup>(){
            private final Deque<Boolean> filterContext = new LinkedList<Boolean>();

            @Override
            public boolean test(Markup markup) {
                boolean accept;
                if (contextStart.test(markup)) {
                    boolean parentIncluded;
                    boolean bl = parentIncluded = this.filterContext.isEmpty() ? true : this.filterContext.peek();
                    this.filterContext.push(parentIncluded ? !exclude.test(markup) : include.test(markup));
                }
                boolean bl = accept = this.filterContext.isEmpty() || this.filterContext.peek() != false;
                if (contextEnd.test(markup) && !this.filterContext.isEmpty()) {
                    this.filterContext.pop();
                }
                return accept;
            }
        };
    }
}

