/*
 * Decompiled with CFR 0.152.
 */
package net.middell;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import net.middell.Markup;
import net.middell.OffsetRange;
import org.codehaus.stax2.LocationInfo;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.xml.sax.helpers.AttributesImpl;

public class MarkupPipeline {
    private final Operator[] operators;
    private static final Markup[] EMPTY_RESULT = new Markup[0];
    private static final XMLInputFactory2 XML_INPUT_FACTORY = (XMLInputFactory2)XMLInputFactory2.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Source source, Consumer<Markup> consumer) throws XMLStreamException {
        try (XMLStreamReader2 streamReader = (XMLStreamReader2)XML_INPUT_FACTORY.createXMLStreamReader(source);){
            this.process(streamReader, consumer);
        }
    }

    public void process(XMLStreamReader2 reader, Consumer<Markup> consumer) throws XMLStreamException {
        LinkedList<Markup.Element> hierarchy = new LinkedList<Markup.Element>();
        ArrayList<Markup> buf = new ArrayList<Markup>();
        while (reader.hasNext()) {
            int event = reader.next();
            LocationInfo locationInfo = reader.getLocationInfo();
            OffsetRange range = new OffsetRange(locationInfo.getStartingCharOffset(), locationInfo.getEndingCharOffset());
            switch (event) {
                case 7: {
                    this.process(new Markup.StartDocument(range), consumer, buf);
                    break;
                }
                case 8: {
                    this.process(new Markup.EndDocument(range), consumer, buf);
                    break;
                }
                case 1: {
                    AttributesImpl attributes = new AttributesImpl();
                    int al = reader.getAttributeCount();
                    for (int ac = 0; ac < al; ++ac) {
                        String ln = reader.getAttributeLocalName(ac);
                        attributes.addAttribute(Optional.ofNullable(reader.getAttributeNamespace(ac)).orElse(""), ln, Stream.of(reader.getAttributePrefix(ac), ln).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining(":")), reader.getAttributeType(ac), reader.getAttributeValue(ac));
                    }
                    Markup.Element element = new Markup.Element(reader.getNamespaceURI(), reader.getLocalName(), attributes);
                    hierarchy.push(element);
                    this.process(new Markup.Start(range, element), consumer, buf);
                    break;
                }
                case 2: {
                    this.process(new Markup.End(range, (Markup.Element)hierarchy.pop()), consumer, buf);
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    String text = reader.getText();
                    this.process(new Markup.Text(range, text), consumer, buf);
                }
            }
        }
    }

    private void process(Markup input, Consumer<Markup> output, List<Markup> buf) {
        buf.clear();
        buf.add(input);
        for (Operator op : this.operators) {
            Markup[] opInput = buf.toArray(new Markup[buf.size()]);
            buf.clear();
            for (Markup markup : opInput) {
                for (Markup opOutput : op.process(markup)) {
                    buf.add(opOutput);
                }
            }
        }
        buf.forEach(output::accept);
    }

    private MarkupPipeline(Operator[] operators) {
        this.operators = operators;
    }

    static {
        XML_INPUT_FACTORY.configureForRoundTripping();
    }

    public static class Builder {
        private final List<Operator> operators = new LinkedList<Operator>();

        public Builder filter(Predicate<Markup> filter) {
            return this.addOperator(input -> {
                Markup[] markupArray;
                if (filter.test(input)) {
                    Markup[] markupArray2 = new Markup[1];
                    markupArray = markupArray2;
                    markupArray2[0] = input;
                } else {
                    markupArray = EMPTY_RESULT;
                }
                return markupArray;
            });
        }

        public Builder map(Function<Markup, Markup> mapping) {
            return this.addOperator(input -> new Markup[]{(Markup)mapping.apply(input)});
        }

        public Builder addOperator(Operator op) {
            this.operators.add(op);
            return this;
        }

        public MarkupPipeline build() {
            return new MarkupPipeline(this.operators.toArray(new Operator[this.operators.size()]));
        }
    }

    public static interface Operator {
        public Markup[] process(Markup var1);
    }
}

