/*
 * Decompiled with CFR 0.152.
 */
package net.middell;

import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Predicate;
import net.middell.Markup;

public interface MarkupPredicates {
    public static Predicate<Markup> start(Predicate<Markup> start) {
        return markup -> markup.type == Markup.Type.START ? start.test((Markup)markup) : false;
    }

    public static Predicate<Markup> element(Predicate<Markup.Element> element) {
        return markup -> {
            switch (markup.type) {
                case START: {
                    return element.test(((Markup.Start)markup).element);
                }
                case END: {
                    return element.test(((Markup.End)markup).element);
                }
                case TEXT: {
                    return false;
                }
            }
            throw new IllegalArgumentException(markup.toString());
        };
    }

    public static Predicate<Markup.Element> localName(String ... localNames) {
        HashSet<String> localNameSet = new HashSet<String>(Arrays.asList(localNames));
        return element -> localNameSet.contains(element.localName);
    }
}

