/*
 * Decompiled with CFR 0.152.
 */
package net.middell;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.middell.Markup;

public interface Whitespace {
    public static Function<Markup, Markup> compress(final Predicate<Markup> container, final Function<Markup, Optional<Boolean>> preserveSpace) {
        return new Function<Markup, Markup>(){
            private final Deque<Boolean> containerContext = new ArrayDeque<Boolean>();
            private final Deque<Boolean> spacePreservationContext = new ArrayDeque<Boolean>();
            private char lastChar = (char)32;

            @Override
            public Markup apply(Markup markup) {
                switch (markup.type) {
                    case START_DOCUMENT: {
                        this.containerContext.clear();
                        this.spacePreservationContext.clear();
                        this.lastChar = (char)32;
                        break;
                    }
                    case START: {
                        Markup.Start markupStart = (Markup.Start)markup;
                        this.containerContext.push(container.test(markupStart));
                        this.spacePreservationContext.push(((Optional)preserveSpace.apply(markupStart)).orElseGet(() -> Optional.ofNullable(this.spacePreservationContext.peek()).orElse(false)));
                        break;
                    }
                    case END: {
                        this.containerContext.pop();
                        this.spacePreservationContext.pop();
                        break;
                    }
                    case TEXT: {
                        Markup.Text textMarkup = (Markup.Text)markup;
                        String text = textMarkup.text;
                        StringBuilder compressed = new StringBuilder();
                        boolean preserveSpace2 = Optional.ofNullable(this.spacePreservationContext.peek()).orElse(false);
                        int length = text.length();
                        for (int cc = 0; cc < length; ++cc) {
                            char currentChar = text.charAt(cc);
                            if (!preserveSpace2 && Character.isWhitespace(currentChar) && (Character.isWhitespace(this.lastChar) || !this.containerContext.isEmpty() && this.containerContext.peek().booleanValue())) continue;
                            if (currentChar == '\n' || currentChar == '\r') {
                                currentChar = ' ';
                            }
                            char c = currentChar;
                            this.lastChar = c;
                            compressed.append(c);
                        }
                        return new Markup.Text(textMarkup.sourceRange, compressed.toString());
                    }
                }
                return markup;
            }
        };
    }

    public static Function<Markup, Markup> breakLines(final Predicate<Markup> lineBreak) {
        return new Function<Markup, Markup>(){
            private boolean atStartOfText = true;
            private int introduceBreaks = 0;

            @Override
            public Markup apply(Markup markup) {
                if (markup.type == Markup.Type.START_DOCUMENT) {
                    this.atStartOfText = true;
                    this.introduceBreaks = 0;
                }
                if (!this.atStartOfText && lineBreak.test(markup)) {
                    ++this.introduceBreaks;
                }
                if (markup.type == Markup.Type.TEXT) {
                    Markup.Text textMarkup = (Markup.Text)markup;
                    String text = textMarkup.text;
                    if (text.trim().length() == 0) {
                        return markup;
                    }
                    if (!this.atStartOfText && this.introduceBreaks > 0) {
                        StringBuilder sb = new StringBuilder(this.introduceBreaks + text.length());
                        while (this.introduceBreaks > 0) {
                            sb.append("\n");
                            --this.introduceBreaks;
                        }
                        sb.append(text);
                        return new Markup.Text(textMarkup.sourceRange, sb.toString());
                    }
                    this.atStartOfText = false;
                }
                return markup;
            }
        };
    }

    public static Optional<Boolean> isSpacePreserved(Markup markup) {
        switch (markup.type) {
            case START: {
                return Optional.ofNullable(markup.asStart().element.attributes.getValue("http://www.w3.org/XML/1998/namespace", "space")).map("preserve"::equalsIgnoreCase);
            }
        }
        return Optional.empty();
    }
}

