/*
 * Decompiled with CFR 0.152.
 */
package net.middell;

import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XML {
    private static DocumentBuilderFactory documentBuilderFactory;
    private static TransformerFactory transformerFactory;
    private static XMLInputFactory inputFactory;
    private static XPathFactory xpathFactory;

    public static DocumentBuilder newDocumentBuilder() {
        try {
            if (documentBuilderFactory == null) {
                documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setXIncludeAware(true);
            }
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static XMLInputFactory inputFactory() {
        if (inputFactory == null) {
            inputFactory = XMLInputFactory.newFactory();
        }
        return inputFactory;
    }

    public static TransformerFactory transformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    public static Transformer newTransformer() {
        try {
            return XML.transformerFactory().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Transformer indentingTransformer(Transformer transformer) {
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        return transformer;
    }

    public static String toString(Node node) {
        try {
            StringWriter stringWriter = new StringWriter();
            Transformer transformer = XML.indentingTransformer(XML.newTransformer());
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public static XPathExpression xpath(String expression) {
        return XML.xpath(expression, null);
    }

    public static XPathExpression xpath(String expression, NamespaceContext nsCtx) {
        try {
            if (xpathFactory == null) {
                xpathFactory = XPathFactory.newInstance();
            }
            XPath xp = xpathFactory.newXPath();
            Optional.ofNullable(nsCtx).ifPresent(xp::setNamespaceContext);
            return xp.compile(expression);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public static Iterable<Node> nodes(final NodeList list) {
        final int nl = list.getLength();
        return () -> new Iterator<Node>(){
            private int nc = 0;

            @Override
            public boolean hasNext() {
                return this.nc < nl;
            }

            @Override
            public Node next() {
                return list.item(this.nc++);
            }
        };
    }

    public static Iterable<Node> nodes(XPathExpression xp, Object item) {
        try {
            return XML.nodes((NodeList)xp.evaluate(item, XPathConstants.NODESET));
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public static Iterable<Node> children(Node parent) {
        return XML.nodes(parent.getChildNodes());
    }

    public static <T> Iterable<T> nodesOfType(Iterable<Node> nodes, short nodeType, Class<T> type) {
        return XML.map(XML.filter(nodes, n -> n.getNodeType() == nodeType), type::cast);
    }

    public static Iterable<Element> elements(Iterable<Node> nodes) {
        return XML.nodesOfType(nodes, (short)1, Element.class);
    }

    public static Iterable<Element> elements(Element parent, String tagName) {
        return XML.elements(XML.nodes(parent.getElementsByTagName(tagName)));
    }

    public static NamespaceContext namespaceContext(Map<String, String> mappings) {
        final HashMap<String, String> forward = new HashMap<String, String>(mappings);
        final HashMap reverse = new HashMap();
        forward.put("xml", "http://www.w3.org/XML/1998/namespace");
        forward.put("xmlns", "http://www.w3.org/2000/xmlns/");
        forward.forEach((prefix, uri) -> reverse.put(uri, prefix));
        return new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return forward.getOrDefault(prefix, "");
            }

            @Override
            public String getPrefix(String nsUri) {
                return (String)reverse.get(nsUri);
            }

            public Iterator getPrefixes(String nsUri) {
                String prefix = this.getPrefix(nsUri);
                if (prefix == null) {
                    return Collections.emptySet().iterator();
                }
                return Collections.singleton(prefix).iterator();
            }
        };
    }

    public static <S, T> Iterable<T> map(Iterable<S> iterable, final Function<S, T> mapping) {
        return () -> {
            final Iterator it = iterable.iterator();
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public T next() {
                    return mapping.apply(it.next());
                }
            };
        };
    }

    public static <T> Iterable<T> filter(final Iterable<T> iterable, final Predicate<T> filter) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator it = iterable.iterator();
                return new Iterator<T>(){
                    private T next = null;

                    @Override
                    public boolean hasNext() {
                        while (it.hasNext()) {
                            Object candidate = it.next();
                            if (!filter.test(candidate)) continue;
                            this.next = candidate;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public T next() {
                        if (this.next == null) {
                            throw new IllegalStateException();
                        }
                        Object next = this.next;
                        this.next = null;
                        return next;
                    }
                };
            }
        };
    }
}

