/*
 * Decompiled with CFR 0.152.
 */
package net.nczonline.web.props2js;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Properties;
import java.util.regex.Pattern;

public class PropertyConverter {
    private static Pattern floatPattern = Pattern.compile("^[0-9]+(\\.[0-9]+)?$");
    private static Pattern intPattern = Pattern.compile("^[0-9]+$");

    public static String convertToJson(Properties properties) {
        JsonObject json = new JsonObject();
        for (Object key : properties.keySet()) {
            String value = properties.getProperty(key.toString());
            if (value.equals("true") || value.equals("false")) {
                json.addProperty(key.toString(), Boolean.parseBoolean(value));
                continue;
            }
            if (intPattern.matcher(value).matches()) {
                json.addProperty(key.toString(), Integer.parseInt(value));
                continue;
            }
            if (floatPattern.matcher(value).matches()) {
                json.addProperty(key.toString(), Float.valueOf(Float.parseFloat(value)));
                continue;
            }
            json.addProperty(key.toString(), value);
        }
        return new Gson().toJson(json);
    }

    public static String convertToJsonP(Properties properties, String callback) {
        return callback + "(" + PropertyConverter.convertToJson(properties) + ");";
    }

    public static String convertToJavaScript(Properties properties, String variable) {
        String result = variable + "=" + PropertyConverter.convertToJson(properties) + ";";
        if (!variable.contains(".")) {
            result = "var " + result;
        }
        return result;
    }

    public static String convertToPodsModule(Properties properties, String moduleName) {
        return "Pod.declare('" + moduleName + "', " + PropertyConverter.convertToJson(properties) + ");";
    }
}

