/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import net.nicholaswilliams.java.licensing.DataSignatureManager;
import net.nicholaswilliams.java.licensing.ObjectSerializer;
import net.nicholaswilliams.java.licensing.exception.InvalidSignatureException;
import org.apache.commons.codec.binary.Base64;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDataSignatureManager {
    private static final String privateKeyString = "rO0ABXNyABRqYXZhLnNlY3VyaXR5LktleVJlcL35T7OImqVDAgAETAAJYWxnb3JpdGhtdAASTGphdmEvbGFuZy9TdHJpbmc7WwAHZW5jb2RlZHQAAltCTAAGZm9ybWF0cQB+AAFMAAR0eXBldAAbTGphdmEvc2VjdXJpdHkvS2V5UmVwJFR5cGU7eHB0AANSU0F1cgACW0Ks8xf4BghU4AIAAHhwAAAEwDCCBLwCAQAwDQYJKoZIhvcNAQEBBQAEggSmMIIEogIBAAKCAQEAkJ69eXODVaSFdxLPg5MmP6XNJ5KJSZCeCwoYS+fRupBfBzBlUhmvRUD2DX33QqqaTuW2sRm4o0ho9yu1dnlihZQCSwzERaVe023AuyXk6MLzSgBk31Sp0d7J71nnMDouvA43Y8QecgmZmVM4l70niL4L9Jfnb/cChtOYJlh5sGCfhBqJfYmV1znDTi63MNup6T2lRMDLbW12Occ6wV5JPUQtHFJCrMNg8KDXZ6EyHLl693np4h71Lywcf6WUkGe8qxwNU4dtz7lyjO9VOml0CwqLnW20h72Pl+pL1QTjoAs87KT1R2KVVcyfPlLZoGHh3UAhOzrQNu1KJuSKT4vtOQIDAQABAoIBAETGqTcb/yZ4glxZXsSk8zirogAiyRVqKC750wouKeh+hiLGGjlMK7VUqm9KK4/R0GabCiH5KHzGj9yUNc0s9vStqdWFMcYpWgpUlKar48vqAod73nzzJ3u+ZuxkJfUihl06qY7RkuUKubhYAn7vHuEB+G+O2iq+Hr593ErIIr8EzW376/bgU15L+Wt1dtpeF7xSrH+s9goH3KdAw1ABFPVFTq37Ee6ygmMVx3yUfteUFssHY6wCQ8bD/IOfjagQfVMLrl5qqGw2EZjB1yqahH+Id7Ktuc/zqcrjxhEVrcITqqxJA5BDsodkFvHHrHNb4w/R/qeKDUQOJQGh+Ts4tbECgYEAw6ywHpDlRhBxF0WjOFZ5KjVBkaY5iCp1l6Ef1oTvyjkT1YGb9M/SJhQbd5mFNaUt4EChmIixkDEh7ixYLReIonjWVqTJZrllIVWXkDFxMdQgt2HTUyouCRrpsD5PdFhuVKPwfU09u+Bj46cyKX3j1OsPmoPk1JiWbA6Oh8OHGk0CgYEAvTSn8qJ8MX7Jdn3+xhv7EdLMrzPV2L6xmljFiBdeHj0Aaj03YHPsz2lewaMNeiVd3eThxjqJImLh+vFmvdO/edeEj/Qh5H/6ycnIi8Xbdc4Y4DlKnsIYBk6hd63XRuLd8kfWPKV9fqEotidj29T76maxoIk3u6X/26x/OEOB/J0CgYA1Nt6CwYcIwenvmUmlRacX+nnFgX498MYgIXqGHYsU5Obm9qOSNX6CSo+ZvA+FIlHSneEUmYAopaQDoN2uDatj/BbWY2Q+YocFRMC+PyP4mCb5mEofYOY6Ja6N9rQnAPGoZRk/CmWSlZi0zcCPliQCwJZywBHYW1L1OhQ7CcrRNQKBgGZ649DG82+3lZVJjzpso2O3AsiO0fAw8W+BT5Rz27WTIutoNttWTtjU4M8O6tjS7nGmbCd7QxXN60qJgDWnQFnVQubZu5XRP9wWIDqcs06uj8i7H1C4Hl0kL87r6ONrM/3rrP1yQXPaBHwM/8htJvmCIAms6PQJaHjqiInH/tr9AoGAJkhDzSkQEDRQ8y+Sb1YT4XPXZANQtu6wE8UlX3DMPbyCHoMiuS/UZX1nTabu588RPgP3Gm5ZmVamoKTspzZHKTwszdDcXq2pLlg0sP4TvRk0YPNScDOvnEP/Bvvhft2mj6zUnp6tZaYuhFBaYwV/CxpANbAPwA2CqJxhaZ0ELcV0AAZQS0NTIzh+cgAZamF2YS5zZWN1cml0eS5LZXlSZXAkVHlwZQAAAAAAAAAAEgAAeHIADmphdmEubGFuZy5FbnVtAAAAAAAAAAASAAB4cHQAB1BSSVZBVEU=";
    private static final String publicKeyString = "rO0ABXNyABRqYXZhLnNlY3VyaXR5LktleVJlcL35T7OImqVDAgAETAAJYWxnb3JpdGhtdAASTGphdmEvbGFuZy9TdHJpbmc7WwAHZW5jb2RlZHQAAltCTAAGZm9ybWF0cQB+AAFMAAR0eXBldAAbTGphdmEvc2VjdXJpdHkvS2V5UmVwJFR5cGU7eHB0AANSU0F1cgACW0Ks8xf4BghU4AIAAHhwAAABJjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJCevXlzg1WkhXcSz4OTJj+lzSeSiUmQngsKGEvn0bqQXwcwZVIZr0VA9g1990Kqmk7ltrEZuKNIaPcrtXZ5YoWUAksMxEWlXtNtwLsl5OjC80oAZN9UqdHeye9Z5zA6LrwON2PEHnIJmZlTOJe9J4i+C/SX52/3AobTmCZYebBgn4QaiX2Jldc5w04utzDbqek9pUTAy21tdjnHOsFeST1ELRxSQqzDYPCg12ehMhy5evd56eIe9S8sHH+llJBnvKscDVOHbc+5cozvVTppdAsKi51ttIe9j5fqS9UE46ALPOyk9UdilVXMnz5S2aBh4d1AITs60DbtSibkik+L7TkCAwEAAXQABVguNTA5fnIAGWphdmEuc2VjdXJpdHkuS2V5UmVwJFR5cGUAAAAAAAAAABIAAHhyAA5qYXZhLmxhbmcuRW51bQAAAAAAAAAAEgAAeHB0AAZQVUJMSUM=";
    private static final PrivateKey privateKey;
    private static final PublicKey publicKey;
    private DataSignatureManager manager = new DataSignatureManager();

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSignature01() {
        byte[] byArray = new byte[]{2, 3, 5, 7, 11, 13, 17};
        byte[] byArray2 = this.manager.signData(privateKey, byArray);
        this.manager.verifySignature(publicKey, byArray, byArray2);
    }

    @Test(expected=InvalidSignatureException.class)
    public void testSignature02() {
        byte[] byArray = new byte[]{2, 3, 5, 7, 11, 13, 17};
        byte[] byArray2 = this.manager.signData(privateKey, byArray);
        byArray[4] = 76;
        this.manager.verifySignature(publicKey, byArray, byArray2);
    }

    @Test
    public void testSignature03() {
        byte[] byArray = Arrays.copyOf(new byte[]{19, 23, 29, 31, 37, 41, 43}, 629383);
        byte[] byArray2 = this.manager.signData(privateKey, byArray);
        this.manager.verifySignature(publicKey, byArray, byArray2);
    }

    @Test(expected=InvalidSignatureException.class)
    public void testSignature04() {
        byte[] byArray = Arrays.copyOf(new byte[]{19, 23, 29, 31, 37, 41, 43}, 629383);
        byte[] byArray2 = this.manager.signData(privateKey, byArray);
        byArray[6983] = 76;
        this.manager.verifySignature(publicKey, byArray, byArray2);
    }

    static {
        ObjectSerializer objectSerializer = new ObjectSerializer();
        privateKey = (PrivateKey)objectSerializer.readObject(PrivateKey.class, Base64.decodeBase64((String)privateKeyString));
        publicKey = (PublicKey)objectSerializer.readObject(PublicKey.class, Base64.decodeBase64((String)publicKeyString));
    }
}

