/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.nicholaswilliams.java.licensing.DefaultLicenseValidator;
import net.nicholaswilliams.java.licensing.License;
import net.nicholaswilliams.java.licensing.exception.ExpiredLicenseException;
import net.nicholaswilliams.java.licensing.exception.InvalidLicenseException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultLicenseValidator {
    private DefaultLicenseValidator validator;

    @Before
    public void setUp() {
        this.validator = new DefaultLicenseValidator();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetLicenseDescription() {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(57).addFeature("nickFeature1").addFeature("allisonFeature2").build();
        Assert.assertEquals((String)"The description is not correct.", (Object)("Simple Product Name(TM) license for " + license.getHolder()), (Object)this.validator.getLicenseDescription(license));
    }

    @Test
    public void testGetFormattedDate() {
        Calendar calendar = Calendar.getInstance();
        Assert.assertEquals((String)"The formatted date is not correct.", (Object)new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z (Z)").format(new Date(calendar.getTimeInMillis())), (Object)this.validator.getFormattedDate(calendar.getTimeInMillis()));
    }

    @Test(expected=InvalidLicenseException.class)
    public void testValidateLicense01() {
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTimeInMillis() + 1000L;
        long l2 = calendar.getTimeInMillis() + 87400L;
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(l).withGoodBeforeDate(l2).withNumberOfLicenses(57).addFeature("nickFeature1").addFeature("allisonFeature2").build();
        this.validator.validateLicense(license);
    }

    @Test(expected=InvalidLicenseException.class)
    public void testValidateLicense02() {
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTimeInMillis() + 1000L;
        long l2 = calendar.getTimeInMillis() - 1000L;
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(l).withGoodBeforeDate(l2).withNumberOfLicenses(57).addFeature("nickFeature1").addFeature("allisonFeature2").build();
        this.validator.validateLicense(license);
    }

    @Test(expected=ExpiredLicenseException.class)
    public void testValidateLicense03() {
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTimeInMillis() - 2000L;
        long l2 = calendar.getTimeInMillis() - 1000L;
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(l).withGoodBeforeDate(l2).withNumberOfLicenses(57).addFeature("nickFeature1").addFeature("allisonFeature2").build();
        this.validator.validateLicense(license);
    }

    @Test
    public void testValidateLicense04() {
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTimeInMillis() - 1000L;
        long l2 = calendar.getTimeInMillis() + 85400L;
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(l).withGoodBeforeDate(l2).withNumberOfLicenses(57).addFeature("nickFeature1").addFeature("allisonFeature2").build();
        this.validator.validateLicense(license);
    }
}

