/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import java.io.Serializable;
import net.nicholaswilliams.java.licensing.DeserializingLicenseProvider;
import net.nicholaswilliams.java.licensing.ObjectSerializer;
import net.nicholaswilliams.java.licensing.SignedLicense;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDeserializingLicenseProvider {
    private DeserializingLicenseProvider provider;

    @Before
    public void setUp() {
        this.provider = (DeserializingLicenseProvider)EasyMock.createMockBuilder(DeserializingLicenseProvider.class).addMockedMethod("getLicenseData").createStrictMock();
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.provider});
    }

    @Test
    public void testGetLicense01() {
        EasyMock.expect((Object)this.provider.getLicenseData((Object)"nullCustomer01")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.provider});
        SignedLicense signedLicense = this.provider.getLicense((Object)"nullCustomer01");
        Assert.assertNull((String)"The retrieved license should be null.", (Object)signedLicense);
    }

    @Test
    public void testGetLicense02() {
        byte[] byArray = new byte[]{31};
        byte[] byArray2 = new byte[]{47};
        SignedLicense signedLicense = new SignedLicense(byArray, byArray2);
        byte[] byArray3 = new ObjectSerializer().writeObject((Serializable)signedLicense);
        EasyMock.expect((Object)this.provider.getLicenseData((Object)"testCustomer02")).andReturn((Object)byArray3);
        EasyMock.replay((Object[])new Object[]{this.provider});
        SignedLicense signedLicense2 = this.provider.getLicense((Object)"testCustomer02");
        Assert.assertNotNull((String)"The retrieved license should not be null.", (Object)signedLicense2);
        Assert.assertArrayEquals((String)"The license is not correct.", (byte[])byArray, (byte[])signedLicense2.getLicenseContent());
        Assert.assertArrayEquals((String)"The signature is not correct.", (byte[])byArray2, (byte[])signedLicense2.getSignatureContent());
    }

    @Test
    public void testGetLicense03() {
        byte[] byArray = new byte[]{63};
        byte[] byArray2 = new byte[]{79};
        SignedLicense signedLicense = new SignedLicense(byArray, byArray2);
        byte[] byArray3 = new ObjectSerializer().writeObject((Serializable)signedLicense);
        EasyMock.expect((Object)this.provider.getLicenseData((Object)"anotherCustomer03")).andReturn((Object)byArray3);
        EasyMock.replay((Object[])new Object[]{this.provider});
        SignedLicense signedLicense2 = this.provider.getLicense((Object)"anotherCustomer03");
        Assert.assertNotNull((String)"The retrieved license should not be null.", (Object)signedLicense2);
        Assert.assertArrayEquals((String)"The license is not correct.", (byte[])byArray, (byte[])signedLicense2.getLicenseContent());
        Assert.assertArrayEquals((String)"The signature is not correct.", (byte[])byArray2, (byte[])signedLicense2.getSignatureContent());
    }
}

