/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import net.nicholaswilliams.java.licensing.FileLicenseProvider;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFileLicenseProvider {
    private FileLicenseProvider provider;

    @Before
    public void setUp() {
        this.provider = new FileLicenseProvider();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testConstructor01() {
        Assert.assertSame((String)"The class loader is not correct.", (Object)FileLicenseProvider.class.getClassLoader(), (Object)this.provider.classLoader);
        Assert.assertFalse((String)"The classpath should be false.", (boolean)this.provider.isFileOnClasspath());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor02() {
        this.provider = new FileLicenseProvider(null);
    }

    @Test
    public void testConstructor03() {
        ClassLoader classLoader = (ClassLoader)EasyMock.createMockBuilder(ClassLoader.class).createStrictMock();
        EasyMock.replay((Object[])new Object[]{classLoader});
        this.provider = new FileLicenseProvider(classLoader);
        Assert.assertSame((String)"The class loader is not correct.", (Object)classLoader, (Object)this.provider.classLoader);
        Assert.assertTrue((String)"The classpath flag should be true.", (boolean)this.provider.isFileOnClasspath());
    }

    @Test
    public void testSetBase64Encoded() {
        Assert.assertFalse((String)"base64Encoded should be false.", (boolean)this.provider.isBase64Encoded());
        this.provider.setBase64Encoded(true);
        Assert.assertTrue((String)"base64Encoded should be true now.", (boolean)this.provider.isBase64Encoded());
        this.provider.setBase64Encoded(false);
        Assert.assertFalse((String)"base64Encoded should be false again.", (boolean)this.provider.isBase64Encoded());
    }

    @Test
    public void testSetFileOnClasspath() {
        Assert.assertFalse((String)"fileOnClasspath should be false.", (boolean)this.provider.isFileOnClasspath());
        this.provider.setFileOnClasspath(true);
        Assert.assertTrue((String)"fileOnClasspath should be true now.", (boolean)this.provider.isFileOnClasspath());
        this.provider.setFileOnClasspath(false);
        Assert.assertFalse((String)"fileOnClasspath should be false again.", (boolean)this.provider.isFileOnClasspath());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetFilePrefix01() {
        Assert.assertEquals((String)"The prefix should be blank.", (Object)"", (Object)this.provider.getFilePrefix());
        this.provider.setFilePrefix(null);
    }

    @Test
    public void testSetFilePrefix02() {
        Assert.assertEquals((String)"The prefix should be blank.", (Object)"", (Object)this.provider.getFilePrefix());
        this.provider.setFilePrefix("test01");
        Assert.assertEquals((String)"The prefix is not correct.", (Object)"test01", (Object)this.provider.getFilePrefix());
    }

    @Test
    public void testSetFilePrefix03() {
        Assert.assertEquals((String)"The prefix should be blank.", (Object)"", (Object)this.provider.getFilePrefix());
        this.provider.setFilePrefix("");
        Assert.assertEquals((String)"The prefix is not correct.", (Object)"", (Object)this.provider.getFilePrefix());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetFileSuffix01() {
        Assert.assertEquals((String)"The suffix should be blank.", (Object)"", (Object)this.provider.getFileSuffix());
        this.provider.setFileSuffix(null);
    }

    @Test
    public void testSetFileSuffix02() {
        Assert.assertEquals((String)"The suffix should be blank.", (Object)"", (Object)this.provider.getFileSuffix());
        this.provider.setFileSuffix("test01");
        Assert.assertEquals((String)"The suffix is not correct.", (Object)"test01", (Object)this.provider.getFileSuffix());
    }

    @Test
    public void testSetFileSuffix03() {
        Assert.assertEquals((String)"The suffix should be blank.", (Object)"", (Object)this.provider.getFileSuffix());
        this.provider.setFileSuffix("");
        Assert.assertEquals((String)"The suffix is not correct.", (Object)"", (Object)this.provider.getFileSuffix());
    }

    @Test
    public void testGetLicenseFile01() {
        File file = this.provider.getLicenseFile((Object)"file01");
        Assert.assertNotNull((String)"The file should not null.", (Object)file);
        Assert.assertEquals((String)"The file name is not correct.", (Object)"file01", (Object)file.getPath());
    }

    @Test
    public void testGetLicenseFile02() {
        this.provider.setFilePrefix("prefix02/");
        this.provider.setFileSuffix(".suffix");
        File file = this.provider.getLicenseFile((Object)"file03");
        Assert.assertNotNull((String)"The file should not null.", (Object)file);
        Assert.assertEquals((String)"The file name is not correct.", (Object)("prefix02" + System.getProperty("file.separator") + "file03.suffix"), (Object)file.getPath());
    }

    @Test
    public void testGetLicenseFile03() throws IOException {
        File file;
        URL uRL = this.getClass().getClassLoader().getResource("");
        Assert.assertNotNull((String)"The URL should not be null.", (Object)uRL);
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uRL.getPath());
        }
        file = new File(file, "net/nicholaswilliams/java/licensing/testGetLicenseFile03.lic");
        FileUtils.writeStringToFile((File)file, (String)"temp");
        this.provider.setFilePrefix("net/nicholaswilliams/java/licensing/");
        this.provider.setFileSuffix(".lic");
        this.provider.setFileOnClasspath(true);
        File file2 = this.provider.getLicenseFile((Object)"testGetLicenseFile03");
        Assert.assertNotNull((String)"The file should not null.", (Object)file2);
        Assert.assertEquals((String)"The file name is not correct.", (Object)file.getPath(), (Object)file2.getPath());
        FileUtils.forceDelete((File)file);
    }

    @Test
    public void testGetLicenseFile04() throws IOException {
        File file;
        URL uRL = this.getClass().getClassLoader().getResource("");
        Assert.assertNotNull((String)"The URL should not be null.", (Object)uRL);
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uRL.getPath());
        }
        file = new File(file, "net/nicholaswilliams/java/licensing/licensor/testGetLicenseFile04.prop");
        FileUtils.writeStringToFile((File)file, (String)"temp");
        this.provider.setFilePrefix("/net/nicholaswilliams/java/licensing/licensor/");
        this.provider.setFileSuffix(".prop");
        this.provider.setFileOnClasspath(true);
        File file2 = this.provider.getLicenseFile((Object)"testGetLicenseFile04");
        Assert.assertNotNull((String)"The file should not null.", (Object)file2);
        Assert.assertEquals((String)"The file name is not correct.", (Object)file.getPath(), (Object)file2.getPath());
        FileUtils.forceDelete((File)file);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLicenseData01() {
        this.provider.getLicenseData(null);
    }

    @Test
    public void testGetLicenseData02() {
        this.provider = (FileLicenseProvider)EasyMock.createMockBuilder(FileLicenseProvider.class).addMockedMethod("getLicenseFile").createStrictMock();
        EasyMock.expect((Object)this.provider.getLicenseFile((Object)"test02")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.provider});
        byte[] byArray = this.provider.getLicenseData((Object)"test02");
        Assert.assertNull((String)"The data should be null.", (Object)byArray);
    }

    @Test
    public void testGetLicenseData03() {
        this.provider = (FileLicenseProvider)EasyMock.createMockBuilder(FileLicenseProvider.class).addMockedMethod("getLicenseFile").createStrictMock();
        EasyMock.expect((Object)this.provider.getLicenseFile((Object)"another03")).andReturn((Object)new File("file03"));
        EasyMock.replay((Object[])new Object[]{this.provider});
        byte[] byArray = this.provider.getLicenseData((Object)"another03");
        Assert.assertNull((String)"The data should be null.", (Object)byArray);
    }

    @Test
    public void testGetLicenseData04() throws IOException {
        File file = new File("testGetLicenseData04.lic");
        FileUtils.writeStringToFile((File)file, (String)"test get 04");
        this.provider = (FileLicenseProvider)EasyMock.createMockBuilder(FileLicenseProvider.class).addMockedMethod("getLicenseFile").createStrictMock();
        EasyMock.expect((Object)this.provider.getLicenseFile((Object)"test04")).andReturn((Object)new File("testGetLicenseData04.lic"));
        EasyMock.replay((Object[])new Object[]{this.provider});
        byte[] byArray = this.provider.getLicenseData((Object)"test04");
        Assert.assertNotNull((String)"The data should not be null.", (Object)byArray);
        Assert.assertEquals((String)"The data is not correct.", (Object)"test get 04", (Object)new String(byArray));
        FileUtils.forceDelete((File)file);
    }

    @Test
    public void testGetLicenseData05() throws IOException {
        File file = new File("testGetLicenseData05.lic");
        FileUtils.writeByteArrayToFile((File)file, (byte[])Base64.encodeBase64((byte[])"another get 05".getBytes()));
        this.provider = (FileLicenseProvider)EasyMock.createMockBuilder(FileLicenseProvider.class).addMockedMethod("getLicenseFile").createStrictMock();
        EasyMock.expect((Object)this.provider.getLicenseFile((Object)"test05")).andReturn((Object)new File("testGetLicenseData05.lic"));
        EasyMock.replay((Object[])new Object[]{this.provider});
        this.provider.setBase64Encoded(true);
        byte[] byArray = this.provider.getLicenseData((Object)"test05");
        Assert.assertNotNull((String)"The data should not be null.", (Object)byArray);
        Assert.assertEquals((String)"The data is not correct.", (Object)"another get 05", (Object)new String(byArray));
        FileUtils.forceDelete((File)file);
    }
}

