/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.nicholaswilliams.java.licensing.FeatureObject;
import net.nicholaswilliams.java.licensing.License;
import net.nicholaswilliams.java.licensing.immutable.ImmutableLinkedHashSet;
import net.nicholaswilliams.java.licensing.mock.MockFeatureObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLicense {
    private License license;

    @Before
    public void setUp() {
        this.license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(57).addFeature("nickFeature1").addFeature("allisonFeature2", 2348917325000L).build();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testConstructorParts01() throws NoSuchMethodException, InstantiationException, IllegalAccessException {
        Constructor constructor = License.class.getDeclaredConstructor(String[].class);
        constructor.setAccessible(true);
        try {
            Object var2_2 = null;
            constructor.newInstance(var2_2);
            Assert.fail((String)"Expected exception IllegalArgumentException.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Assert.assertNotNull((String)"The cause should not be null.", (Object)invocationTargetException.getCause());
            Assert.assertSame((String)"The cause is not correct.", IllegalArgumentException.class, invocationTargetException.getCause().getClass());
        }
    }

    @Test
    public void testConstructorParts02() throws NoSuchMethodException, InstantiationException, IllegalAccessException {
        Constructor constructor = License.class.getDeclaredConstructor(String[].class);
        constructor.setAccessible(true);
        try {
            String[] stringArray = new String[]{};
            constructor.newInstance(new Object[]{stringArray});
            Assert.fail((String)"Expected exception IllegalArgumentException.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Assert.assertNotNull((String)"The cause should not be null.", (Object)invocationTargetException.getCause());
            Assert.assertSame((String)"The cause is not correct.", IllegalArgumentException.class, invocationTargetException.getCause().getClass());
        }
    }

    @Test
    public void testConstructorParts03() throws NoSuchMethodException, InstantiationException, IllegalAccessException {
        Constructor constructor = License.class.getDeclaredConstructor(String[].class);
        constructor.setAccessible(true);
        try {
            String[] stringArray = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight"};
            constructor.newInstance(new Object[]{stringArray});
            Assert.fail((String)"Expected exception IllegalArgumentException.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Assert.assertNotNull((String)"The cause should not be null.", (Object)invocationTargetException.getCause());
            Assert.assertSame((String)"The cause is not correct.", IllegalArgumentException.class, invocationTargetException.getCause().getClass());
        }
    }

    @Test
    public void testConstructorParts04() throws NoSuchMethodException, InstantiationException, IllegalAccessException {
        Constructor constructor = License.class.getDeclaredConstructor(String[].class);
        constructor.setAccessible(true);
        try {
            String[] stringArray = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten"};
            constructor.newInstance(new Object[]{stringArray});
            Assert.fail((String)"Expected exception IllegalArgumentException.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Assert.assertNotNull((String)"The cause should not be null.", (Object)invocationTargetException.getCause());
            Assert.assertSame((String)"The cause is not correct.", IllegalArgumentException.class, invocationTargetException.getCause().getClass());
        }
    }

    @Test
    public void testProductKey01() {
        Assert.assertEquals((String)"The product key is not correct.", (Object)"5565-1039-AF89-GGX7-TN31-14AL", (Object)this.license.getProductKey());
    }

    @Test
    public void testIssuer01() {
        Assert.assertEquals((String)"The issuer is not correct.", (Object)"CN=Nick Williams, C=US, ST=TN", (Object)this.license.getIssuer());
    }

    @Test
    public void testHolder01() {
        Assert.assertEquals((String)"The holder is not correct.", (Object)"CN=Tim Williams, C=US, ST=AL", (Object)this.license.getHolder());
    }

    @Test
    public void testSubject01() {
        Assert.assertEquals((String)"The subject is not correct.", (Object)"Simple Product Name(TM)", (Object)this.license.getSubject());
    }

    @Test
    public void testIssueDate01() {
        Assert.assertEquals((String)"The issue date is not correct.", (long)2348907324983L, (long)this.license.getIssueDate());
    }

    @Test
    public void testGoodAfterDate01() {
        Assert.assertEquals((String)"The good after date is not correct.", (long)2348907325000L, (long)this.license.getGoodAfterDate());
    }

    @Test
    public void testGoodBeforeDate01() {
        Assert.assertEquals((String)"The good before date is not correct.", (long)2348917325000L, (long)this.license.getGoodBeforeDate());
    }

    @Test
    public void testNumberOfLicenses01() {
        Assert.assertEquals((String)"The number of licenses is not correct.", (long)57L, (long)this.license.getNumberOfLicenses());
    }

    @Test
    public void testFeatures01() {
        ImmutableLinkedHashSet immutableLinkedHashSet = this.license.getFeatures();
        Assert.assertEquals((String)"The size of the features is not correct.", (long)2L, (long)immutableLinkedHashSet.size());
        Assert.assertNotNull((String)"Feature 1 is missing.", (Object)immutableLinkedHashSet.get(0));
        Assert.assertEquals((String)"Feature 1 is not correct.", (Object)"nickFeature1", (Object)((License.Feature)immutableLinkedHashSet.get(0)).getName());
        Assert.assertNotNull((String)"Feature 2 is missing.", (Object)immutableLinkedHashSet.get(1));
        Assert.assertEquals((String)"Feature 2 is not correct.", (Object)"allisonFeature2", (Object)((License.Feature)immutableLinkedHashSet.get(1)).getName());
        Assert.assertEquals((String)"Feature 2 is not correct.", (long)2348917325000L, (long)((License.Feature)immutableLinkedHashSet.get(1)).getGoodBeforeDate());
    }

    @Test
    public void testFeatures02() {
        Assert.assertTrue((String)"Feature 1 is missing.", (boolean)this.license.hasLicenseForAllFeatures(new String[]{"nickFeature1"}));
        Assert.assertTrue((String)"Feature 2 is missing.", (boolean)this.license.hasLicenseForAllFeatures(new String[]{"allisonFeature2"}));
        Assert.assertTrue((String)"Feature 1 is missing now.", (boolean)this.license.hasLicenseForFeature("nickFeature1"));
        Assert.assertTrue((String)"Feature 2 is missing now.", (boolean)this.license.hasLicenseForFeature("allisonFeature2"));
        Assert.assertFalse((String)"There's a phantom feature.", (boolean)this.license.hasLicenseForFeature("fakeFeature3"));
    }

    @Test
    public void testFeatures03() {
        Assert.assertTrue((String)"Result 1 is incorrect.", (boolean)this.license.hasLicenseForAllFeatures(new String[]{"nickFeature1", "allisonFeature2"}));
        Assert.assertFalse((String)"Result 2 is incorrect.", (boolean)this.license.hasLicenseForAllFeatures(new String[]{"timFeature1", "allisonFeature2"}));
        Assert.assertFalse((String)"Result 3 is incorrect.", (boolean)this.license.hasLicenseForAllFeatures(new String[]{"nickFeature1", "timFeature2"}));
        Assert.assertFalse((String)"Result 4 is incorrect.", (boolean)this.license.hasLicenseForAllFeatures(new String[]{"nickFeature1", "allisonFeature2", "timFeature3"}));
        Assert.assertFalse((String)"Result 5 is incorrect.", (boolean)this.license.hasLicenseForAllFeatures(new String[]{"jeffFeature1", "timFeature2"}));
        Assert.assertFalse((String)"Result 6 is incorrect.", (boolean)this.license.hasLicenseForAllFeatures(new String[]{"dogFeature1"}));
    }

    @Test
    public void testFeatures04() {
        Assert.assertTrue((String)"Result 1 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new String[]{"nickFeature1", "allisonFeature2"}));
        Assert.assertTrue((String)"Result 2 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new String[]{"timFeature1", "allisonFeature2"}));
        Assert.assertTrue((String)"Result 3 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new String[]{"nickFeature1", "timFeature2"}));
        Assert.assertTrue((String)"Result 4 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new String[]{"nickFeature1", "allisonFeature2", "timFeature3"}));
        Assert.assertFalse((String)"Result 5 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new String[]{"jeffFeature1", "timFeature2"}));
        Assert.assertFalse((String)"Result 6 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new String[]{"dogFeature1"}));
        Assert.assertTrue((String)"Result 7 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new String[]{"nickFeature1"}));
        Assert.assertTrue((String)"Result 8 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new String[]{"allisonFeature2"}));
    }

    @Test
    public void testFeatures05() {
        this.license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(57).addFeature("goodFeature1").addFeature("goodFeature2", 2348917325000L).addFeature("expiredFeature3", 1L).build();
        Assert.assertTrue((String)"Feature 1 is missing now.", (boolean)this.license.hasLicenseForFeature("goodFeature1"));
        Assert.assertTrue((String)"Feature 2 is missing now.", (boolean)this.license.hasLicenseForFeature("goodFeature2"));
        Assert.assertFalse((String)"There's a phantom feature.", (boolean)this.license.hasLicenseForFeature("expiredFeature3"));
        Assert.assertTrue((String)"Error 1", (boolean)this.license.hasLicenseForAnyFeature(new String[]{"goodFeature1", "expiredFeature3"}));
        Assert.assertFalse((String)"Error 2", (boolean)this.license.hasLicenseForAnyFeature(new String[]{"expiredFeature3"}));
        Assert.assertTrue((String)"Error 3", (boolean)this.license.hasLicenseForAllFeatures(new String[]{"goodFeature1", "goodFeature2"}));
        Assert.assertFalse((String)"Error 4", (boolean)this.license.hasLicenseForAllFeatures(new String[]{"goodFeature1", "expiredFeature3"}));
        Assert.assertFalse((String)"Error 5", (boolean)this.license.hasLicenseForAllFeatures(new String[]{"expiredFeature3"}));
    }

    @Test
    public void testFeatures06() {
        Assert.assertTrue((String)"Feature 1 is missing.", (boolean)this.license.hasLicenseForAllFeatures(new FeatureObject[]{new MockFeatureObject("nickFeature1")}));
        Assert.assertTrue((String)"Feature 2 is missing.", (boolean)this.license.hasLicenseForAllFeatures(new FeatureObject[]{new MockFeatureObject("allisonFeature2")}));
        Assert.assertTrue((String)"Feature 1 is missing now.", (boolean)this.license.hasLicenseForFeature((FeatureObject)new MockFeatureObject("nickFeature1")));
        Assert.assertTrue((String)"Feature 2 is missing now.", (boolean)this.license.hasLicenseForFeature((FeatureObject)new MockFeatureObject("allisonFeature2")));
        Assert.assertFalse((String)"There's a phantom feature.", (boolean)this.license.hasLicenseForFeature((FeatureObject)new MockFeatureObject("fakeFeature3")));
    }

    @Test
    public void testFeatures07() {
        Assert.assertTrue((String)"Result 1 is incorrect.", (boolean)this.license.hasLicenseForAllFeatures(new FeatureObject[]{new MockFeatureObject("nickFeature1"), new MockFeatureObject("allisonFeature2")}));
        Assert.assertFalse((String)"Result 2 is incorrect.", (boolean)this.license.hasLicenseForAllFeatures(new FeatureObject[]{new MockFeatureObject("timFeature1"), new MockFeatureObject("allisonFeature2")}));
        Assert.assertFalse((String)"Result 3 is incorrect.", (boolean)this.license.hasLicenseForAllFeatures(new FeatureObject[]{new MockFeatureObject("nickFeature1"), new MockFeatureObject("timFeature2")}));
        Assert.assertFalse((String)"Result 4 is incorrect.", (boolean)this.license.hasLicenseForAllFeatures(new FeatureObject[]{new MockFeatureObject("nickFeature1"), new MockFeatureObject("allisonFeature2"), new MockFeatureObject("timFeature3")}));
        Assert.assertFalse((String)"Result 5 is incorrect.", (boolean)this.license.hasLicenseForAllFeatures(new FeatureObject[]{new MockFeatureObject("jeffFeature1"), new MockFeatureObject("timFeature2")}));
        Assert.assertFalse((String)"Result 6 is incorrect.", (boolean)this.license.hasLicenseForAllFeatures(new FeatureObject[]{new MockFeatureObject("dogFeature1")}));
    }

    @Test
    public void testFeatures08() {
        Assert.assertTrue((String)"Result 1 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new FeatureObject[]{new MockFeatureObject("nickFeature1"), new MockFeatureObject("allisonFeature2")}));
        Assert.assertTrue((String)"Result 2 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new FeatureObject[]{new MockFeatureObject("timFeature1"), new MockFeatureObject("allisonFeature2")}));
        Assert.assertTrue((String)"Result 3 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new FeatureObject[]{new MockFeatureObject("nickFeature1"), new MockFeatureObject("timFeature2")}));
        Assert.assertTrue((String)"Result 4 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new FeatureObject[]{new MockFeatureObject("nickFeature1"), new MockFeatureObject("allisonFeature2"), new MockFeatureObject("timFeature3")}));
        Assert.assertFalse((String)"Result 5 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new FeatureObject[]{new MockFeatureObject("jeffFeature1"), new MockFeatureObject("timFeature2")}));
        Assert.assertFalse((String)"Result 6 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new FeatureObject[]{new MockFeatureObject("dogFeature1")}));
        Assert.assertTrue((String)"Result 7 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new FeatureObject[]{new MockFeatureObject("nickFeature1")}));
        Assert.assertTrue((String)"Result 8 is incorrect.", (boolean)this.license.hasLicenseForAnyFeature(new FeatureObject[]{new MockFeatureObject("allisonFeature2")}));
    }

    @Test
    public void testFeatures09() {
        this.license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(57).addFeature("goodFeature1").addFeature("goodFeature2", 2348917325000L).addFeature("expiredFeature3", 1L).build();
        Assert.assertTrue((String)"Feature 1 is missing now.", (boolean)this.license.hasLicenseForFeature((FeatureObject)new MockFeatureObject("goodFeature1")));
        Assert.assertTrue((String)"Feature 2 is missing now.", (boolean)this.license.hasLicenseForFeature((FeatureObject)new MockFeatureObject("goodFeature2")));
        Assert.assertFalse((String)"There's a phantom feature.", (boolean)this.license.hasLicenseForFeature((FeatureObject)new MockFeatureObject("expiredFeature3")));
        Assert.assertTrue((String)"Error 1", (boolean)this.license.hasLicenseForAnyFeature(new FeatureObject[]{new MockFeatureObject("goodFeature1"), new MockFeatureObject("expiredFeature3")}));
        Assert.assertFalse((String)"Error 2", (boolean)this.license.hasLicenseForAnyFeature(new FeatureObject[]{new MockFeatureObject("expiredFeature3")}));
        Assert.assertTrue((String)"Error 3", (boolean)this.license.hasLicenseForAllFeatures(new FeatureObject[]{new MockFeatureObject("goodFeature1"), new MockFeatureObject("goodFeature2")}));
        Assert.assertFalse((String)"Error 4", (boolean)this.license.hasLicenseForAllFeatures(new FeatureObject[]{new MockFeatureObject("goodFeature1"), new MockFeatureObject("expiredFeature3")}));
        Assert.assertFalse((String)"Error 5", (boolean)this.license.hasLicenseForAllFeatures(new FeatureObject[]{new MockFeatureObject("expiredFeature3")}));
    }

    @Test
    public void testEqualsWithNullObject01() {
        Assert.assertFalse((String)"The objects should not be equal.", (boolean)this.license.equals(null));
    }

    @Test
    public void testEqualsWithNonLicense01() {
        Assert.assertFalse((String)"The objects should not be equal.", (boolean)this.license.equals((Object)"Hello"));
    }

    @Test
    public void testEqualsWithClone01() {
        License license = this.license.clone();
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)this.license, (Object)license);
        Assert.assertEquals((String)"The objects should be equal.", (Object)this.license, (Object)license);
        Assert.assertEquals((String)"The hash codes should match.", (long)this.license.hashCode(), (long)license.hashCode());
    }

    @Test
    public void testEqualsWithDuplicate01() {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(57).addFeature("nickFeature1").addFeature("allisonFeature2", 2348917325000L).build();
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)this.license, (Object)license);
        Assert.assertEquals((String)"The objects should be equal.", (Object)this.license, (Object)license);
        Assert.assertEquals((String)"The hash codes should match.", (long)this.license.hashCode(), (long)license.hashCode());
    }

    @Test
    public void testEqualsWithDuplicate02() {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(57).addFeature("allisonFeature2", 2348917325000L).addFeature("nickFeature1").build();
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)this.license, (Object)license);
        Assert.assertTrue((String)"The objects should be equal.", (boolean)this.license.equals((Object)license));
        Assert.assertEquals((String)"The hash codes should match.", (long)this.license.hashCode(), (long)license.hashCode());
    }

    @Test
    public void testEqualsWithDuplicate03() {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name").withIssueDate(2348907324983L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(57).addFeature("allisonFeature2", 2348917325000L).addFeature("nickFeature1").build();
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)this.license, (Object)license);
        Assert.assertFalse((String)"The objects should not be equal.", (boolean)this.license.equals((Object)license));
        Assert.assertFalse((String)"The hash codes should not match.", (this.license.hashCode() == license.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsWithDuplicate04() {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325001L).withNumberOfLicenses(57).addFeature("allisonFeature2", 2348917325000L).addFeature("nickFeature1").build();
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)this.license, (Object)license);
        Assert.assertFalse((String)"The objects should not be equal.", (boolean)this.license.equals((Object)license));
        Assert.assertFalse((String)"The hash codes should not match.", (this.license.hashCode() == license.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsWithDuplicate05() {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(56).addFeature("allisonFeature2", 2348917325000L).addFeature("nickFeature1").build();
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)this.license, (Object)license);
        Assert.assertFalse((String)"The objects should not be equal.", (boolean)this.license.equals((Object)license));
        Assert.assertFalse((String)"The hash codes should not match.", (this.license.hashCode() == license.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsWithDuplicate06() {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(2348907324999L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(57).addFeature("allisonFeature2", 2348917325000L).addFeature("nickFeature1").build();
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)this.license, (Object)license);
        Assert.assertFalse((String)"The objects should not be equal.", (boolean)this.license.equals((Object)license));
        Assert.assertFalse((String)"The hash codes should not match.", (this.license.hashCode() == license.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsWithDuplicate07() {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324984L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(57).addFeature("allisonFeature2", 2348917325000L).addFeature("nickFeature1").build();
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)this.license, (Object)license);
        Assert.assertFalse((String)"The objects should not be equal.", (boolean)this.license.equals((Object)license));
        Assert.assertFalse((String)"The hash codes should not match.", (this.license.hashCode() == license.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsWithDuplicate08() {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=TN").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(57).addFeature("allisonFeature2", 2348917325000L).addFeature("nickFeature1").build();
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)this.license, (Object)license);
        Assert.assertFalse((String)"The objects should not be equal.", (boolean)this.license.equals((Object)license));
        Assert.assertFalse((String)"The hash codes should not match.", (this.license.hashCode() == license.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsWithDuplicate09() {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=AL").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(57).addFeature("allisonFeature2", 2348917325000L).addFeature("nickFeature1").build();
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)this.license, (Object)license);
        Assert.assertFalse((String)"The objects should not be equal.", (boolean)this.license.equals((Object)license));
        Assert.assertFalse((String)"The hash codes should not match.", (this.license.hashCode() == license.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsWithDuplicate10() {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(57).addFeature("allisonFeature3").addFeature("nickFeature1").build();
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)this.license, (Object)license);
        Assert.assertFalse((String)"The objects should not be equal.", (boolean)this.license.equals((Object)license));
        Assert.assertFalse((String)"The hash codes should not match.", (this.license.hashCode() == license.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsWithDuplicate11() {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(57).addFeature("allisonFeature2").addFeature("nickFeature4").build();
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)this.license, (Object)license);
        Assert.assertFalse((String)"The objects should not be equal.", (boolean)this.license.equals((Object)license));
        Assert.assertFalse((String)"The hash codes should not match.", (this.license.hashCode() == license.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsWithDuplicate12() {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AM").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(57).addFeature("nickFeature1").addFeature("allisonFeature2", 2348917325000L).build();
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)this.license, (Object)license);
        Assert.assertFalse((String)"The objects should not be equal.", (boolean)this.license.equals((Object)license));
        Assert.assertFalse((String)"The hash codes should not match.", (this.license.hashCode() == license.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsWithSimpleBlankLicense01() {
        License license = new License.Builder().build();
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)this.license, (Object)license);
        Assert.assertFalse((String)"The objects should not be equal.", (boolean)this.license.equals((Object)license));
        Assert.assertFalse((String)"The hash codes should not match.", (this.license.hashCode() == license.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Assert.assertEquals((String)"The string was not correct.", (Object)"[5565-1039-AF89-GGX7-TN31-14AL][CN=Tim Williams, C=US, ST=AL][CN=Nick Williams, C=US, ST=TN][Simple Product Name(TM)][2348907324983][2348907325000][2348917325000][57][nickFeature1\u001f-1, allisonFeature2\u001f2348917325000]", (Object)this.license.toString());
    }

    @Test
    public void testSerialization() {
        Assert.assertEquals((String)"The serialization was not correct.", (Object)"[5565-1039-AF89-GGX7-TN31-14AL][CN=Tim Williams, C=US, ST=AL][CN=Nick Williams, C=US, ST=TN][Simple Product Name(TM)][2348907324983][2348907325000][2348917325000][57][nickFeature1\u001f-1, allisonFeature2\u001f2348917325000]", (Object)new String(this.license.serialize()));
    }

    @Test
    public void testDeserialization01() {
        License license = License.deserialize((byte[])"[5565-1039-AF89-GGX7-TN31-14AL][CN=John E. Smith, C=CA, ST=QE][CN=OurCompany, C=US, ST=KY][Cool Product, by Company][14429073214631][1443907325000][1443917325000][12][fordFeature1\u001f-1, chevyFeature2\u001f9223372036854775807, hondaFeature3\u001f9223372036854775807, toyotaFeature4\u001f-1]".getBytes());
        Assert.assertEquals((String)"The product key is not correct.", (Object)"5565-1039-AF89-GGX7-TN31-14AL", (Object)license.getProductKey());
        Assert.assertEquals((String)"The holder is not correct.", (Object)"CN=John E. Smith, C=CA, ST=QE", (Object)license.getHolder());
        Assert.assertEquals((String)"The issuer is not correct.", (Object)"CN=OurCompany, C=US, ST=KY", (Object)license.getIssuer());
        Assert.assertEquals((String)"The company is not correct.", (Object)"Cool Product, by Company", (Object)license.getSubject());
        Assert.assertEquals((String)"The issue date is not correct.", (long)14429073214631L, (long)license.getIssueDate());
        Assert.assertEquals((String)"The good after date is not correct.", (long)1443907325000L, (long)license.getGoodAfterDate());
        Assert.assertEquals((String)"The good before date is not correct.", (long)1443917325000L, (long)license.getGoodBeforeDate());
        Assert.assertEquals((String)"The number of licenses is not correct.", (long)12L, (long)license.getNumberOfLicenses());
        Assert.assertEquals((String)"The number of features is not correct.", (long)4L, (long)license.getFeatures().size());
        Assert.assertTrue((String)"Feature 1 is missing.", (boolean)license.hasLicenseForAllFeatures(new String[]{"fordFeature1"}));
        Assert.assertTrue((String)"Feature 2 is missing.", (boolean)license.hasLicenseForAllFeatures(new String[]{"chevyFeature2"}));
        Assert.assertTrue((String)"Feature 3 is missing.", (boolean)license.hasLicenseForAllFeatures(new String[]{"hondaFeature3"}));
        Assert.assertTrue((String)"Feature 4 is missing.", (boolean)license.hasLicenseForAllFeatures(new String[]{"toyotaFeature4"}));
    }

    @Test
    public void testDeserialization02() {
        License license = License.deserialize((byte[])"[6575-TH0T-SNL5-7XGG-1099-1040][CN=John E. Smith, C=CA, ST=QE][CN=OurCompany, C=US, ST=KY][Cool Product, by Company][14429073214631][1443907325000][1443917325000][12][fordFeature1\u001f-1, chevyFeature2\u001f9223372036854775807, hondaFeature3\u001f1234567890, toyotaFeature4\u001f-1]".getBytes());
        Assert.assertEquals((String)"The product key is not correct.", (Object)"6575-TH0T-SNL5-7XGG-1099-1040", (Object)license.getProductKey());
        Assert.assertEquals((String)"The holder is not correct.", (Object)"CN=John E. Smith, C=CA, ST=QE", (Object)license.getHolder());
        Assert.assertEquals((String)"The issuer is not correct.", (Object)"CN=OurCompany, C=US, ST=KY", (Object)license.getIssuer());
        Assert.assertEquals((String)"The company is not correct.", (Object)"Cool Product, by Company", (Object)license.getSubject());
        Assert.assertEquals((String)"The issue date is not correct.", (long)14429073214631L, (long)license.getIssueDate());
        Assert.assertEquals((String)"The good after date is not correct.", (long)1443907325000L, (long)license.getGoodAfterDate());
        Assert.assertEquals((String)"The good before date is not correct.", (long)1443917325000L, (long)license.getGoodBeforeDate());
        Assert.assertEquals((String)"The number of licenses is not correct.", (long)12L, (long)license.getNumberOfLicenses());
        Assert.assertEquals((String)"The number of features is not correct.", (long)4L, (long)license.getFeatures().size());
        Assert.assertTrue((String)"Feature 1 is missing.", (boolean)license.hasLicenseForAllFeatures(new String[]{"fordFeature1"}));
        Assert.assertTrue((String)"Feature 2 is missing.", (boolean)license.hasLicenseForAllFeatures(new String[]{"chevyFeature2"}));
        Assert.assertNotNull((String)"Feature 3 is missing.", (Object)license.getFeatures().get(2));
        Assert.assertEquals((String)"Feature 3 is missing.", (Object)"hondaFeature3", (Object)((License.Feature)license.getFeatures().get(2)).getName());
        Assert.assertFalse((String)"Feature 3 should be expired.", (boolean)license.hasLicenseForAllFeatures(new String[]{"hondaFeature3"}));
        Assert.assertTrue((String)"Feature 4 is missing.", (boolean)license.hasLicenseForAllFeatures(new String[]{"toyotaFeature4"}));
    }

    @Test
    public void testDeserialization03() {
        License license = License.deserialize((byte[])"[][][][][0][0][0][0][]".getBytes());
        Assert.assertEquals((String)"The product key is not correct.", (Object)"", (Object)license.getProductKey());
        Assert.assertEquals((String)"The holder is not correct.", (Object)"", (Object)license.getHolder());
        Assert.assertEquals((String)"The issuer is not correct.", (Object)"", (Object)license.getIssuer());
        Assert.assertEquals((String)"The company is not correct.", (Object)"", (Object)license.getSubject());
        Assert.assertEquals((String)"The issue date is not correct.", (long)0L, (long)license.getIssueDate());
        Assert.assertEquals((String)"The good after date is not correct.", (long)0L, (long)license.getGoodAfterDate());
        Assert.assertEquals((String)"The good before date is not correct.", (long)0L, (long)license.getGoodBeforeDate());
        Assert.assertEquals((String)"The number of licenses is not correct.", (long)0L, (long)license.getNumberOfLicenses());
        Assert.assertEquals((String)"The number of features is not correct.", (long)0L, (long)license.getFeatures().size());
    }

    @Test
    public void testLicenseFeatureFromString01() throws NoSuchMethodException, InstantiationException, IllegalAccessException {
        Method method = License.Feature.class.getDeclaredMethod("fromString", String.class);
        method.setAccessible(true);
        try {
            method.invoke(null, new Object[]{null});
            Assert.fail((String)"Expected exception IllegalArgumentException.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Assert.assertNotNull((String)"The cause should not be null.", (Object)invocationTargetException.getCause());
            Assert.assertSame((String)"The cause is not correct.", IllegalArgumentException.class, invocationTargetException.getCause().getClass());
        }
    }

    @Test
    public void testLicenseFeatureFromString02() throws NoSuchMethodException, InstantiationException, IllegalAccessException {
        Method method = License.Feature.class.getDeclaredMethod("fromString", String.class);
        method.setAccessible(true);
        try {
            method.invoke(null, "one");
            Assert.fail((String)"Expected exception IllegalArgumentException.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Assert.assertNotNull((String)"The cause should not be null.", (Object)invocationTargetException.getCause());
            Assert.assertSame((String)"The cause is not correct.", IllegalArgumentException.class, invocationTargetException.getCause().getClass());
        }
    }

    @Test
    public void testLicenseFeatureConstructor03() throws NoSuchMethodException, InstantiationException, IllegalAccessException {
        Method method = License.Feature.class.getDeclaredMethod("fromString", String.class);
        method.setAccessible(true);
        try {
            method.invoke(null, "one\u001f2\u001fthree");
            Assert.fail((String)"Expected exception IllegalArgumentException.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Assert.assertNotNull((String)"The cause should not be null.", (Object)invocationTargetException.getCause());
            Assert.assertSame((String)"The cause is not correct.", IllegalArgumentException.class, invocationTargetException.getCause().getClass());
        }
    }

    @Test
    public void testLicenseFeatureEquals01() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Method method = License.Feature.class.getDeclaredMethod("fromString", String.class);
        method.setAccessible(true);
        License.Feature feature = (License.Feature)method.invoke(null, "one\u001f2");
        Assert.assertFalse((String)"Equals should return false.", (boolean)feature.equals(null));
    }

    @Test
    public void testLicenseFeatureEquals02() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Method method = License.Feature.class.getDeclaredMethod("fromString", String.class);
        method.setAccessible(true);
        License.Feature feature = (License.Feature)method.invoke(null, "one\u001f2");
        Assert.assertFalse((String)"Equals should return false.", (boolean)feature.equals((Object)"one\u001f2"));
    }

    @Test
    public void testLicenseFeatureEquals03() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Method method = License.Feature.class.getDeclaredMethod("fromString", String.class);
        method.setAccessible(true);
        License.Feature feature = (License.Feature)method.invoke(null, "one\u001f2");
        License.Feature feature2 = (License.Feature)method.invoke(null, "one\u001f5");
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)feature, (Object)feature2);
        Assert.assertEquals((String)"The objects should be equal.", (Object)feature, (Object)feature2);
        Assert.assertEquals((String)"The hash codes should be equal.", (long)feature.hashCode(), (long)feature2.hashCode());
    }

    @Test
    public void testLicenseFeatureEquals04() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Method method = License.Feature.class.getDeclaredMethod("fromString", String.class);
        method.setAccessible(true);
        License.Feature feature = (License.Feature)method.invoke(null, "one\u001f2");
        License.Feature feature2 = (License.Feature)method.invoke(null, "three\u001f5");
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)feature, (Object)feature2);
        Assert.assertFalse((String)"The objects should not be equal.", (boolean)feature.equals((Object)feature2));
        Assert.assertFalse((String)"The hash codes should not be equal.", (feature.hashCode() == feature2.hashCode() ? 1 : 0) != 0);
    }
}

