/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import net.nicholaswilliams.java.licensing.License;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLicenseBuilder {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testBuild01() {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withIssueDate(1234567890000L).withGoodAfterDate(1199145600000L).withGoodBeforeDate(1924991999000L).withNumberOfLicenses(15).addFeature("FEATURE1").addFeature("FEATURE3").build();
        Assert.assertEquals((String)"The product key is not correct.", (Object)"5565-1039-AF89-GGX7-TN31-14AL", (Object)license.getProductKey());
        Assert.assertEquals((String)"The issuer is not correct.", (Object)"CN=Nick Williams, C=US, ST=TN", (Object)license.getIssuer());
        Assert.assertEquals((String)"The holder is not correct.", (Object)"CN=Tim Williams, C=US, ST=AL", (Object)license.getHolder());
        Assert.assertEquals((String)"The issue date is not correct.", (long)1234567890000L, (long)license.getIssueDate());
        Assert.assertEquals((String)"The good after date is not correct.", (long)1199145600000L, (long)license.getGoodAfterDate());
        Assert.assertEquals((String)"The good before date is not correct.", (long)1924991999000L, (long)license.getGoodBeforeDate());
        Assert.assertEquals((String)"The number of licenses is not correct.", (long)15L, (long)license.getNumberOfLicenses());
        Assert.assertTrue((String)"Feature mismatch #1.", (boolean)license.hasLicenseForAllFeatures(new String[]{"FEATURE1"}));
        Assert.assertTrue((String)"Feature mismatch #2.", (boolean)license.hasLicenseForAllFeatures(new String[]{"FEATURE3"}));
        Assert.assertFalse((String)"Feature mismatch #3.", (boolean)license.hasLicenseForAllFeatures(new String[]{"FEATURE2"}));
    }

    @Test
    public void testBuild02() {
        License license = new License.Builder().withProductKey("5655-9301-98AF-X7GE-RTV5-1092").withIssuer("CN=UUID-5581CAD6-A0C5-1A88-C32B6117B700B53F, C=US, ST=TN").withHolder("CN=UUID-5581CAE6-0232-5353-1DC9AF6A79FE7106, C=US, ST=AL").withIssueDate(1285629859000L).withGoodAfterDate(1136073600000L).withGoodBeforeDate(1230767999000L).withNumberOfLicenses(5).addFeature("FEATURE2").build();
        Assert.assertEquals((String)"The product key is not correct.", (Object)"5655-9301-98AF-X7GE-RTV5-1092", (Object)license.getProductKey());
        Assert.assertEquals((String)"The issuer is not correct.", (Object)"CN=UUID-5581CAD6-A0C5-1A88-C32B6117B700B53F, C=US, ST=TN", (Object)license.getIssuer());
        Assert.assertEquals((String)"The holder is not correct.", (Object)"CN=UUID-5581CAE6-0232-5353-1DC9AF6A79FE7106, C=US, ST=AL", (Object)license.getHolder());
        Assert.assertEquals((String)"The issue date is not correct.", (long)1285629859000L, (long)license.getIssueDate());
        Assert.assertEquals((String)"The good after date is not correct.", (long)1136073600000L, (long)license.getGoodAfterDate());
        Assert.assertEquals((String)"The good before date is not correct.", (long)1230767999000L, (long)license.getGoodBeforeDate());
        Assert.assertEquals((String)"The number of licenses is not correct.", (long)5L, (long)license.getNumberOfLicenses());
        Assert.assertTrue((String)"Feature mismatch #1.", (boolean)license.hasLicenseForAllFeatures(new String[]{"FEATURE2"}));
        Assert.assertFalse((String)"Feature mismatch #2.", (boolean)license.hasLicenseForAllFeatures(new String[]{"FEATURE1"}));
        Assert.assertFalse((String)"Feature mismatch #3.", (boolean)license.hasLicenseForAllFeatures(new String[]{"FEATURE3"}));
    }
}

