/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.AnnotatedElement;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.spec.X509EncodedKeySpec;
import net.nicholaswilliams.java.licensing.DataSignatureManager;
import net.nicholaswilliams.java.licensing.FeatureObject;
import net.nicholaswilliams.java.licensing.FeatureRestriction;
import net.nicholaswilliams.java.licensing.FeatureRestrictionOperand;
import net.nicholaswilliams.java.licensing.License;
import net.nicholaswilliams.java.licensing.LicenseManager;
import net.nicholaswilliams.java.licensing.LicenseManagerProperties;
import net.nicholaswilliams.java.licensing.LicenseProvider;
import net.nicholaswilliams.java.licensing.LicenseValidator;
import net.nicholaswilliams.java.licensing.SignedLicense;
import net.nicholaswilliams.java.licensing.encryption.Encryptor;
import net.nicholaswilliams.java.licensing.encryption.PasswordProvider;
import net.nicholaswilliams.java.licensing.encryption.PublicKeyDataProvider;
import net.nicholaswilliams.java.licensing.exception.ExpiredLicenseException;
import net.nicholaswilliams.java.licensing.mock.MockFeatureObject;
import org.apache.commons.io.IOUtils;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLicenseManager {
    private static final char[] keyPassword = "testLicenseManagerPassword".toCharArray();
    private static final char[] licensePassword = "testLicensePassword".toCharArray();
    private static LicenseProvider licenseProvider;
    private static PasswordProvider publicKeyPasswordProvider;
    private static PasswordProvider licensePasswordProvider;
    private static PublicKeyDataProvider keyDataProvider;
    private static LicenseValidator licenseValidator;
    private static IMocksControl control;
    private static PrivateKey privateKey;
    private static byte[] encryptedPublicKey;
    private LicenseManager manager = LicenseManager.getInstance();

    @BeforeClass
    public static void setUpClass() throws Exception {
        control = EasyMock.createStrictControl();
        licenseProvider = (LicenseProvider)control.createMock(LicenseProvider.class);
        publicKeyPasswordProvider = (PasswordProvider)control.createMock(PasswordProvider.class);
        licensePasswordProvider = (PasswordProvider)control.createMock(PasswordProvider.class);
        keyDataProvider = (PublicKeyDataProvider)control.createMock(PublicKeyDataProvider.class);
        licenseValidator = (LicenseValidator)control.createMock(LicenseValidator.class);
        try {
            LicenseManager.getInstance();
            Assert.fail((String)"Expected java.lang.IllegalArgumentException, got no exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        LicenseManagerProperties.setLicenseProvider((LicenseProvider)licenseProvider);
        try {
            LicenseManager.getInstance();
            Assert.fail((String)"Expected java.lang.IllegalArgumentException, got no exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        LicenseManagerProperties.setPublicKeyDataProvider((PublicKeyDataProvider)keyDataProvider);
        try {
            LicenseManager.getInstance();
            Assert.fail((String)"Expected java.lang.IllegalArgumentException, got no exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        LicenseManagerProperties.setPublicKeyPasswordProvider((PasswordProvider)publicKeyPasswordProvider);
        LicenseManagerProperties.setLicensePasswordProvider((PasswordProvider)licensePasswordProvider);
        LicenseManagerProperties.setLicenseValidator((LicenseValidator)licenseValidator);
        LicenseManagerProperties.setCacheTimeInMinutes((int)0);
        LicenseManager.getInstance();
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        privateKey = keyPair.getPrivate();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyPair.getPublic().getEncoded());
        IOUtils.write((byte[])Encryptor.encryptRaw((byte[])x509EncodedKeySpec.getEncoded(), (char[])keyPassword), (OutputStream)byteArrayOutputStream);
        encryptedPublicKey = byteArrayOutputStream.toByteArray();
    }

    @Before
    public void setUp() {
        control.reset();
    }

    @After
    public void tearDown() {
        control.verify();
    }

    @Test
    public void testGetLicenseIllegalArgument() {
        control.replay();
        try {
            this.manager.getLicense(null);
            Assert.fail((String)"Expected java.lang.IllegalArgumentException, got no exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetLicense01() throws Exception {
        EasyMock.expect((Object)licenseProvider.getLicense((Object)"ACCOUNT-1")).andReturn(null);
        control.replay();
        Assert.assertNull((String)"The returned license should be null.", (Object)this.manager.getLicense((Object)"ACCOUNT-1"));
    }

    @Test
    public void testGetLicense02() throws Exception {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=Nick Williams, C=US, ST=TN").withHolder("CN=Tim Williams, C=US, ST=AL").withSubject("Simple Product Name(TM)").withIssueDate(2348907324983L).withGoodAfterDate(2348907325000L).withGoodBeforeDate(2348917325000L).withNumberOfLicenses(57).addFeature("nickFeature1").addFeature("allisonFeature2").build();
        byte[] byArray = Encryptor.encryptRaw((byte[])license.serialize(), (char[])licensePassword);
        byte[] byArray2 = new DataSignatureManager().signData(privateKey, byArray);
        EasyMock.expect((Object)licenseProvider.getLicense((Object)"LICENSE-2")).andReturn((Object)new SignedLicense(byArray, byArray2));
        EasyMock.expect((Object)publicKeyPasswordProvider.getPassword()).andReturn(keyPassword.clone());
        EasyMock.expect((Object)keyDataProvider.getEncryptedPublicKeyData()).andReturn(encryptedPublicKey.clone());
        EasyMock.expect((Object)licensePasswordProvider.getPassword()).andReturn(licensePassword.clone());
        control.replay();
        License license2 = this.manager.getLicense((Object)"LICENSE-2");
        Assert.assertNotNull((String)"The returned license should not be null.", (Object)license2);
        Assert.assertEquals((String)"The returned license is not correct.", (Object)license, (Object)license2);
    }

    public License setupLicenseMocking(String string) {
        License license = new License.Builder().withProductKey("5565-1039-AF89-GGX7-TN31-14AL").withIssuer("CN=NWTS, C=US, ST=TN").withHolder("CN=Joe Customer, C=CA, ST=QE").withSubject("NWTS Database Browser/v.9.5").withIssueDate(23481149385711L).withGoodAfterDate(2348114987000L).withGoodBeforeDate(2348914987000L).withNumberOfLicenses(5).addFeature("feature#1").addFeature("feature#2").addFeature("feature#5").build();
        byte[] byArray = Encryptor.encryptRaw((byte[])license.serialize(), (char[])licensePassword);
        byte[] byArray2 = new DataSignatureManager().signData(privateKey, byArray);
        EasyMock.expect((Object)licenseProvider.getLicense((Object)string)).andReturn((Object)new SignedLicense(byArray, byArray2));
        EasyMock.expect((Object)publicKeyPasswordProvider.getPassword()).andReturn(keyPassword.clone());
        EasyMock.expect((Object)keyDataProvider.getEncryptedPublicKeyData()).andReturn(encryptedPublicKey.clone());
        EasyMock.expect((Object)licensePasswordProvider.getPassword()).andReturn(licensePassword.clone());
        return license;
    }

    public void setupNullLicenseMocking(String string) {
        EasyMock.expect((Object)licenseProvider.getLicense((Object)string)).andReturn(null);
    }

    @Test
    public void testGetLicense03() throws Exception {
        License license = this.setupLicenseMocking("CUSTOMER-3");
        control.replay();
        License license2 = this.manager.getLicense((Object)"CUSTOMER-3");
        Assert.assertNotNull((String)"The returned license should not be null.", (Object)license2);
        Assert.assertEquals((String)"The returned license is not correct.", (Object)license, (Object)license2);
        Thread.sleep(5000L);
        License license3 = this.manager.getLicense((Object)"CUSTOMER-3");
        Assert.assertSame((String)"The returned objects should be the same.", (Object)license2, (Object)license3);
        Thread.sleep(7000L);
        control.verify();
        control.reset();
        EasyMock.expect((Object)licenseProvider.getLicense((Object)"CUSTOMER-3")).andReturn(null);
        control.replay();
        Assert.assertNull((String)"The license should be null now.", (Object)this.manager.getLicense((Object)"CUSTOMER-3"));
    }

    @Test
    public void testGetLicense04() throws Exception {
        License license = this.setupLicenseMocking("CUSTOMER-4");
        control.replay();
        License license2 = this.manager.getLicense((Object)"CUSTOMER-4");
        Assert.assertNotNull((String)"The returned license should not be null.", (Object)license2);
        Assert.assertEquals((String)"The returned license is not correct.", (Object)license, (Object)license2);
        Thread.sleep(5000L);
        License license3 = this.manager.getLicense((Object)"CUSTOMER-4");
        Assert.assertSame((String)"The returned objects should be the same.", (Object)license2, (Object)license3);
        Thread.sleep(7000L);
        control.verify();
        control.reset();
        license = this.setupLicenseMocking("CUSTOMER-4");
        control.replay();
        license3 = this.manager.getLicense((Object)"CUSTOMER-4");
        Assert.assertNotNull((String)"The returned license should not be null.", (Object)license3);
        Assert.assertEquals((String)"The returned license is not correct.", (Object)license, (Object)license3);
        Assert.assertNotSame((String)"The returned objects should not be the same anymore.", (Object)license2, (Object)license3);
    }

    @Test
    public void testClearLicenseCache01() throws Exception {
        License license = this.setupLicenseMocking("CUSTOMER-5");
        License license2 = this.setupLicenseMocking("CUSTOMER-5");
        control.replay();
        License license3 = this.manager.getLicense((Object)"CUSTOMER-5");
        Assert.assertNotNull((String)"The returned license should not be null (1).", (Object)license3);
        Assert.assertEquals((String)"The returned license is not correct (1).", (Object)license, (Object)license3);
        Thread.sleep(1000L);
        License license4 = this.manager.getLicense((Object)"CUSTOMER-5");
        Assert.assertSame((String)"The returned objects should be the same (1).", (Object)license3, (Object)license4);
        this.manager.clearLicenseCache();
        license3 = this.manager.getLicense((Object)"CUSTOMER-5");
        Assert.assertNotNull((String)"The returned license should not be null (2).", (Object)license3);
        Assert.assertEquals((String)"The returned license is not correct (2).", (Object)license2, (Object)license3);
        Thread.sleep(1000L);
        license4 = this.manager.getLicense((Object)"CUSTOMER-5");
        Assert.assertSame((String)"The returned objects should be the same (2).", (Object)license3, (Object)license4);
    }

    @Test
    public void testValidateLicense01() {
        License license = new License.Builder().build();
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        this.manager.validateLicense(license);
    }

    @Test(expected=ExpiredLicenseException.class)
    public void testValidateLicense02() {
        License license = new License.Builder().build();
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall().andThrow((Throwable)new ExpiredLicenseException());
        control.replay();
        this.manager.validateLicense(license);
    }

    @Test
    public void testHasLicenseForFeature01() {
        License license = this.setupLicenseMocking("LICENSE-ONE-1");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeature((Object)"LICENSE-ONE-1", "feature#1"));
    }

    @Test
    public void testHasLicenseForFeature02() {
        License license = this.setupLicenseMocking("LICENSE-ONE-2");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeature((Object)"LICENSE-ONE-2", "feature#2"));
    }

    @Test
    public void testHasLicenseForFeature03() {
        License license = this.setupLicenseMocking("LICENSE-ONE-3");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeature((Object)"LICENSE-ONE-3", "feature#3"));
    }

    @Test
    public void testHasLicenseForFeature04() {
        this.setupNullLicenseMocking("NULL-LICENSE-ONE-4");
        control.replay();
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeature((Object)"NULL-LICENSE-ONE-4", "feature#2"));
    }

    @Test
    public void testHasLicenseForFeature05() {
        License license = this.setupLicenseMocking("LICENSE-ONE-5");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeature((Object)"LICENSE-ONE-5", (FeatureObject)new MockFeatureObject("feature#1")));
    }

    @Test
    public void testHasLicenseForFeature06() {
        License license = this.setupLicenseMocking("LICENSE-ONE-6");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeature((Object)"LICENSE-ONE-6", (FeatureObject)new MockFeatureObject("feature#2")));
    }

    @Test
    public void testHasLicenseForFeature07() {
        License license = this.setupLicenseMocking("LICENSE-ONE-7");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeature((Object)"LICENSE-ONE-7", (FeatureObject)new MockFeatureObject("feature#3")));
    }

    @Test
    public void testHasLicenseForFeature08() {
        this.setupNullLicenseMocking("NULL-LICENSE-ONE-8");
        control.replay();
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeature((Object)"NULL-LICENSE-ONE-8", (FeatureObject)new MockFeatureObject("feature#2")));
    }

    @Test
    public void testHasLicenseForAllFeatures01() {
        License license = this.setupLicenseMocking("LICENSE-ALL-1");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAllFeatures((Object)"LICENSE-ALL-1", new String[]{"feature#1"}));
    }

    @Test
    public void testHasLicenseForAllFeatures02() {
        License license = this.setupLicenseMocking("LICENSE-ALL-2");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAllFeatures((Object)"LICENSE-ALL-2", new String[]{"feature#1", "feature#2"}));
    }

    @Test
    public void testHasLicenseForAllFeatures03() {
        License license = this.setupLicenseMocking("LICENSE-ALL-3");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAllFeatures((Object)"LICENSE-ALL-3", new String[]{"feature#2", "feature#5", "feature#1"}));
    }

    @Test
    public void testHasLicenseForAllFeatures04() {
        License license = this.setupLicenseMocking("LICENSE-ALL-4");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAllFeatures((Object)"LICENSE-ALL-4", new String[]{"feature#6"}));
    }

    @Test
    public void testHasLicenseForAllFeatures05() {
        License license = this.setupLicenseMocking("LICENSE-ALL-5");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAllFeatures((Object)"LICENSE-ALL-5", new String[]{"feature#2", "feature#5", "feature#1", "feature#3"}));
    }

    @Test
    public void testHasLicenseForAllFeatures06() {
        this.setupNullLicenseMocking("NULL-LICENSE-ALL-6");
        control.replay();
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAllFeatures((Object)"NULL-LICENSE-ALL-6", new String[]{"feature#2", "feature#5", "feature#1"}));
    }

    @Test
    public void testHasLicenseForAllFeatures07() {
        License license = this.setupLicenseMocking("LICENSE-ALL-7");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAllFeatures((Object)"LICENSE-ALL-7", new FeatureObject[]{new MockFeatureObject("feature#1")}));
    }

    @Test
    public void testHasLicenseForAllFeatures08() {
        License license = this.setupLicenseMocking("LICENSE-ALL-8");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAllFeatures((Object)"LICENSE-ALL-8", new FeatureObject[]{new MockFeatureObject("feature#1"), new MockFeatureObject("feature#2")}));
    }

    @Test
    public void testHasLicenseForAllFeatures09() {
        License license = this.setupLicenseMocking("LICENSE-ALL-9");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAllFeatures((Object)"LICENSE-ALL-9", new FeatureObject[]{new MockFeatureObject("feature#2"), new MockFeatureObject("feature#5"), new MockFeatureObject("feature#1")}));
    }

    @Test
    public void testHasLicenseForAllFeatures10() {
        License license = this.setupLicenseMocking("LICENSE-ALL-10");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAllFeatures((Object)"LICENSE-ALL-10", new FeatureObject[]{new MockFeatureObject("feature#6")}));
    }

    @Test
    public void testHasLicenseForAllFeatures11() {
        License license = this.setupLicenseMocking("LICENSE-ALL-11");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAllFeatures((Object)"LICENSE-ALL-11", new FeatureObject[]{new MockFeatureObject("feature#2"), new MockFeatureObject("feature#5"), new MockFeatureObject("feature#1"), new MockFeatureObject("feature#3")}));
    }

    @Test
    public void testHasLicenseForAllFeatures12() {
        this.setupNullLicenseMocking("NULL-LICENSE-ALL-12");
        control.replay();
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAllFeatures((Object)"NULL-LICENSE-ALL-12", new FeatureObject[]{new MockFeatureObject("feature#2"), new MockFeatureObject("feature#5"), new MockFeatureObject("feature#1")}));
    }

    @Test
    public void testHasLicenseForAnyFeatures01() {
        License license = this.setupLicenseMocking("LICENSE-ANY-1");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAnyFeature((Object)"LICENSE-ANY-1", new String[]{"feature#1"}));
    }

    @Test
    public void testHasLicenseForAnyFeatures02() {
        License license = this.setupLicenseMocking("LICENSE-ANY-2");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAnyFeature((Object)"LICENSE-ANY-2", new String[]{"feature#1", "feature#2"}));
    }

    @Test
    public void testHasLicenseForAnyFeatures03() {
        License license = this.setupLicenseMocking("LICENSE-ANY-3");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAnyFeature((Object)"LICENSE-ANY-3", new String[]{"feature#2", "feature#5", "feature#1"}));
    }

    @Test
    public void testHasLicenseForAnyFeatures04() {
        License license = this.setupLicenseMocking("LICENSE-ANY-4");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAnyFeature((Object)"LICENSE-ANY-4", new String[]{"feature#6"}));
    }

    @Test
    public void testHasLicenseForAnyFeatures05() {
        License license = this.setupLicenseMocking("LICENSE-ANY-5");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAnyFeature((Object)"LICENSE-ANY-5", new String[]{"feature#5", "feature#3"}));
    }

    @Test
    public void testHasLicenseForAnyFeatures06() {
        this.setupNullLicenseMocking("NULL-LICENSE-ANY-6");
        control.replay();
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAnyFeature((Object)"NULL-LICENSE-ANY-6", new String[]{"feature#2", "feature#5", "feature#1"}));
    }

    @Test
    public void testHasLicenseForAnyFeatures07() {
        License license = this.setupLicenseMocking("LICENSE-ANY-7");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAnyFeature((Object)"LICENSE-ANY-7", new FeatureObject[]{new MockFeatureObject("feature#1")}));
    }

    @Test
    public void testHasLicenseForAnyFeatures08() {
        License license = this.setupLicenseMocking("LICENSE-ANY-8");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAnyFeature((Object)"LICENSE-ANY-8", new FeatureObject[]{new MockFeatureObject("feature#1"), new MockFeatureObject("feature#2")}));
    }

    @Test
    public void testHasLicenseForAnyFeatures09() {
        License license = this.setupLicenseMocking("LICENSE-ANY-9");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAnyFeature((Object)"LICENSE-ANY-9", new FeatureObject[]{new MockFeatureObject("feature#2"), new MockFeatureObject("feature#5"), new MockFeatureObject("feature#1")}));
    }

    @Test
    public void testHasLicenseForAnyFeatures10() {
        License license = this.setupLicenseMocking("LICENSE-ANY-10");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAnyFeature((Object)"LICENSE-ANY-10", new FeatureObject[]{new MockFeatureObject("feature#6")}));
    }

    @Test
    public void testHasLicenseForAnyFeatures11() {
        License license = this.setupLicenseMocking("LICENSE-ANY-11");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAnyFeature((Object)"LICENSE-ANY-11", new FeatureObject[]{new MockFeatureObject("feature#5"), new MockFeatureObject("feature#3")}));
    }

    @Test
    public void testHasLicenseForAnyFeatures12() {
        this.setupNullLicenseMocking("NULL-LICENSE-ANY-12");
        control.replay();
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForAnyFeature((Object)"NULL-LICENSE-ANY-12", new FeatureObject[]{new MockFeatureObject("feature#2"), new MockFeatureObject("feature#5"), new MockFeatureObject("feature#1")}));
    }

    @Test
    public void testHasLicenseForFeaturesByAnnotation01() throws NoSuchMethodException {
        License license = this.setupLicenseMocking("LICENSE-ANNOTATION-1");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Object object = new Object(){

            @FeatureRestriction(value={"feature#1", "feature#5"})
            public void method() {
            }
        };
        FeatureRestriction featureRestriction = object.getClass().getMethod("method", new Class[0]).getAnnotation(FeatureRestriction.class);
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeatures((Object)"LICENSE-ANNOTATION-1", featureRestriction));
    }

    @Test
    public void testHasLicenseForFeaturesByAnnotation02() throws NoSuchMethodException {
        License license = this.setupLicenseMocking("LICENSE-ANNOTATION-2");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Object object = new Object(){

            @FeatureRestriction(value={"feature#1", "feature#3"})
            public void method() {
            }
        };
        FeatureRestriction featureRestriction = object.getClass().getMethod("method", new Class[0]).getAnnotation(FeatureRestriction.class);
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeatures((Object)"LICENSE-ANNOTATION-2", featureRestriction));
    }

    @Test
    public void testHasLicenseForFeaturesByAnnotation03() throws NoSuchMethodException {
        License license = this.setupLicenseMocking("LICENSE-ANNOTATION-3");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Object object = new Object(){

            @FeatureRestriction(value={"feature#6", "feature#3"})
            public void method() {
            }
        };
        FeatureRestriction featureRestriction = object.getClass().getMethod("method", new Class[0]).getAnnotation(FeatureRestriction.class);
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeatures((Object)"LICENSE-ANNOTATION-3", featureRestriction));
    }

    @Test
    public void testHasLicenseForFeaturesByAnnotation04() throws NoSuchMethodException {
        License license = this.setupLicenseMocking("LICENSE-ANNOTATION-4");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Object object = new Object(){

            @FeatureRestriction(value={"feature#1", "feature#5"}, operand=FeatureRestrictionOperand.OR)
            public void method() {
            }
        };
        FeatureRestriction featureRestriction = object.getClass().getMethod("method", new Class[0]).getAnnotation(FeatureRestriction.class);
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeatures((Object)"LICENSE-ANNOTATION-4", featureRestriction));
    }

    @Test
    public void testHasLicenseForFeaturesByAnnotation05() throws NoSuchMethodException {
        License license = this.setupLicenseMocking("LICENSE-ANNOTATION-5");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Object object = new Object(){

            @FeatureRestriction(value={"feature#1", "feature#3"}, operand=FeatureRestrictionOperand.OR)
            public void method() {
            }
        };
        FeatureRestriction featureRestriction = object.getClass().getMethod("method", new Class[0]).getAnnotation(FeatureRestriction.class);
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeatures((Object)"LICENSE-ANNOTATION-5", featureRestriction));
    }

    @Test
    public void testHasLicenseForFeaturesByAnnotation06() throws NoSuchMethodException {
        License license = this.setupLicenseMocking("LICENSE-ANNOTATION-6");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Object object = new Object(){

            @FeatureRestriction(value={"feature#6", "feature#3"}, operand=FeatureRestrictionOperand.OR)
            public void method() {
            }
        };
        FeatureRestriction featureRestriction = object.getClass().getMethod("method", new Class[0]).getAnnotation(FeatureRestriction.class);
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeatures((Object)"LICENSE-ANNOTATION-6", featureRestriction));
    }

    @Test
    public void testHasLicenseForFeaturesByAnnotation07() throws NoSuchMethodException {
        this.setupNullLicenseMocking("NULL-LICENSE-ANNOTATION-4");
        control.replay();
        Object object = new Object(){

            @FeatureRestriction(value={"feature#1", "feature#5"}, operand=FeatureRestrictionOperand.OR)
            public void method() {
            }
        };
        FeatureRestriction featureRestriction = object.getClass().getMethod("method", new Class[0]).getAnnotation(FeatureRestriction.class);
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeatures((Object)"NULL-LICENSE-ANNOTATION-4", featureRestriction));
    }

    @Test
    public void testHasLicenseForFeaturesByTarget01() throws NoSuchMethodException {
        License license = this.setupLicenseMocking("LICENSE-TARGET-1");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Object object = new Object(){

            @FeatureRestriction(value={"feature#1", "feature#5"})
            public void method() {
            }
        };
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeatures((Object)"LICENSE-TARGET-1", (AnnotatedElement)object.getClass().getMethod("method", new Class[0])));
    }

    @Test
    public void testHasLicenseForFeaturesByTarget02() throws NoSuchMethodException {
        License license = this.setupLicenseMocking("LICENSE-TARGET-2");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Object object = new Object(){

            @FeatureRestriction(value={"feature#1", "feature#3"})
            public void method() {
            }
        };
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeatures((Object)"LICENSE-TARGET-2", (AnnotatedElement)object.getClass().getMethod("method", new Class[0])));
    }

    @Test
    public void testHasLicenseForFeaturesByTarget03() throws NoSuchMethodException {
        License license = this.setupLicenseMocking("LICENSE-TARGET-3");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Object object = new Object(){

            @FeatureRestriction(value={"feature#6", "feature#3"})
            public void method() {
            }
        };
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeatures((Object)"LICENSE-TARGET-3", (AnnotatedElement)object.getClass().getMethod("method", new Class[0])));
    }

    @Test
    public void testHasLicenseForFeaturesByTarget04() throws NoSuchMethodException {
        License license = this.setupLicenseMocking("LICENSE-TARGET-4");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Object object = new Object(){

            @FeatureRestriction(value={"feature#1", "feature#5"}, operand=FeatureRestrictionOperand.OR)
            public void method() {
            }
        };
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeatures((Object)"LICENSE-TARGET-4", (AnnotatedElement)object.getClass().getMethod("method", new Class[0])));
    }

    @Test
    public void testHasLicenseForFeaturesByTarget05() throws NoSuchMethodException {
        License license = this.setupLicenseMocking("LICENSE-TARGET-5");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Object object = new Object(){

            @FeatureRestriction(value={"feature#1", "feature#3"}, operand=FeatureRestrictionOperand.OR)
            public void method() {
            }
        };
        Assert.assertTrue((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeatures((Object)"LICENSE-TARGET-5", (AnnotatedElement)object.getClass().getMethod("method", new Class[0])));
    }

    @Test
    public void testHasLicenseForFeaturesByTarget07() throws NoSuchMethodException {
        License license = this.setupLicenseMocking("LICENSE-TARGET-6");
        licenseValidator.validateLicense(license);
        EasyMock.expectLastCall();
        control.replay();
        Object object = new Object(){

            @FeatureRestriction(value={"feature#6", "feature#3"}, operand=FeatureRestrictionOperand.OR)
            public void method() {
            }
        };
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeatures((Object)"LICENSE-TARGET-6", (AnnotatedElement)object.getClass().getMethod("method", new Class[0])));
    }

    @Test
    public void testHasLicenseForFeaturesByTarget08() throws NoSuchMethodException {
        this.setupNullLicenseMocking("NULL-LICENSE-TARGET-4");
        control.replay();
        Object object = new Object(){

            @FeatureRestriction(value={"feature#1", "feature#5"}, operand=FeatureRestrictionOperand.OR)
            public void method() {
            }
        };
        Assert.assertFalse((String)"The returned value is not correct.", (boolean)this.manager.hasLicenseForFeatures((Object)"NULL-LICENSE-TARGET-4", (AnnotatedElement)object.getClass().getMethod("method", new Class[0])));
    }
}

