/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import java.lang.reflect.Member;
import java.lang.reflect.ReflectPermission;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Permission;
import java.util.ArrayList;
import net.nicholaswilliams.java.licensing.DataSignatureManager;
import net.nicholaswilliams.java.licensing.FeatureRestriction;
import net.nicholaswilliams.java.licensing.License;
import net.nicholaswilliams.java.licensing.LicenseManager;
import net.nicholaswilliams.java.licensing.LicenseSecurityManager;
import net.nicholaswilliams.java.licensing.ObjectSerializer;
import net.nicholaswilliams.java.licensing.SignedLicense;
import net.nicholaswilliams.java.licensing.immutable.ImmutableAbstractCollection;
import net.nicholaswilliams.java.licensing.immutable.ImmutableArrayList;
import net.nicholaswilliams.java.licensing.immutable.ImmutableIterator;
import net.nicholaswilliams.java.licensing.immutable.ImmutableLinkedHashSet;
import net.nicholaswilliams.java.licensing.immutable.ImmutableListIterator;
import net.nicholaswilliams.java.licensing.mock.StateFlag;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLicenseSecurityManager {
    private LicenseSecurityManager manager;

    @Before
    public void setUp() {
        this.manager = LicenseSecurityManager.getInstance();
    }

    @After
    public void tearDown() {
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSecurityManagerIsSuitableReplacement01() {
        LicenseSecurityManager.securityManagerIsSuitableReplacement(null);
    }

    @Test
    public void testSecurityManagerIsSuitableReplacement02() {
        final StateFlag stateFlag = new StateFlag();
        Assert.assertFalse((String)"The security manager should not be suitable.", (boolean)LicenseSecurityManager.securityManagerIsSuitableReplacement((SecurityManager)new SecurityManager(){

            public void checkMemberAccess(Class<?> clazz, int n) {
                if (stateFlag.state) {
                    Assert.fail((String)"checkMemberAccess should not have been called twice.");
                }
                stateFlag.state = true;
                Assert.assertSame((String)"The class is not correct.", License.class, clazz);
                Assert.assertEquals((String)"The access type is not correct.", (long)1L, (long)n);
            }

            @Override
            public void checkPermission(Permission permission) {
                Assert.fail((String)"checkPermission should not have been called.");
            }
        }));
        Assert.assertTrue((String)"checkMemberAccess should have been called.", (boolean)stateFlag.state);
    }

    @Test
    public void testSecurityManagerIsSuitableReplacement03() {
        final StateFlag stateFlag = new StateFlag();
        final StateFlag stateFlag2 = new StateFlag();
        Assert.assertFalse((String)"The security manager should not be suitable.", (boolean)LicenseSecurityManager.securityManagerIsSuitableReplacement((SecurityManager)new SecurityManager(){

            public void checkMemberAccess(Class<?> clazz, int n) {
                Assert.assertSame((String)"The class is not correct.", stateFlag.state ? LicenseManager.class : License.class, clazz);
                Assert.assertEquals((String)"The access type is not correct.", (long)1L, (long)n);
                if (stateFlag.state) {
                    stateFlag2.state = true;
                }
                stateFlag.state = true;
                if (clazz == License.class) {
                    throw new SecurityException();
                }
            }

            @Override
            public void checkPermission(Permission permission) {
                Assert.fail((String)"checkPermission should not have been called.");
            }
        }));
        Assert.assertTrue((String)"checkMemberAccess should have been called.", (boolean)stateFlag.state);
        Assert.assertTrue((String)"checkMemberAccess should have been called twice.", (boolean)stateFlag2.state);
    }

    @Test
    public void testSecurityManagerIsSuitableReplacement04() {
        final StateFlag stateFlag = new StateFlag();
        final StateFlag stateFlag2 = new StateFlag();
        final StateFlag stateFlag3 = new StateFlag();
        Assert.assertFalse((String)"The security manager should not be suitable.", (boolean)LicenseSecurityManager.securityManagerIsSuitableReplacement((SecurityManager)new SecurityManager(){

            public void checkMemberAccess(Class<?> clazz, int n) {
                Assert.assertSame((String)"The class is not correct.", stateFlag.state ? LicenseManager.class : License.class, clazz);
                Assert.assertEquals((String)"The access type is not correct.", (long)1L, (long)n);
                if (stateFlag.state) {
                    stateFlag2.state = true;
                }
                stateFlag.state = true;
                throw new SecurityException();
            }

            @Override
            public void checkPermission(Permission permission) {
                Assert.assertEquals((String)"The permission object is not correct.", RuntimePermission.class, permission.getClass());
                Assert.assertEquals((String)"The checked permission is not correct.", (Object)"setSecurityManager", (Object)permission.getName());
                stateFlag3.state = true;
            }
        }));
        Assert.assertTrue((String)"checkMemberAccess should have been called.", (boolean)stateFlag.state);
        Assert.assertTrue((String)"checkMemberAccess should have been called twice.", (boolean)stateFlag2.state);
        Assert.assertTrue((String)"checkPermission should have been called.", (boolean)stateFlag3.state);
    }

    @Test
    public void testSecurityManagerIsSuitableReplacement05() {
        final StateFlag stateFlag = new StateFlag();
        final StateFlag stateFlag2 = new StateFlag();
        final StateFlag stateFlag3 = new StateFlag();
        Assert.assertTrue((String)"The security manager should be suitable.", (boolean)LicenseSecurityManager.securityManagerIsSuitableReplacement((SecurityManager)new SecurityManager(){

            public void checkMemberAccess(Class<?> clazz, int n) {
                Assert.assertSame((String)"The class is not correct.", stateFlag.state ? LicenseManager.class : License.class, clazz);
                Assert.assertEquals((String)"The access type is not correct.", (long)1L, (long)n);
                if (stateFlag.state) {
                    stateFlag2.state = true;
                }
                stateFlag.state = true;
                throw new SecurityException();
            }

            @Override
            public void checkPermission(Permission permission) {
                Assert.assertEquals((String)"The permission object is not correct.", RuntimePermission.class, permission.getClass());
                Assert.assertEquals((String)"The checked permission is not correct.", (Object)"setSecurityManager", (Object)permission.getName());
                stateFlag3.state = true;
                throw new SecurityException();
            }
        }));
        Assert.assertTrue((String)"checkMemberAccess should have been called.", (boolean)stateFlag.state);
        Assert.assertTrue((String)"checkMemberAccess should have been called twice.", (boolean)stateFlag2.state);
        Assert.assertTrue((String)"checkPermission should have been called.", (boolean)stateFlag3.state);
    }

    @Test(expected=SecurityException.class)
    public void testCheckPermission01() {
        this.manager.checkPermission((Permission)new RuntimePermission("setSecurityManager"));
    }

    @Test
    public void testCheckPermission02() {
        this.manager.checkPermission((Permission)new ReflectPermission("suppressAccessChecks"));
    }

    @Test(expected=SecurityException.class)
    public void testCheckMemberAccess01() {
        this.manager.checkMemberAccess(DataSignatureManager.class, 1);
    }

    @Test(expected=SecurityException.class)
    public void testCheckMemberAccess02() {
        this.manager.checkMemberAccess(License.class, 1);
    }

    @Test(expected=SecurityException.class)
    public void testCheckMemberAccess03() {
        this.manager.checkMemberAccess(LicenseManager.class, 1);
    }

    @Test(expected=SecurityException.class)
    public void testCheckMemberAccess04() {
        this.manager.checkMemberAccess(LicenseSecurityManager.class, 1);
    }

    @Test(expected=SecurityException.class)
    public void testCheckMemberAccess05() {
        this.manager.checkMemberAccess(ObjectSerializer.class, 1);
    }

    @Test
    public void testCheckMemberAccess06() {
        this.manager.checkMemberAccess(SignedLicense.class, 1);
    }

    @Test(expected=SecurityException.class)
    public void testCheckMemberAccess07() {
        this.manager.checkMemberAccess(ImmutableAbstractCollection.class, 1);
    }

    @Test(expected=SecurityException.class)
    public void testCheckMemberAccess08() {
        this.manager.checkMemberAccess(ImmutableArrayList.class, 1);
    }

    @Test(expected=SecurityException.class)
    public void testCheckMemberAccess09() {
        this.manager.checkMemberAccess(ImmutableIterator.class, 1);
    }

    @Test(expected=SecurityException.class)
    public void testCheckMemberAccess10() {
        this.manager.checkMemberAccess(ImmutableLinkedHashSet.class, 1);
    }

    @Test(expected=SecurityException.class)
    public void testCheckMemberAccess11() {
        this.manager.checkMemberAccess(ImmutableListIterator.class, 1);
    }

    @Test
    public void testCheckMemberAccess12() {
        this.manager.checkMemberAccess(DataSignatureManager.class, 0);
    }

    @Test
    public void testCheckMemberAccess13() {
        this.manager.checkMemberAccess(License.class, 0);
    }

    @Test
    public void testCheckMemberAccess14() {
        this.manager.checkMemberAccess(LicenseManager.class, 0);
    }

    @Test
    public void testCheckMemberAccess15() {
        this.manager.checkMemberAccess(LicenseSecurityManager.class, 0);
    }

    @Test
    public void testCheckMemberAccess16() {
        this.manager.checkMemberAccess(ObjectSerializer.class, 0);
    }

    @Test
    public void testCheckMemberAccess17() {
        this.manager.checkMemberAccess(SignedLicense.class, 0);
    }

    @Test
    public void testCheckMemberAccess18() {
        this.manager.checkMemberAccess(ImmutableAbstractCollection.class, 0);
    }

    @Test
    public void testCheckMemberAccess19() {
        this.manager.checkMemberAccess(ImmutableArrayList.class, 0);
    }

    @Test
    public void testCheckMemberAccess20() {
        this.manager.checkMemberAccess(ImmutableIterator.class, 0);
    }

    @Test
    public void testCheckMemberAccess21() {
        this.manager.checkMemberAccess(ImmutableLinkedHashSet.class, 0);
    }

    @Test
    public void testCheckMemberAccess22() {
        this.manager.checkMemberAccess(ImmutableListIterator.class, 0);
    }

    @Test
    public void testCheckMemberAccess23() {
        this.manager.checkMemberAccess(FeatureRestriction.class, 0);
    }

    @Test
    public void testCheckMemberAccess24() {
        this.manager.checkMemberAccess(FeatureRestriction.class, 1);
    }

    @Test
    public void testCheckMemberAccess25() {
        this.manager.checkMemberAccess(String.class, 1);
    }

    @Test
    public void testCheckMemberAccess26() {
        this.manager.checkMemberAccess(Test.class, 1);
    }

    @Test
    public void testCheckMemberAccess27() {
        this.manager.checkMemberAccess(Member.class, 1);
    }

    @Test
    public void testCheckMemberAccess28() {
        this.manager.checkMemberAccess(Object.class, 1);
    }

    @Test
    public void testCheckMemberAccess29() {
        this.manager.checkMemberAccess(ArrayList.class, 1);
    }

    @Test(expected=SecurityException.class)
    public void testPrivateReflection01() throws NoSuchFieldException {
        License.class.getDeclaredField("goodAfterDate");
    }

    @Test(expected=SecurityException.class)
    public void testPrivateReflection02() throws NoSuchFieldException {
        LicenseManager.class.getDeclaredField("licenseCache");
    }

    @Test(expected=SecurityException.class)
    public void testPrivateReflection03() throws NoSuchFieldException {
        LicenseManager.class.getDeclaredClasses();
    }

    @Test
    public void testSecurityManagerWasSet() {
        Assert.assertSame((String)"The security manager mas not set correctly.", (Object)this.manager, (Object)System.getSecurityManager());
    }

    @Test(expected=SecurityException.class)
    public void testSetSecurityManager01() {
        System.setSecurityManager(null);
    }

    @Test(expected=SecurityException.class)
    public void testSetSecurityManager02() {
        System.setSecurityManager((SecurityManager)this.manager);
    }

    @Test(expected=SecurityException.class)
    public void testReflectionOnClassClassBlocked() throws NoSuchMethodException {
        Class.class.getDeclaredMethod("privateGetDeclaredMethods", Boolean.TYPE);
    }

    @Test(expected=SecurityException.class)
    public void testReflectionOnSecurityManagerBlocked() throws NoSuchFieldException {
        System.class.getDeclaredField("security");
    }

    @Test
    public void testCheckPermission() {
        this.manager.checkPermission((Permission)new ReflectPermission("fakePermission"), new Object());
    }

    @Test
    public void testCheckExec() {
        this.manager.checkExec("test");
    }

    @Test
    public void testCheckLink() {
        this.manager.checkLink("test");
    }

    @Test
    public void testCheckRead() {
        this.manager.checkRead("test", new Object());
    }

    @Test
    public void testCheckDelete() {
        this.manager.checkDelete("test");
    }

    @Test
    public void testCheckConnect() {
        this.manager.checkConnect("test", 1, new Object());
    }

    @Test
    public void testCheckListen() {
        this.manager.checkListen(1);
    }

    @Test
    public void testCheckAccept() {
        this.manager.checkAccept("test", 1);
    }

    @Test
    public void testCheckMulticast() throws UnknownHostException {
        this.manager.checkMulticast(InetAddress.getByName("127.0.0.1"));
    }

    @Test
    public void testCheckMulticastWithByte() throws UnknownHostException {
        this.manager.checkMulticast(InetAddress.getByName("127.0.0.1"), (byte)0);
    }

    @Test
    public void testCheckPropertiesAccess() {
        this.manager.checkPropertiesAccess();
    }

    @Test
    public void testCheckPrintJobAccess() {
        this.manager.checkPrintJobAccess();
    }

    @Test
    public void testCheckSystemClipBoardAccess() {
        this.manager.checkSystemClipboardAccess();
    }

    @Test
    public void testCheckAwtEventQueueAccess() {
        this.manager.checkAwtEventQueueAccess();
    }

    @Test
    public void testCheckPackageDefinition() {
        this.manager.checkPackageDefinition("test");
    }

    @Test
    public void testCheckSetFactory() {
        this.manager.checkSetFactory();
    }
}

