/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import net.nicholaswilliams.java.licensing.MockTestObject1;
import net.nicholaswilliams.java.licensing.MockTestObject2;
import net.nicholaswilliams.java.licensing.ObjectSerializer;
import net.nicholaswilliams.java.licensing.exception.ObjectTypeNotExpectedException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestObjectSerializer {
    ObjectSerializer serializer = new ObjectSerializer();

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testWriteObject1() throws Exception {
        MockTestObject1 mockTestObject1 = new MockTestObject1();
        byte[] byArray = this.serializer.writeObject((Serializable)mockTestObject1);
        Assert.assertNotNull((String)"The array should not be null.", (Object)byArray);
        Assert.assertTrue((String)"The array shoudl not be empty.", (byArray.length > 0 ? 1 : 0) != 0);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        Assert.assertNotNull((String)"The object should not be null.", (Object)object);
        Assert.assertEquals((String)"The object is not the right kind of object.", MockTestObject1.class, object.getClass());
        MockTestObject1 mockTestObject12 = (MockTestObject1)object;
        Assert.assertFalse((String)"The objects should not be the same object.", (mockTestObject12 == mockTestObject1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The object is not correct.", (Object)mockTestObject1, (Object)mockTestObject12);
    }

    @Test
    public void testWriteObject2() throws Exception {
        MockTestObject1 mockTestObject1 = new MockTestObject1();
        mockTestObject1.coolTest = true;
        Arrays.fill(mockTestObject1.myArray, (byte)12);
        byte[] byArray = this.serializer.writeObject((Serializable)mockTestObject1);
        Assert.assertNotNull((String)"The array should not be null.", (Object)byArray);
        Assert.assertTrue((String)"The array shoudl not be empty.", (byArray.length > 0 ? 1 : 0) != 0);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        Assert.assertNotNull((String)"The object should not be null.", (Object)object);
        Assert.assertEquals((String)"The object is not the right kind of object.", MockTestObject1.class, object.getClass());
        MockTestObject1 mockTestObject12 = (MockTestObject1)object;
        Assert.assertFalse((String)"The objects should not be the same object.", (mockTestObject12 == mockTestObject1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The object is not correct.", (Object)mockTestObject1, (Object)mockTestObject12);
    }

    @Test
    public void testWriteObject3() throws Exception {
        MockTestObject2 mockTestObject2 = new MockTestObject2();
        byte[] byArray = this.serializer.writeObject((Serializable)mockTestObject2);
        Assert.assertNotNull((String)"The array should not be null.", (Object)byArray);
        Assert.assertTrue((String)"The array shoudl not be empty.", (byArray.length > 0 ? 1 : 0) != 0);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        Assert.assertNotNull((String)"The object should not be null.", (Object)object);
        Assert.assertEquals((String)"The object is not the right kind of object.", MockTestObject2.class, object.getClass());
        MockTestObject2 mockTestObject22 = (MockTestObject2)object;
        Assert.assertFalse((String)"The objects should not be the same object.", (mockTestObject22 == mockTestObject2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The object is not correct.", (Object)mockTestObject2, (Object)mockTestObject22);
    }

    @Test
    public void testWriteObject4() throws Exception {
        MockTestObject2 mockTestObject2 = new MockTestObject2();
        mockTestObject2.aString = "another test string";
        Arrays.fill(mockTestObject2.password, 'b');
        byte[] byArray = this.serializer.writeObject((Serializable)mockTestObject2);
        Assert.assertNotNull((String)"The array should not be null.", (Object)byArray);
        Assert.assertTrue((String)"The array shoudl not be empty.", (byArray.length > 0 ? 1 : 0) != 0);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        Assert.assertNotNull((String)"The object should not be null.", (Object)object);
        Assert.assertEquals((String)"The object is not the right kind of object.", MockTestObject2.class, object.getClass());
        MockTestObject2 mockTestObject22 = (MockTestObject2)object;
        Assert.assertFalse((String)"The objects should not be the same object.", (mockTestObject22 == mockTestObject2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The object is not correct.", (Object)mockTestObject2, (Object)mockTestObject22);
    }

    @Test(expected=ObjectTypeNotExpectedException.class)
    public void testReadObject1() throws Exception {
        MockTestObject1 mockTestObject1 = new MockTestObject1();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
        objectOutputStream.writeObject(mockTestObject1);
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.serializer.readObject(MockTestObject2.class, byArray);
    }

    @Test
    public void testReadObject2() throws Exception {
        MockTestObject1 mockTestObject1 = new MockTestObject1();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
        objectOutputStream.writeObject(mockTestObject1);
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        MockTestObject1 mockTestObject12 = (MockTestObject1)this.serializer.readObject(MockTestObject1.class, byArray);
        Assert.assertNotNull((String)"The returned object should not be null.", (Object)mockTestObject12);
        Assert.assertFalse((String)"The returned object should not be the same.", (mockTestObject12 == mockTestObject1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The returned object should be equal.", (Object)mockTestObject1, (Object)mockTestObject12);
    }

    @Test
    public void testReadObject3() throws Exception {
        MockTestObject1 mockTestObject1 = new MockTestObject1();
        mockTestObject1.coolTest = true;
        Arrays.fill(mockTestObject1.myArray, (byte)12);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
        objectOutputStream.writeObject(mockTestObject1);
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        MockTestObject1 mockTestObject12 = (MockTestObject1)this.serializer.readObject(MockTestObject1.class, byArray);
        Assert.assertNotNull((String)"The returned object should not be null.", (Object)mockTestObject12);
        Assert.assertFalse((String)"The returned object should not be the same.", (mockTestObject12 == mockTestObject1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The returned object should be equal.", (Object)mockTestObject1, (Object)mockTestObject12);
    }

    @Test(expected=ObjectTypeNotExpectedException.class)
    public void testReadObject4() throws Exception {
        MockTestObject2 mockTestObject2 = new MockTestObject2();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
        objectOutputStream.writeObject(mockTestObject2);
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.serializer.readObject(MockTestObject1.class, byArray);
    }

    @Test
    public void testReadObject5() throws Exception {
        MockTestObject2 mockTestObject2 = new MockTestObject2();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
        objectOutputStream.writeObject(mockTestObject2);
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        MockTestObject2 mockTestObject22 = (MockTestObject2)this.serializer.readObject(MockTestObject2.class, byArray);
        Assert.assertNotNull((String)"The returned object should not be null.", (Object)mockTestObject22);
        Assert.assertFalse((String)"The returned object should not be the same.", (mockTestObject22 == mockTestObject2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The returned object should be equal.", (Object)mockTestObject2, (Object)mockTestObject22);
    }

    @Test
    public void testReadObject6() throws Exception {
        MockTestObject2 mockTestObject2 = new MockTestObject2();
        mockTestObject2.aString = "another test string";
        Arrays.fill(mockTestObject2.password, 'b');
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
        objectOutputStream.writeObject(mockTestObject2);
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        MockTestObject2 mockTestObject22 = (MockTestObject2)this.serializer.readObject(MockTestObject2.class, byArray);
        Assert.assertNotNull((String)"The returned object should not be null.", (Object)mockTestObject22);
        Assert.assertFalse((String)"The returned object should not be the same.", (mockTestObject22 == mockTestObject2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The returned object should be equal.", (Object)mockTestObject2, (Object)mockTestObject22);
    }

    @Test
    public void testBoth1() {
        MockTestObject1 mockTestObject1 = new MockTestObject1();
        byte[] byArray = this.serializer.writeObject((Serializable)mockTestObject1);
        MockTestObject1 mockTestObject12 = (MockTestObject1)this.serializer.readObject(MockTestObject1.class, byArray);
        Assert.assertNotNull((String)"The object should not be null.", (Object)mockTestObject12);
        Assert.assertFalse((String)"The object should not be the same.", (mockTestObject12 == mockTestObject1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The object should be equal.", (Object)mockTestObject1, (Object)mockTestObject12);
    }

    @Test
    public void testBoth2() {
        MockTestObject1 mockTestObject1 = new MockTestObject1();
        mockTestObject1.coolTest = true;
        Arrays.fill(mockTestObject1.myArray, (byte)12);
        byte[] byArray = this.serializer.writeObject((Serializable)mockTestObject1);
        MockTestObject1 mockTestObject12 = (MockTestObject1)this.serializer.readObject(MockTestObject1.class, byArray);
        Assert.assertNotNull((String)"The object should not be null.", (Object)mockTestObject12);
        Assert.assertFalse((String)"The object should not be the same.", (mockTestObject12 == mockTestObject1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The object should be equal.", (Object)mockTestObject1, (Object)mockTestObject12);
    }

    @Test
    public void testBoth3() {
        MockTestObject2 mockTestObject2 = new MockTestObject2();
        byte[] byArray = this.serializer.writeObject((Serializable)mockTestObject2);
        MockTestObject2 mockTestObject22 = (MockTestObject2)this.serializer.readObject(MockTestObject2.class, byArray);
        Assert.assertNotNull((String)"The object should not be null.", (Object)mockTestObject22);
        Assert.assertFalse((String)"The object should not be the same.", (mockTestObject22 == mockTestObject2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The object should be equal.", (Object)mockTestObject2, (Object)mockTestObject22);
    }

    @Test
    public void testBoth4() {
        MockTestObject2 mockTestObject2 = new MockTestObject2();
        mockTestObject2.aString = "another test string";
        Arrays.fill(mockTestObject2.password, 'b');
        byte[] byArray = this.serializer.writeObject((Serializable)mockTestObject2);
        MockTestObject2 mockTestObject22 = (MockTestObject2)this.serializer.readObject(MockTestObject2.class, byArray);
        Assert.assertNotNull((String)"The object should not be null.", (Object)mockTestObject22);
        Assert.assertFalse((String)"The object should not be the same.", (mockTestObject22 == mockTestObject2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The object should be equal.", (Object)mockTestObject2, (Object)mockTestObject22);
    }
}

