/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.encryption;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.nicholaswilliams.java.licensing.encryption.Encryptor;
import net.nicholaswilliams.java.licensing.exception.FailedToDecryptException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestEncryptor {
    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testConstructionForbidden() throws IllegalAccessException, InstantiationException, NoSuchMethodException {
        Constructor constructor = Encryptor.class.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        try {
            constructor.newInstance(new Object[0]);
            Assert.fail((String)"Expected exception java.lang.reflect.InvocationTargetException, but got no exception.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            Assert.assertNotNull((String)"Expected cause for InvocationTargetException, but got no cause.", (Object)throwable);
            Assert.assertSame((String)("Expected exception java.lang.RuntimeException, but got " + throwable.getClass()), RuntimeException.class, throwable.getClass());
            Assert.assertEquals((String)"The message was incorrect.", (Object)"This class cannot be instantiated.", (Object)throwable.getMessage());
        }
    }

    private byte[] getPadded(String string, int n) throws Exception {
        Method method = Encryptor.class.getDeclaredMethod("pad", byte[].class, Integer.TYPE);
        method.setAccessible(true);
        return (byte[])method.invoke(null, string.getBytes(), n);
    }

    @Test
    public void testPad1() throws Exception {
        String string = "12345678901234567890";
        int n = 10;
        byte[] byArray = this.getPadded(string, n);
        String string2 = new String(byArray);
        string2 = string2.substring(0, string2.length() - 1);
        Assert.assertNotNull((String)"The padded string should not be null.", (Object)byArray);
        Assert.assertEquals((String)"The padded string has the wrong length.", (long)(string.length() + 1), (long)byArray.length);
        Assert.assertEquals((String)"The padded string should actually just be identical.", (Object)string, (Object)string2);
        Assert.assertEquals((String)"The last byte is wrong.", (long)1L, (long)byArray[byArray.length - 1]);
    }

    private void testPad2(int n) throws Exception {
        String string = "g1nger";
        byte[] byArray = this.getPadded(string, n);
        Assert.assertNotNull((String)"The padded string should not be null.", (Object)byArray);
        Assert.assertEquals((String)"The padded string has the wrong length.", (long)(n + 1), (long)byArray.length);
        Assert.assertEquals((String)"The last byte is wrong.", (long)(n - string.length() + 1), (long)byArray[byArray.length - 1]);
    }

    @Test
    public void testPad10() throws Exception {
        this.testPad2(10);
    }

    @Test
    public void testPad11() throws Exception {
        this.testPad2(11);
    }

    @Test
    public void testPad13() throws Exception {
        this.testPad2(13);
    }

    @Test
    public void testPad17() throws Exception {
        this.testPad2(17);
    }

    @Test
    public void testPad19() throws Exception {
        this.testPad2(19);
    }

    @Test
    public void testPad23() throws Exception {
        this.testPad2(23);
    }

    @Test
    public void testPad29() throws Exception {
        this.testPad2(29);
    }

    @Test
    public void testUnPad1() throws Exception {
        byte[] byArray = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 1};
        String string = new String(byArray);
        Method method = Encryptor.class.getDeclaredMethod("unPad", byte[].class);
        method.setAccessible(true);
        byte[] byArray2 = (byte[])method.invoke(null, new Object[]{string.getBytes()});
        String string2 = new String(byArray2);
        Assert.assertNotNull((String)"The unPadded string should not be null.", (Object)byArray2);
        Assert.assertEquals((String)"The unPadded string is not correct.", (Object)"12345678901234567890", (Object)string2);
    }

    @Test
    public void testUnPad2() throws Exception {
        byte[] byArray = new byte[]{103, 49, 110, 103, 101, 114, 1};
        String string = new String(byArray);
        Method method = Encryptor.class.getDeclaredMethod("unPad", byte[].class);
        method.setAccessible(true);
        byte[] byArray2 = (byte[])method.invoke(null, new Object[]{string.getBytes()});
        String string2 = new String(byArray2);
        Assert.assertNotNull((String)"The unPadded string should not be null.", (Object)byArray2);
        Assert.assertEquals((String)"The unPadded string is not correct.", (Object)"g1nger", (Object)string2);
    }

    private void testUnPad3(int n) throws Exception {
        String string = "g1nger";
        byte[] byArray = this.getPadded(string, n);
        Method method = Encryptor.class.getDeclaredMethod("unPad", byte[].class);
        method.setAccessible(true);
        byte[] byArray2 = (byte[])method.invoke(null, new Object[]{byArray});
        String string2 = new String(byArray2);
        Assert.assertNotNull((String)"The unPadded string should not be null.", (Object)byArray2);
        Assert.assertEquals((String)"The unPadded string is not correct.", (Object)string, (Object)string2);
    }

    @Test
    public void testUnPad10() throws Exception {
        this.testUnPad3(10);
    }

    @Test
    public void testUnPad11() throws Exception {
        this.testUnPad3(11);
    }

    @Test
    public void testUnPad13() throws Exception {
        this.testUnPad3(13);
    }

    @Test
    public void testUnPad17() throws Exception {
        this.testUnPad3(17);
    }

    @Test
    public void testUnPad19() throws Exception {
        this.testUnPad3(19);
    }

    @Test
    public void testUnPad23() throws Exception {
        this.testUnPad3(23);
    }

    @Test
    public void testUnPad29() throws Exception {
        this.testUnPad3(29);
    }

    @Test
    public void testEncrypt1() {
        String string = "g1nger";
        String string2 = Encryptor.encrypt((String)string);
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string2);
        Assert.assertTrue((String)"The encrypted string should have length greater than the original string.", (string2.length() > string.length() ? 1 : 0) != 0);
    }

    @Test
    public void testPasswordBasedEncrypt1() {
        String string = "g1nger";
        String string2 = Encryptor.encrypt((String)string, (char[])"myCoolPassword".toCharArray());
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string2);
        Assert.assertTrue((String)"The encrypted string should have length greater than the original string.", (string2.length() > string.length() ? 1 : 0) != 0);
    }

    @Test
    public void testEncrypt2() {
        String string = "aoeugalogeual9o87gu3l2'r3ghsproguhSNoehusNOEhusntoehoUZTOHEUNT<>H<(>*JGJCROEHunt.huaahsnoeuhs,cr.a,g.ulreo8gukchrseunhaonteihaorceugaroscuh.nsphilraeugil98g'l38rgph's23cnhps\t.c,huiscraoeha/l-iuh.p-sihtaosntiha.,edoguoeuar/oe-suihbtnaoseihtenoatnuaoehik/eolrkl=alhil.,]'ry3c012]cp5/239cpyhl.',-huilreoh/eho/ik0hceo/ikcrih.,0/igc34yyr2/34gy8[p90.8icgeurlxhkelocugxu0egoi/crleohil/p',hy/1c'gy029348y[.p,90gcileo;hl/GLRCDHIRCH)($*:(?YC{>)(i8e98cloraihl'hy34/l'cg809[i8u09/10ch32clr5hps'th,.tsnuihaeokc8gao[e09ig8caoelchuitnsoeabitnoeudh/lroeuceucog8xxgp,0ldynst43htnys5hhy543tsnh65crl234hyig8oeu90[euo8icgrheoistahoeaehosnuthoelrcigoeu[09icglerpuhdtnoseudh,ocilc0oeu7890[e8oi2349cg5hcl234h5l/r2c43/lyr.cpg,lrcioghersueusih";
        String string2 = Encryptor.encrypt((String)string);
        String string3 = Encryptor.encrypt((String)string);
        String string4 = Encryptor.encrypt((String)string);
        String string5 = Encryptor.encrypt((String)string);
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string2);
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string3);
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string4);
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string5);
        Assert.assertEquals((String)"The encrypted string is not the same.", (Object)string2, (Object)string3);
        Assert.assertEquals((String)"The encrypted string is not the same.", (Object)string2, (Object)string4);
        Assert.assertEquals((String)"The encrypted string is not the same.", (Object)string2, (Object)string5);
        Assert.assertEquals((String)"The encrypted string is not the same.", (Object)string3, (Object)string4);
        Assert.assertEquals((String)"The encrypted string is not the same.", (Object)string3, (Object)string5);
        Assert.assertEquals((String)"The encrypted string is not the same.", (Object)string4, (Object)string5);
    }

    @Test
    public void testPasswordBasedEncrypt2() {
        String string = "aoeugalogeual9o87gu3l2'r3ghsproguhSNoehusNOEhusntoehoUZTOHEUNT<>H<(>*JGJCROEHunt.huaahsnoeuhs,cr.a,g.ulreo8gukchrseunhaonteihaorceugaroscuh.nsphilraeugil98g'l38rgph's23cnhps\t.c,huiscraoeha/l-iuh.p-sihtaosntiha.,edoguoeuar/oe-suihbtnaoseihtenoatnuaoehik/eolrkl=alhil.,]'ry3c012]cp5/239cpyhl.',-huilreoh/eho/ik0hceo/ikcrih.,0/igc34yyr2/34gy8[p90.8icgeurlxhkelocugxu0egoi/crleohil/p',hy/1c'gy029348y[.p,90gcileo;hl/GLRCDHIRCH)($*:(?YC{>)(i8e98cloraihl'hy34/l'cg809[i8u09/10ch32clr5hps'th,.tsnuihaeokc8gao[e09ig8caoelchuitnsoeabitnoeudh/lroeuceucog8xxgp,0ldynst43htnys5hhy543tsnh65crl234hyig8oeu90[euo8icgrheoistahoeaehosnuthoelrcigoeu[09icglerpuhdtnoseudh,ocilc0oeu7890[e8oi2349cg5hcl234h5l/r2c43/lyr.cpg,lrcioghersueusih";
        String string2 = Encryptor.encrypt((String)string, (char[])"myOtherPassword2".toCharArray());
        String string3 = Encryptor.encrypt((String)string, (char[])"myOtherPassword2".toCharArray());
        String string4 = Encryptor.encrypt((String)string, (char[])"yourOtherPassword2".toCharArray());
        String string5 = Encryptor.encrypt((String)string, (char[])"yourOtherPassword2".toCharArray());
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string2);
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string3);
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string4);
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string5);
        Assert.assertEquals((String)"The encrypted string is not the same.", (Object)string2, (Object)string3);
        Assert.assertEquals((String)"The encrypted string is not the same.", (Object)string4, (Object)string5);
        Assert.assertFalse((String)"The encrypted string is not the same.", (boolean)string2.equals(string4));
        Assert.assertFalse((String)"The encrypted string is not the same.", (boolean)string2.equals(string5));
        Assert.assertFalse((String)"The encrypted string is not the same.", (boolean)string3.equals(string4));
        Assert.assertFalse((String)"The encrypted string is not the same.", (boolean)string3.equals(string5));
    }

    @Test
    public void testEncrypt3() {
        String string = "NSARPhey360gZ2xTOaswGn6lWCd01poo1AW8o0Oobudbf2MNe38lX21EpHEFGl-MKgZnPZKsSHrDFXjL1CvtWqQ2JN6RuMKW0iht1TacVKE";
        String string2 = "testAPasswordThatIsLongerThanThePaddingLengthToPreventRandomness";
        String string3 = Encryptor.encrypt((String)string2);
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string3);
        Assert.assertEquals((String)"The encrypted string is not the same.", (Object)string, (Object)string3);
    }

    @Test
    public void testPasswordBasedEncrypt3() {
        String string = "YPEXhIzBx1VzkbqMwaS2QpMPQJCY9kALXLYY0HFWRCSpRobyCrAGLtwNPnEKDW_TKMSRzf7BAUHFueySb_dh2tISTe8zx-uZ_WG-c06x2Ns";
        String string2 = "testAPasswordThatIsLongerThanThePaddingLengthToPreventRandomness";
        String string3 = Encryptor.encrypt((String)string2, (char[])"lastEncryptionPassword3".toCharArray());
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string3);
        Assert.assertEquals((String)"The encrypted string is not the same.", (Object)string, (Object)string3);
    }

    @Test
    public void testDecrypt1() {
        String string = "foo";
        String string2 = Encryptor.encrypt((String)string);
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string2);
        String string3 = Encryptor.decrypt((String)string2);
        Assert.assertNotNull((String)"The decrypted string should not be null.", (Object)string3);
        Assert.assertFalse((String)"The decrypted string should not equal the encrypted string.", (boolean)string2.equals(string3));
        Assert.assertEquals((String)"The decrypted string should equal the original string.", (Object)string, (Object)string3);
    }

    @Test
    public void testPasswordBasedDecrypt1() {
        String string = "foo";
        String string2 = Encryptor.encrypt((String)string, (char[])"myDecryptPassword1".toCharArray());
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string2);
        String string3 = Encryptor.decrypt((String)string2, (char[])"myDecryptPassword1".toCharArray());
        Assert.assertNotNull((String)"The decrypted string should not be null.", (Object)string3);
        Assert.assertFalse((String)"The decrypted string should not equal the encrypted string.", (boolean)string2.equals(string3));
        Assert.assertEquals((String)"The decrypted string should equal the original string.", (Object)string, (Object)string3);
        try {
            Encryptor.decrypt((String)string2, (char[])"MyDecryptPassword1".toCharArray());
            Assert.fail((String)"Expected FailedToDecryptException, but no exception thrown.");
        }
        catch (FailedToDecryptException failedToDecryptException) {
            // empty catch block
        }
    }

    @Test
    public void testDecrypt2() {
        String string = "g1nger";
        String string2 = Encryptor.encrypt((String)string);
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string2);
        String string3 = Encryptor.decrypt((String)string2);
        Assert.assertNotNull((String)"The decrypted string should not be null.", (Object)string3);
        Assert.assertFalse((String)"The decrypted string should not equal the encrypted string.", (boolean)string2.equals(string3));
        Assert.assertEquals((String)"The decrypted string should equal the original string.", (Object)string, (Object)string3);
    }

    @Test
    public void testPasswordBasedDecrypt2() {
        String string = "g1nger";
        String string2 = Encryptor.encrypt((String)string, (char[])"yourDecryptPassword2".toCharArray());
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string2);
        String string3 = Encryptor.decrypt((String)string2, (char[])"yourDecryptPassword2".toCharArray());
        Assert.assertNotNull((String)"The decrypted string should not be null.", (Object)string3);
        Assert.assertFalse((String)"The decrypted string should not equal the encrypted string.", (boolean)string2.equals(string3));
        Assert.assertEquals((String)"The decrypted string should equal the original string.", (Object)string, (Object)string3);
        try {
            Encryptor.decrypt((String)string2, (char[])"YourDecryptPassword2".toCharArray());
            Assert.fail((String)"Expected FailedToDecryptException, but no exception thrown.");
        }
        catch (FailedToDecryptException failedToDecryptException) {
            // empty catch block
        }
    }

    @Test
    public void testDecrypt3() {
        String string = "testAPasswordThatIsLongerThanThePaddingLengthToPreventRandomness";
        String string2 = Encryptor.encrypt((String)string);
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string2);
        String string3 = Encryptor.decrypt((String)string2);
        Assert.assertNotNull((String)"The decrypted string should not be null.", (Object)string3);
        Assert.assertFalse((String)"The decrypted string should not equal the encrypted string.", (boolean)string2.equals(string3));
        Assert.assertEquals((String)"The decrypted string should equal the original string.", (Object)string, (Object)string3);
    }

    @Test
    public void testPasswordBasedDecrypt3() {
        String string = "testAPasswordThatIsLongerThanThePaddingLengthToPreventRandomness";
        String string2 = Encryptor.encrypt((String)string, (char[])"hisdecryptpassword3".toCharArray());
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string2);
        String string3 = Encryptor.decrypt((String)string2, (char[])"hisdecryptpassword3".toCharArray());
        Assert.assertNotNull((String)"The decrypted string should not be null.", (Object)string3);
        Assert.assertFalse((String)"The decrypted string should not equal the encrypted string.", (boolean)string2.equals(string3));
        Assert.assertEquals((String)"The decrypted string should equal the original string.", (Object)string, (Object)string3);
        try {
            Encryptor.decrypt((String)string2, (char[])"hisDecryptPassword3".toCharArray());
            Assert.fail((String)"Expected FailedToDecryptException, but no exception thrown.");
        }
        catch (FailedToDecryptException failedToDecryptException) {
            // empty catch block
        }
    }

    @Test
    public void testDecrypt4() {
        String string = "aoeugalogeual9o87gu3l2'r3ghsproguhSNoehusNOEhusntoehoUZTOHEUNT<>H<(>*JGJCROEHunt.huaahsnoeuhs,cr.a,g.ulreo8gukchrseunhaonteihaorceugaroscuh.nsphilraeugil98g'l38rgph's23cnhps\t.c,huiscraoeha/l-iuh.p-sihtaosntiha.,edoguoeuar/oe-suihbtnaoseihtenoatnuaoehik/eolrkl=alhil.,]'ry3c012]cp5/239cpyhl.',-huilreoh/eho/ik0hceo/ikcrih.,0/igc34yyr2/34gy8[p90.8icgeurlxhkelocugxu0egoi/crleohil/p',hy/1c'gy029348y[.p,90gcileo;hl/GLRCDHIRCH)($*:(?YC{>)(i8e98cloraihl'hy34/l'cg809[i8u09/10ch32clr5hps'th,.tsnuihaeokc8gao[e09ig8caoelchuitnsoeabitnoeudh/lroeuceucog8xxgp,0ldynst43htnys5hhy543tsnh65crl234hyig8oeu90[euo8icgrheoistahoeaehosnuthoelrcigoeu[09icglerpuhdtnoseudh,ocilc0oeu7890[e8oi2349cg5hcl234h5l/r2c43/lyr.cpg,lrcioghersueusih";
        String string2 = Encryptor.encrypt((String)string);
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string2);
        String string3 = Encryptor.decrypt((String)string2);
        Assert.assertNotNull((String)"The decrypted string should not be null.", (Object)string3);
        Assert.assertFalse((String)"The decrypted string should not equal the encrypted string.", (boolean)string2.equals(string3));
        Assert.assertEquals((String)"The decrypted string should equal the original string.", (Object)string, (Object)string3);
    }

    @Test
    public void testPasswordBasedDecrypt4() {
        String string = "aoeugalogeual9o87gu3l2'r3ghsproguhSNoehusNOEhusntoehoUZTOHEUNT<>H<(>*JGJCROEHunt.huaahsnoeuhs,cr.a,g.ulreo8gukchrseunhaonteihaorceugaroscuh.nsphilraeugil98g'l38rgph's23cnhps\t.c,huiscraoeha/l-iuh.p-sihtaosntiha.,edoguoeuar/oe-suihbtnaoseihtenoatnuaoehik/eolrkl=alhil.,]'ry3c012]cp5/239cpyhl.',-huilreoh/eho/ik0hceo/ikcrih.,0/igc34yyr2/34gy8[p90.8icgeurlxhkelocugxu0egoi/crleohil/p',hy/1c'gy029348y[.p,90gcileo;hl/GLRCDHIRCH)($*:(?YC{>)(i8e98cloraihl'hy34/l'cg809[i8u09/10ch32clr5hps'th,.tsnuihaeokc8gao[e09ig8caoelchuitnsoeabitnoeudh/lroeuceucog8xxgp,0ldynst43htnys5hhy543tsnh65crl234hyig8oeu90[euo8icgrheoistahoeaehosnuthoelrcigoeu[09icglerpuhdtnoseudh,ocilc0oeu7890[e8oi2349cg5hcl234h5l/r2c43/lyr.cpg,lrcioghersueusih";
        String string2 = Encryptor.encrypt((String)string, (char[])"herdecryptpassword3".toCharArray());
        Assert.assertNotNull((String)"The encrypted string should not be null.", (Object)string2);
        String string3 = Encryptor.decrypt((String)string2, (char[])"herdecryptpassword3".toCharArray());
        Assert.assertNotNull((String)"The decrypted string should not be null.", (Object)string3);
        Assert.assertFalse((String)"The decrypted string should not equal the encrypted string.", (boolean)string2.equals(string3));
        Assert.assertEquals((String)"The decrypted string should equal the original string.", (Object)string, (Object)string3);
        try {
            Encryptor.decrypt((String)string2, (char[])"herDecryptPassword3".toCharArray());
            Assert.fail((String)"Expected FailedToDecryptException, but no exception thrown.");
        }
        catch (FailedToDecryptException failedToDecryptException) {
            // empty catch block
        }
    }
}

