/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.encryption;

import java.io.File;
import java.io.IOException;
import net.nicholaswilliams.java.licensing.encryption.FilePublicKeyDataProvider;
import net.nicholaswilliams.java.licensing.exception.KeyNotFoundException;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestFilePublicKeyDataProvider {
    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testKeyFile01() throws IOException {
        File file = new File("testKeyFile01.key");
        if (file.exists()) {
            FileUtils.forceDelete((File)file);
        }
        FilePublicKeyDataProvider filePublicKeyDataProvider = new FilePublicKeyDataProvider("testKeyFile01.key");
        Assert.assertNotNull((String)"The key file should not be null.", (Object)filePublicKeyDataProvider.getPublicKeyFile());
        Assert.assertEquals((String)"The key file is not correct.", (Object)file.getAbsoluteFile(), (Object)filePublicKeyDataProvider.getPublicKeyFile());
        Assert.assertFalse((String)"The paths should not be the same.", (boolean)"testKeyFile01.key".equals(filePublicKeyDataProvider.getPublicKeyFile().getPath()));
        Assert.assertTrue((String)"The paths should end the same.", (boolean)filePublicKeyDataProvider.getPublicKeyFile().getPath().endsWith("testKeyFile01.key"));
    }

    @Test
    public void testKeyFile02() throws IOException {
        File file = new File("testKeyFile02.key");
        if (file.exists()) {
            FileUtils.forceDelete((File)file);
        }
        FilePublicKeyDataProvider filePublicKeyDataProvider = new FilePublicKeyDataProvider(file);
        Assert.assertNotNull((String)"The key file should not be null.", (Object)filePublicKeyDataProvider.getPublicKeyFile());
        Assert.assertNotSame((String)"The objects should not be the same.", (Object)file, (Object)filePublicKeyDataProvider.getPublicKeyFile());
        Assert.assertEquals((String)"The key file is not correct.", (Object)file.getAbsoluteFile(), (Object)filePublicKeyDataProvider.getPublicKeyFile());
        Assert.assertFalse((String)"The paths should not be the same.", (boolean)"testKeyFile02.key".equals(filePublicKeyDataProvider.getPublicKeyFile().getPath()));
        Assert.assertTrue((String)"The paths should end the same.", (boolean)filePublicKeyDataProvider.getPublicKeyFile().getPath().endsWith("testKeyFile02.key"));
    }

    @Test
    public void testGetEncryptedPublicKeyData01() throws IOException {
        File file = new File("testGetEncryptedPublicKeyData01.key");
        if (file.exists()) {
            FileUtils.forceDelete((File)file);
        }
        FilePublicKeyDataProvider filePublicKeyDataProvider = new FilePublicKeyDataProvider(file);
        try {
            filePublicKeyDataProvider.getEncryptedPublicKeyData();
            Assert.fail((String)"Expected exception KeyNotFoundException.");
        }
        catch (KeyNotFoundException keyNotFoundException) {
            Assert.assertNull((String)"The cause should be null.", (Object)keyNotFoundException.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="canRead()/canWrite() do not work on Win; setReadable()/setWritable() do not work on some Macs.")
    public void testGetEncryptedPublicKeyData02() throws IOException {
        File file = new File("testGetEncryptedPublicKeyData02.key");
        if ((file = file.getCanonicalFile()).exists()) {
            FileUtils.forceDelete((File)file);
        }
        byte[] byArray = new byte[]{1, 113, 51};
        FileUtils.writeByteArrayToFile((File)file, (byte[])byArray);
        try {
            Assert.assertTrue((String)"Setting the file to not-readable should have succeeded.", (boolean)file.setReadable(false, false));
            Assert.assertFalse((String)"The file should not be readable.", (boolean)file.canRead());
            Assert.assertTrue((String)"The file should still be writable.", (boolean)file.canWrite());
            FilePublicKeyDataProvider filePublicKeyDataProvider = new FilePublicKeyDataProvider(file);
            try {
                filePublicKeyDataProvider.getEncryptedPublicKeyData();
                Assert.fail((String)"Expected exception KeyNotFoundException.");
            }
            catch (KeyNotFoundException keyNotFoundException) {
                Assert.assertNotNull((String)"The cause should not be null.", (Object)keyNotFoundException.getCause());
            }
        }
        finally {
            FileUtils.forceDelete((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEncryptedPublicKeyData03() throws IOException {
        File file = new File("testGetEncryptedPublicKeyData03.key");
        if (file.exists()) {
            FileUtils.forceDelete((File)file);
        }
        byte[] byArray = new byte[]{1, 113, 51};
        FileUtils.writeByteArrayToFile((File)file, (byte[])byArray);
        try {
            FilePublicKeyDataProvider filePublicKeyDataProvider = new FilePublicKeyDataProvider(file);
            byte[] byArray2 = filePublicKeyDataProvider.getEncryptedPublicKeyData();
            Assert.assertNotNull((String)"The data should not be null.", (Object)byArray2);
            Assert.assertArrayEquals((String)"The data is not correct.", (byte[])byArray, (byte[])byArray2);
        }
        finally {
            FileUtils.forceDelete((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEncryptedPublicKeyData04() throws IOException {
        File file = new File("testGetEncryptedPublicKeyData04.key");
        if (file.exists()) {
            FileUtils.forceDelete((File)file);
        }
        byte[] byArray = new byte[]{81, 18, 35};
        FileUtils.writeByteArrayToFile((File)file, (byte[])byArray);
        try {
            FilePublicKeyDataProvider filePublicKeyDataProvider = new FilePublicKeyDataProvider(file);
            byte[] byArray2 = filePublicKeyDataProvider.getEncryptedPublicKeyData();
            Assert.assertNotNull((String)"The data should not be null.", (Object)byArray2);
            Assert.assertArrayEquals((String)"The data is not correct.", (byte[])byArray, (byte[])byArray2);
        }
        finally {
            FileUtils.forceDelete((File)file);
        }
    }
}

