/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.encryption;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.nicholaswilliams.java.licensing.encryption.Hasher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHasher {
    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testConstructionForbidden() throws IllegalAccessException, InstantiationException, NoSuchMethodException {
        Constructor constructor = Hasher.class.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        try {
            constructor.newInstance(new Object[0]);
            Assert.fail((String)"Expected exception java.lang.reflect.InvocationTargetException, but got no exception.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            Assert.assertNotNull((String)"Expected cause for InvocationTargetException, but got no cause.", (Object)throwable);
            Assert.assertSame((String)("Expected exception java.lang.RuntimeException, but got " + throwable.getClass()), RuntimeException.class, throwable.getClass());
            Assert.assertEquals((String)"The message was incorrect.", (Object)"This class cannot be instantiated.", (Object)throwable.getMessage());
        }
    }

    @Test
    public void testHashSameStrings() throws Exception {
        String string = "myteststring";
        String string2 = Hasher.hash((String)string);
        String string3 = Hasher.hash((String)string);
        String string4 = Hasher.hash((String)string);
        Assert.assertNotNull((String)"The first encrypted string was null.", (Object)string2);
        Assert.assertNotNull((String)"The second encrypted string was null.", (Object)string3);
        Assert.assertNotNull((String)"The third encrypted string was null.", (Object)string4);
        Assert.assertFalse((String)"The first encrypted string was not encrypted properly.", (boolean)string2.equals(string));
        Assert.assertFalse((String)"The second encrypted string was not encrypted properly.", (boolean)string3.equals(string));
        Assert.assertFalse((String)"The third encrypted string was not encrypted properly.", (boolean)string4.equals(string));
        Assert.assertEquals((String)"The first and second encrypted strings do not match.", (Object)string2, (Object)string3);
        Assert.assertEquals((String)"The first and third encrypted strings do not match.", (Object)string2, (Object)string4);
        Assert.assertEquals((String)"The second and third encrypted strings do not match.", (Object)string3, (Object)string4);
    }

    @Test
    public void testHashDifferentString() throws Exception {
        String string = "myteststring1";
        String string2 = "myteststring2";
        String string3 = Hasher.hash((String)string);
        String string4 = Hasher.hash((String)string2);
        Assert.assertNotNull((String)"The first encrypted string was null.", (Object)string3);
        Assert.assertNotNull((String)"The second encrypted string was null.", (Object)string4);
        Assert.assertFalse((String)"The first encrypted string matches the second encrypted string, and it shouldn't.", (boolean)string3.equals(string4));
    }
}

