/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.encryption;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.nicholaswilliams.java.licensing.encryption.KeyFileUtilities;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestKeyFileUtilities {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testConstructionForbidden() throws IllegalAccessException, InstantiationException, NoSuchMethodException {
        Constructor constructor = KeyFileUtilities.class.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        try {
            constructor.newInstance(new Object[0]);
            Assert.fail((String)"Expected exception java.lang.reflect.InvocationTargetException, but got no exception.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            Assert.assertNotNull((String)"Expected cause for InvocationTargetException, but got no cause.", (Object)throwable);
            Assert.assertSame((String)("Expected exception java.lang.RuntimeException, but got " + throwable.getClass()), RuntimeException.class, throwable.getClass());
            Assert.assertEquals((String)"The message was incorrect.", (Object)"This class cannot be instantiated.", (Object)throwable.getMessage());
        }
    }

    @Test
    public void testPrivateKeyEncryption01() throws Throwable {
        File file = new File("testPrivateKeyEncryption01.key");
        if (file.exists()) {
            FileUtils.forceDelete((File)file);
        }
        PrivateKey privateKey = KeyPairGenerator.getInstance("RSA").generateKeyPair().getPrivate();
        KeyFileUtilities.writeEncryptedPrivateKey((PrivateKey)privateKey, (File)file, (char[])"myTestPassword01".toCharArray());
        PrivateKey privateKey2 = KeyFileUtilities.readEncryptedPrivateKey((File)file, (char[])"myTestPassword01".toCharArray());
        Assert.assertNotNull((String)"The key should not be null.", (Object)privateKey2);
        Assert.assertFalse((String)"The objects should not be the same.", (privateKey == privateKey2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The keys should be the same.", (Object)privateKey, (Object)privateKey2);
        FileUtils.forceDelete((File)file);
    }

    @Test
    public void testPrivateKeyEncryption02() throws Throwable {
        File file = new File("testPrivateKeyEncryption02.key");
        if (file.exists()) {
            FileUtils.forceDelete((File)file);
        }
        PrivateKey privateKey = KeyPairGenerator.getInstance("RSA").generateKeyPair().getPrivate();
        PrivateKey privateKey2 = KeyPairGenerator.getInstance("RSA").generateKeyPair().getPrivate();
        Assert.assertFalse((String)"The keys should not be equal (1).", (boolean)privateKey2.equals(privateKey));
        KeyFileUtilities.writeEncryptedPrivateKey((PrivateKey)privateKey, (File)file, (char[])"yourTestPassword02".toCharArray());
        PrivateKey privateKey3 = KeyFileUtilities.readEncryptedPrivateKey((File)file, (char[])"yourTestPassword02".toCharArray());
        Assert.assertNotNull((String)"The key should not be null.", (Object)privateKey3);
        Assert.assertFalse((String)"The objects should not be the same.", (privateKey == privateKey3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The keys should be the same.", (Object)privateKey, (Object)privateKey3);
        Assert.assertFalse((String)"The keys should not be equal (2).", (boolean)privateKey2.equals(privateKey3));
        FileUtils.forceDelete((File)file);
    }

    @Test
    public void testPrivateKeyEncryption03() throws Throwable {
        PrivateKey privateKey = KeyPairGenerator.getInstance("RSA").generateKeyPair().getPrivate();
        byte[] byArray = KeyFileUtilities.writeEncryptedPrivateKey((PrivateKey)privateKey, (char[])"myTestPassword01".toCharArray());
        Assert.assertNotNull((String)"The key data should not be null.", (Object)byArray);
        Assert.assertTrue((String)"The key data should have length.", (byArray.length > 0 ? 1 : 0) != 0);
        PrivateKey privateKey2 = KeyFileUtilities.readEncryptedPrivateKey((byte[])byArray, (char[])"myTestPassword01".toCharArray());
        Assert.assertNotNull((String)"The key should not be null.", (Object)privateKey2);
        Assert.assertFalse((String)"The objects should not be the same.", (privateKey == privateKey2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The keys should be the same.", (Object)privateKey, (Object)privateKey2);
    }

    @Test
    public void testPrivateKeyEncryption04() throws Throwable {
        PrivateKey privateKey = KeyPairGenerator.getInstance("RSA").generateKeyPair().getPrivate();
        PrivateKey privateKey2 = KeyPairGenerator.getInstance("RSA").generateKeyPair().getPrivate();
        Assert.assertFalse((String)"The keys should not be equal (1).", (boolean)privateKey2.equals(privateKey));
        byte[] byArray = KeyFileUtilities.writeEncryptedPrivateKey((PrivateKey)privateKey, (char[])"yourTestPassword02".toCharArray());
        Assert.assertNotNull((String)"The key data should not be null.", (Object)byArray);
        Assert.assertTrue((String)"The key data should have length.", (byArray.length > 0 ? 1 : 0) != 0);
        PrivateKey privateKey3 = KeyFileUtilities.readEncryptedPrivateKey((byte[])byArray, (char[])"yourTestPassword02".toCharArray());
        Assert.assertNotNull((String)"The key should not be null.", (Object)privateKey3);
        Assert.assertFalse((String)"The objects should not be the same.", (privateKey == privateKey3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The keys should be the same.", (Object)privateKey, (Object)privateKey3);
        Assert.assertFalse((String)"The keys should not be equal (2).", (boolean)privateKey2.equals(privateKey3));
    }

    @Test
    public void testPublicKeyEncryption01() throws Throwable {
        File file = new File("testPublicKeyEncryption01.key");
        if (file.exists()) {
            FileUtils.forceDelete((File)file);
        }
        PublicKey publicKey = KeyPairGenerator.getInstance("RSA").generateKeyPair().getPublic();
        KeyFileUtilities.writeEncryptedPublicKey((PublicKey)publicKey, (File)file, (char[])"myTestPassword01".toCharArray());
        PublicKey publicKey2 = KeyFileUtilities.readEncryptedPublicKey((File)file, (char[])"myTestPassword01".toCharArray());
        Assert.assertNotNull((String)"The key should not be null.", (Object)publicKey2);
        Assert.assertFalse((String)"The objects should not be the same.", (publicKey == publicKey2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The keys should be the same.", (Object)publicKey, (Object)publicKey2);
        FileUtils.forceDelete((File)file);
    }

    @Test
    public void testPublicKeyEncryption02() throws Throwable {
        File file = new File("testPublicKeyEncryption02.key");
        if (file.exists()) {
            FileUtils.forceDelete((File)file);
        }
        PublicKey publicKey = KeyPairGenerator.getInstance("RSA").generateKeyPair().getPublic();
        PublicKey publicKey2 = KeyPairGenerator.getInstance("RSA").generateKeyPair().getPublic();
        Assert.assertFalse((String)"The keys should not be equal (1).", (boolean)publicKey2.equals(publicKey));
        KeyFileUtilities.writeEncryptedPublicKey((PublicKey)publicKey, (File)file, (char[])"yourTestPassword02".toCharArray());
        PublicKey publicKey3 = KeyFileUtilities.readEncryptedPublicKey((File)file, (char[])"yourTestPassword02".toCharArray());
        Assert.assertNotNull((String)"The key should not be null.", (Object)publicKey3);
        Assert.assertFalse((String)"The objects should not be the same.", (publicKey == publicKey3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The keys should be the same.", (Object)publicKey, (Object)publicKey3);
        Assert.assertFalse((String)"The keys should not be equal (2).", (boolean)publicKey2.equals(publicKey3));
        FileUtils.forceDelete((File)file);
    }

    @Test
    public void testPublicKeyEncryption03() throws Throwable {
        PublicKey publicKey = KeyPairGenerator.getInstance("RSA").generateKeyPair().getPublic();
        byte[] byArray = KeyFileUtilities.writeEncryptedPublicKey((PublicKey)publicKey, (char[])"myTestPassword01".toCharArray());
        Assert.assertNotNull((String)"The key data should not be null.", (Object)byArray);
        Assert.assertTrue((String)"The key data should have length.", (byArray.length > 0 ? 1 : 0) != 0);
        PublicKey publicKey2 = KeyFileUtilities.readEncryptedPublicKey((byte[])byArray, (char[])"myTestPassword01".toCharArray());
        Assert.assertNotNull((String)"The key should not be null.", (Object)publicKey2);
        Assert.assertFalse((String)"The objects should not be the same.", (publicKey == publicKey2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The keys should be the same.", (Object)publicKey, (Object)publicKey2);
    }

    @Test
    public void testPublicKeyEncryption04() throws Throwable {
        PublicKey publicKey = KeyPairGenerator.getInstance("RSA").generateKeyPair().getPublic();
        PublicKey publicKey2 = KeyPairGenerator.getInstance("RSA").generateKeyPair().getPublic();
        Assert.assertFalse((String)"The keys should not be equal (1).", (boolean)publicKey2.equals(publicKey));
        byte[] byArray = KeyFileUtilities.writeEncryptedPublicKey((PublicKey)publicKey, (char[])"yourTestPassword02".toCharArray());
        Assert.assertNotNull((String)"The key data should not be null.", (Object)byArray);
        Assert.assertTrue((String)"The key data should have length.", (byArray.length > 0 ? 1 : 0) != 0);
        PublicKey publicKey3 = KeyFileUtilities.readEncryptedPublicKey((byte[])byArray, (char[])"yourTestPassword02".toCharArray());
        Assert.assertNotNull((String)"The key should not be null.", (Object)publicKey3);
        Assert.assertFalse((String)"The objects should not be the same.", (publicKey == publicKey3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The keys should be the same.", (Object)publicKey, (Object)publicKey3);
        Assert.assertFalse((String)"The keys should not be equal (2).", (boolean)publicKey2.equals(publicKey3));
    }
}

