/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.immutable;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import net.nicholaswilliams.java.licensing.immutable.ImmutableAbstractCollection;
import net.nicholaswilliams.java.licensing.immutable.ImmutableArrayList;
import net.nicholaswilliams.java.licensing.immutable.ImmutableListIterator;
import net.nicholaswilliams.java.licensing.immutable.ImmutableModifiedThroughReflectionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestImmutableArrayList {
    private ImmutableArrayList<String> list;

    @Before
    public void setUp() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("MyString1");
        arrayList.add("YourString2");
        arrayList.add("HisString3");
        arrayList.add("HerString4");
        this.list = new ImmutableArrayList(arrayList);
    }

    @After
    public void tearDown() {
    }

    public ArrayList<String> getInternal() {
        try {
            Field field = this.list.getClass().getDeclaredField("internalList");
            field.setAccessible(true);
            return (ArrayList)field.get(this.list);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Test
    public void testConstruct01() throws Exception {
        ArrayList<String> arrayList = this.getInternal();
        Assert.assertNotNull((String)"The internal collection should not be null.", (Object)this.list.internalCollection);
        Assert.assertNotNull((String)"The internal array list should not be null.", arrayList);
        Assert.assertSame((String)"The objects should be the same.", (Object)this.list.internalCollection, arrayList);
        Field field = ImmutableAbstractCollection.class.getDeclaredField("internalHashCode");
        field.setAccessible(true);
        int n = field.getInt(this.list);
        Assert.assertEquals((String)"The hash code is not correct.", (long)arrayList.hashCode(), (long)n);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddNotAllowed() {
        this.list.add(2, (Object)"Test");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddAllNotAllowed() {
        this.list.addAll(2, Arrays.asList("Test1", "Test2", "Test3"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveNotAllowed() {
        this.list.remove((Object)"MyString1");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveByIntNotAllowed() {
        this.list.remove(1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveAllNotAllowed() {
        this.list.removeAll(Arrays.asList("MyString1", "HerString4"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetNotAllowed() {
        this.list.set(1, (Object)"MyString1");
    }

    @Test
    public void testClone01() {
        ImmutableArrayList immutableArrayList = this.list.clone();
        Assert.assertFalse((String)"The lists should not be the same objects.", (immutableArrayList == this.list ? 1 : 0) != 0);
        Assert.assertEquals((String)"The lists should be equal.", this.list, (Object)immutableArrayList);
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testClone02() {
        this.getInternal().remove(2);
        this.list.clone();
    }

    @Test
    public void testGet01() {
        Assert.assertEquals((String)"The value is not correct.", (Object)"YourString2", (Object)this.list.get(1));
    }

    @Test
    public void testGet02() {
        Assert.assertEquals((String)"The value is not correct.", (Object)"HerString4", (Object)this.list.get(3));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGet03() {
        this.list.get(4);
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testGet04() {
        this.getInternal().add(null);
        this.list.get(1);
    }

    @Test
    public void testIndexOf01() {
        Assert.assertEquals((String)"The index is not correct.", (long)0L, (long)this.list.indexOf((Object)"MyString1"));
    }

    @Test
    public void testIndexOf02() {
        Assert.assertEquals((String)"The index is not correct.", (long)2L, (long)this.list.indexOf((Object)"HisString3"));
    }

    @Test
    public void testIndexOf03() {
        Assert.assertEquals((String)"The index is not correct.", (long)-1L, (long)this.list.indexOf((Object)"HisString4"));
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testIndexOf04() {
        this.getInternal().add("Test");
        this.list.indexOf((Object)"Hello");
    }

    @Test
    public void testLastIndexOf01() {
        Assert.assertEquals((String)"The index is not correct.", (long)1L, (long)this.list.lastIndexOf((Object)"YourString2"));
    }

    @Test
    public void testLastIndexOf02() {
        Assert.assertEquals((String)"The index is not correct.", (long)3L, (long)this.list.lastIndexOf((Object)"HerString4"));
    }

    @Test
    public void testLastIndexOf03() {
        Assert.assertEquals((String)"The index is not correct.", (long)-1L, (long)this.list.lastIndexOf((Object)"HisString4"));
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testLastIndexOf04() {
        this.getInternal().remove("HerString4");
        this.list.lastIndexOf((Object)"Hello");
    }

    @Test
    public void testListIterator101() {
        int n = 0;
        String[] stringArray = new String[]{"MyString1", "YourString2", "HisString3", "HerString4"};
        ImmutableListIterator immutableListIterator = this.list.listIterator();
        while (immutableListIterator.hasNext()) {
            int n2 = immutableListIterator.nextIndex();
            Assert.assertEquals((String)("The index is not correct " + n), (long)n, (long)n2);
            String string = (String)immutableListIterator.next();
            Assert.assertEquals((String)("The strings should match " + n), (Object)this.list.get(n2), (Object)string);
            Assert.assertTrue((String)("The iterator has gone too far " + n), (n < 4 ? 1 : 0) != 0);
            Assert.assertNotNull((String)("None of the strings should be null " + n), (Object)string);
            Assert.assertEquals((String)("The string is not correct " + n), (Object)stringArray[n++], (Object)string);
        }
    }

    @Test
    public void testListIterator102() {
        int n = 0;
        String[] stringArray = new String[]{"MyString1", "YourString2", "HisString3", "HerString4"};
        for (String string : this.list) {
            Assert.assertTrue((String)("The iterator has gone too far " + n), (n < 4 ? 1 : 0) != 0);
            Assert.assertNotNull((String)("None of the strings should be null " + n), (Object)string);
            Assert.assertEquals((String)("The string is not correct " + n), (Object)stringArray[n++], (Object)string);
        }
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testListIterator103() {
        this.getInternal().remove("MyString1");
        this.list.listIterator();
    }

    @Test
    public void testListIterator201() {
        int n = 3;
        String[] stringArray = new String[]{"MyString1", "YourString2", "HisString3", "HerString4"};
        ImmutableListIterator immutableListIterator = this.list.listIterator(4);
        while (immutableListIterator.hasPrevious()) {
            int n2 = immutableListIterator.previousIndex();
            Assert.assertEquals((String)("The index is not correct " + n), (long)n, (long)n2);
            String string = (String)immutableListIterator.previous();
            Assert.assertEquals((String)("The strings should match " + n), (Object)this.list.get(n2), (Object)string);
            Assert.assertTrue((String)("The iterator has gone too far " + n), (n < 4 ? 1 : 0) != 0);
            Assert.assertNotNull((String)("None of the strings should be null " + n), (Object)string);
            Assert.assertEquals((String)("The string is not correct " + n), (Object)stringArray[n--], (Object)string);
        }
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testListIterator202() {
        this.getInternal().remove("MyString1");
        this.list.listIterator(2);
    }

    @Test
    public void testSubList01() {
        ImmutableArrayList immutableArrayList = this.list.subList(1, 3);
        Assert.assertFalse((String)"The objects should be different.", (immutableArrayList == this.list ? 1 : 0) != 0);
        Assert.assertEquals((String)"The list is the wrong side.", (long)2L, (long)immutableArrayList.size());
        Assert.assertEquals((String)"String 1 is not correct.", (Object)"YourString2", (Object)immutableArrayList.get(0));
        Assert.assertEquals((String)"String 2 is not correct.", (Object)"HisString3", (Object)immutableArrayList.get(1));
    }

    @Test
    public void testSubList02() {
        ImmutableArrayList immutableArrayList = this.list.subList(2, 4);
        Assert.assertFalse((String)"The objects should be different.", (immutableArrayList == this.list ? 1 : 0) != 0);
        Assert.assertEquals((String)"The list is the wrong side.", (long)2L, (long)immutableArrayList.size());
        Assert.assertEquals((String)"String 1 is not correct.", (Object)"HisString3", (Object)immutableArrayList.get(0));
        Assert.assertEquals((String)"String 2 is not correct.", (Object)"HerString4", (Object)immutableArrayList.get(1));
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testSubList03() {
        this.getInternal().add("Test");
        this.list.subList(2, 4);
    }
}

