/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.immutable;

import java.util.TreeSet;
import net.nicholaswilliams.java.licensing.immutable.ImmutableIterator;
import net.nicholaswilliams.java.licensing.immutable.ImmutableModifiedThroughReflectionException;
import net.nicholaswilliams.java.licensing.immutable.MockValidObject;
import net.nicholaswilliams.java.licensing.immutable.ValidObject;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestImmutableIterator {
    private ImmutableIterator<String> iterator;
    private MockValidObject valid;

    public TestImmutableIterator() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("MyString1");
        treeSet.add("YourString2");
        treeSet.add("HisString3");
        treeSet.add("HerString4");
        this.valid = new MockValidObject();
        this.iterator = new ImmutableIterator(treeSet.iterator(), (ValidObject)this.valid);
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveNotAllowed() {
        this.iterator.remove();
    }

    @Test
    public void testNext01() {
        this.valid.valid = true;
        String[] stringArray = new String[]{"HerString4", "HisString3", "MyString1", "YourString2"};
        int n = 0;
        while (this.iterator.hasNext()) {
            String string = (String)this.iterator.next();
            Assert.assertNotNull((String)("This string should not be null " + n), (Object)string);
            Assert.assertEquals((String)("This string is not correct " + n), (Object)stringArray[n++], (Object)string);
        }
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testNext02() {
        this.valid.valid = false;
        this.iterator.hasNext();
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testNext03() {
        this.valid.valid = false;
        this.iterator.next();
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testNext04() {
        try {
            this.valid.valid = true;
            this.iterator.hasNext();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assert.fail((String)throwable.toString());
        }
        this.valid.valid = false;
        this.iterator.next();
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testNext05() {
        try {
            this.valid.valid = true;
            this.iterator.hasNext();
            this.iterator.next();
            this.iterator.hasNext();
            this.iterator.next();
            this.iterator.hasNext();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assert.fail((String)throwable.toString());
        }
        this.valid.valid = false;
        this.iterator.next();
    }
}

