/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.immutable;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.LinkedHashSet;
import net.nicholaswilliams.java.licensing.immutable.ImmutableAbstractCollection;
import net.nicholaswilliams.java.licensing.immutable.ImmutableLinkedHashSet;
import net.nicholaswilliams.java.licensing.immutable.ImmutableModifiedThroughReflectionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestImmutableLinkedHashSet {
    private ImmutableLinkedHashSet<String> set;

    public TestImmutableLinkedHashSet() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add("MyString1");
        linkedHashSet.add("YourString2");
        linkedHashSet.add("HisString3");
        linkedHashSet.add("HerString4");
        this.set = new ImmutableLinkedHashSet(linkedHashSet);
    }

    public HashSet<String> getInternal() {
        try {
            Field field = this.set.getClass().getDeclaredField("internalSet");
            field.setAccessible(true);
            return (HashSet)field.get(this.set);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetByIndex01() {
        Assert.assertEquals((String)"The value is not correct.", (Object)"YourString2", (Object)this.set.get(1));
    }

    @Test
    public void testGetByIndex02() {
        Assert.assertEquals((String)"The value is not correct.", (Object)"HerString4", (Object)this.set.get(3));
    }

    @Test
    public void testGetByValue01() {
        Assert.assertEquals((String)"The value is not correct.", (Object)"MyString1", (Object)this.set.get((Object)"MyString1"));
    }

    @Test
    public void testGetByValue02() {
        Assert.assertEquals((String)"The value is not correct.", (Object)"HisString3", (Object)this.set.get((Object)"HisString3"));
    }

    @Test
    public void testConstruct() throws Exception {
        HashSet<String> hashSet = this.getInternal();
        Assert.assertNotNull((String)"The internal collection should not be null.", (Object)this.set.internalCollection);
        Assert.assertNotNull((String)"The internal hash set should not be null.", hashSet);
        Assert.assertSame((String)"The objects should be the same.", (Object)this.set.internalCollection, hashSet);
        Field field = ImmutableAbstractCollection.class.getDeclaredField("internalHashCode");
        field.setAccessible(true);
        int n = field.getInt(this.set);
        Assert.assertEquals((String)"The hash code is not correct.", (long)hashSet.hashCode(), (long)n);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddNotAllowed() {
        this.set.add((Object)"AnyString");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddAllNotAllowed() {
        this.set.addAll(new HashSet());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testClearNotAllowed() {
        this.set.clear();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveNotAllowed() {
        this.set.remove((Object)"AnyString");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveAllNotAllowed() {
        this.set.removeAll(new HashSet());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRetainAllNotAllowed() {
        this.set.retainAll(new HashSet());
    }

    @Test
    public void testHashCode01() throws Exception {
        Field field = ImmutableAbstractCollection.class.getDeclaredField("internalHashCode");
        field.setAccessible(true);
        int n = field.getInt(this.set);
        Assert.assertEquals((String)"The hash code is not correct.", (long)n, (long)this.set.hashCode());
    }

    @Test
    public void testHashCode02() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("MyString1");
        hashSet.add("YourString2");
        hashSet.add("HisString3");
        hashSet.add("HerString4");
        ImmutableLinkedHashSet immutableLinkedHashSet = new ImmutableLinkedHashSet(hashSet);
        Assert.assertEquals((String)"The hash codes should be equal.", (long)immutableLinkedHashSet.hashCode(), (long)this.set.hashCode());
    }

    @Test
    public void testHashCode03() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("MyString1");
        hashSet.add("YourString2");
        hashSet.add("HisString3");
        hashSet.add("HerString5");
        ImmutableLinkedHashSet immutableLinkedHashSet = new ImmutableLinkedHashSet(hashSet);
        Assert.assertFalse((String)"The hash codes should not be equal.", (immutableLinkedHashSet.hashCode() == this.set.hashCode() ? 1 : 0) != 0);
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testHashCode04() {
        this.getInternal().add("Test");
        this.set.hashCode();
    }

    @Test
    public void testEquals01() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("MyString1");
        hashSet.add("YourString2");
        hashSet.add("HisString3");
        hashSet.add("HerString4");
        ImmutableLinkedHashSet immutableLinkedHashSet = new ImmutableLinkedHashSet(hashSet);
        Assert.assertEquals((String)"The sets should be equal.", (Object)immutableLinkedHashSet, this.set);
    }

    @Test
    public void testEquals02() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("MyString1");
        hashSet.add("YourString2");
        hashSet.add("HisString3");
        hashSet.add("HerString5");
        ImmutableLinkedHashSet immutableLinkedHashSet = new ImmutableLinkedHashSet(hashSet);
        Assert.assertFalse((String)"The sets should not be equal.", (boolean)immutableLinkedHashSet.equals(this.set));
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testEquals03() {
        this.getInternal().add("Test");
        this.set.equals(this.set);
    }

    @Test
    public void testClone01() {
        ImmutableLinkedHashSet immutableLinkedHashSet = this.set.clone();
        Assert.assertFalse((String)"The sets should not be the same objects.", (immutableLinkedHashSet == this.set ? 1 : 0) != 0);
        Assert.assertEquals((String)"The sets should be equal.", this.set, (Object)immutableLinkedHashSet);
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testClone02() {
        this.getInternal().add(null);
        this.set.clone();
    }

    @Test
    public void testContains01() {
        Assert.assertTrue((String)"The set should contain this string.", (boolean)this.set.contains((Object)"MyString1"));
    }

    @Test
    public void testContains02() {
        Assert.assertFalse((String)"The set should not contain this string.", (boolean)this.set.contains((Object)"YourString1"));
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testContains03() {
        this.getInternal().add("Test");
        this.set.contains((Object)"Test");
    }

    @Test
    public void testContainsAll01() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("MyString1");
        hashSet.add("YourString2");
        Assert.assertTrue((String)"The set should contain all of these strings.", (boolean)this.set.containsAll(hashSet));
    }

    @Test
    public void testContainsAll02() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("MyString1");
        hashSet.add("YourString3");
        Assert.assertFalse((String)"The set should not contain all of these strings.", (boolean)this.set.containsAll(hashSet));
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testContainsAll03() {
        this.getInternal().add(null);
        this.set.containsAll(this.set);
    }

    @Test
    public void testIsEmpty01() {
        Assert.assertFalse((String)"This set should not be empty.", (boolean)this.set.isEmpty());
    }

    @Test
    public void testIsEmpty02() {
        Assert.assertTrue((String)"The set should not be empty.", (boolean)new ImmutableLinkedHashSet(new HashSet()).isEmpty());
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testIsEmpty03() {
        this.getInternal().clear();
        this.set.isEmpty();
    }

    @Test
    public void testIterator01() {
        int n = 0;
        for (String string : this.set) {
            Assert.assertNotNull((String)"None of the strings should be null.", (Object)string);
            Assert.assertTrue((String)("Expected MyString1 or YourString2 or HisString3 or HerString4 but got " + string + "."), (string.equals("MyString1") || string.equals("YourString2") || string.equals("HisString3") || string.equals("HerString4") ? 1 : 0) != 0);
            ++n;
        }
        Assert.assertEquals((String)"The iterator should have iterated four times.", (long)4L, (long)n);
    }

    @Test
    public void testIterator02() {
        int n = 0;
        for (String string : this.set) {
            Assert.assertNotNull((String)"None of the strings should be null.", (Object)string);
            Assert.assertTrue((String)("Expected MyString1 or YourString2 or HisString3 or HerString4 but got " + string + "."), (string.equals("MyString1") || string.equals("YourString2") || string.equals("HisString3") || string.equals("HerString4") ? 1 : 0) != 0);
            ++n;
        }
        Assert.assertEquals((String)"The iterator should have iterated four times.", (long)4L, (long)n);
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testIterator03() {
        this.getInternal().remove("MyString1");
        this.set.iterator();
    }

    @Test
    public void testSize01() {
        Assert.assertEquals((String)"The size is not correct.", (long)4L, (long)this.set.size());
    }

    @Test
    public void testSize02() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("MyString1");
        hashSet.add("YourString2");
        Assert.assertEquals((String)"The size is not correct.", (long)2L, (long)new ImmutableLinkedHashSet(hashSet).size());
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testSize03() {
        this.getInternal().add(null);
        this.set.size();
    }

    @Test
    public void testToObjectArray01() {
        Object[] objectArray = this.set.toArray();
        Assert.assertNotNull((String)"The array should not be null.", (Object)objectArray);
        Assert.assertEquals((String)"The array length is not correct.", (long)4L, (long)objectArray.length);
    }

    @Test
    public void testToObjectArray02() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("MyString1");
        hashSet.add("HisString3");
        Object[] objectArray = new ImmutableLinkedHashSet(hashSet).toArray();
        Assert.assertNotNull((String)"The array should not be null.", (Object)objectArray);
        Assert.assertEquals((String)"The array length is not correct.", (long)2L, (long)objectArray.length);
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testToObjectArray03() {
        this.getInternal().add("Test");
        this.set.toArray();
    }

    @Test
    public void testToPrototypedArray01() {
        String[] stringArray = (String[])this.set.toArray((Object[])new String[0]);
        Assert.assertNotNull((String)"The array should not be null.", (Object)stringArray);
        Assert.assertEquals((String)"The array length is not correct.", (long)4L, (long)stringArray.length);
    }

    @Test
    public void testToPrototypedArray02() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("MyString1");
        hashSet.add("HisString3");
        String[] stringArray = (String[])new ImmutableLinkedHashSet(hashSet).toArray((Object[])new String[0]);
        Assert.assertNotNull((String)"The array should not be null.", (Object)stringArray);
        Assert.assertEquals((String)"The array length is not correct.", (long)2L, (long)stringArray.length);
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testToPrototypedArray03() {
        this.getInternal().add(null);
        this.set.toArray((Object[])new String[0]);
    }
}

