/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.immutable;

import java.util.ArrayList;
import net.nicholaswilliams.java.licensing.immutable.ImmutableListIterator;
import net.nicholaswilliams.java.licensing.immutable.ImmutableModifiedThroughReflectionException;
import net.nicholaswilliams.java.licensing.immutable.MockValidObject;
import net.nicholaswilliams.java.licensing.immutable.ValidObject;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestImmutableListIterator {
    private ImmutableListIterator<String> iterator;
    private MockValidObject valid;

    public TestImmutableListIterator() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("MyString1");
        arrayList.add("YourString2");
        arrayList.add("HisString3");
        arrayList.add("HerString4");
        this.valid = new MockValidObject();
        this.iterator = new ImmutableListIterator(arrayList.listIterator(), (ValidObject)this.valid);
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddNotAllowed() {
        this.iterator.add((Object)"Test");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveNotAllowed() {
        this.iterator.remove();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetNotAllowed() {
        this.iterator.set((Object)"Test");
    }

    @Test
    public void testNext01() {
        this.valid.valid = true;
        String[] stringArray = new String[]{"MyString1", "YourString2", "HisString3", "HerString4"};
        int n = 0;
        while (this.iterator.hasNext()) {
            Assert.assertEquals((String)"The index is not correct.", (long)n, (long)this.iterator.nextIndex());
            String string = (String)this.iterator.next();
            Assert.assertNotNull((String)("This string should not be null " + n), (Object)string);
            Assert.assertEquals((String)("This string is not correct " + n), (Object)stringArray[n++], (Object)string);
        }
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testNext02() {
        this.valid.valid = false;
        this.iterator.hasNext();
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testNext03() {
        this.valid.valid = false;
        this.iterator.hasNext();
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testNext04() {
        try {
            this.valid.valid = true;
            this.iterator.hasNext();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assert.fail((String)throwable.toString());
        }
        this.valid.valid = false;
        this.iterator.next();
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testNext05() {
        try {
            this.valid.valid = true;
            this.iterator.hasNext();
            this.iterator.next();
            this.iterator.hasNext();
            this.iterator.next();
            this.iterator.hasNext();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assert.fail((String)throwable.toString());
        }
        this.valid.valid = false;
        this.iterator.next();
    }

    @Test
    public void testPrevious01() {
        this.valid.valid = true;
        String[] stringArray = new String[]{"MyString1", "YourString2", "HisString3", "HerString4"};
        int n = 4;
        while (this.iterator.hasPrevious()) {
            Assert.assertEquals((String)"The index is not correct.", (long)n, (long)this.iterator.previousIndex());
            String string = (String)this.iterator.previous();
            Assert.assertNotNull((String)("This string should not be null " + n), (Object)string);
            Assert.assertEquals((String)("This string is not correct " + n), (Object)stringArray[n--], (Object)string);
        }
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testPrevious02() {
        this.valid.valid = false;
        this.iterator.hasPrevious();
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testPrevious03() {
        this.valid.valid = false;
        this.iterator.previous();
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testPrevious04() {
        try {
            this.valid.valid = true;
            this.iterator.hasPrevious();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assert.fail((String)throwable.toString());
        }
        this.valid.valid = false;
        this.iterator.previous();
    }

    @Test(expected=ImmutableModifiedThroughReflectionException.class)
    public void testPrevious05() {
        try {
            this.valid.valid = true;
            this.iterator.next();
            this.iterator.next();
            this.iterator.next();
            this.iterator.next();
            this.iterator.hasPrevious();
            this.iterator.previous();
            this.iterator.hasPrevious();
            this.iterator.previous();
            this.iterator.hasPrevious();
            this.iterator.previous();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assert.fail((String)throwable.toString());
        }
        this.valid.valid = false;
        this.iterator.previous();
    }
}

