/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import net.nicholaswilliams.java.licensing.DeserializingLicenseProvider;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;

public class FileLicenseProvider
extends DeserializingLicenseProvider {
    protected ClassLoader classLoader;
    private String filePrefix = "";
    private String fileSuffix = "";
    private boolean fileOnClasspath = false;
    private boolean base64Encoded = false;

    public FileLicenseProvider() {
        this.classLoader = this.getClass().getClassLoader();
        this.fileOnClasspath = false;
    }

    public FileLicenseProvider(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Argument classLoader cannot be null.");
        }
        this.classLoader = classLoader;
        this.fileOnClasspath = true;
    }

    @Override
    protected byte[] getLicenseData(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument context cannot be null.");
        }
        File file = this.getLicenseFile(object);
        if (file == null || !file.exists() || !file.canRead()) {
            return null;
        }
        try {
            byte[] byArray = FileUtils.readFileToByteArray((File)file);
            if (this.isBase64Encoded()) {
                byArray = Base64.decodeBase64((byte[])byArray);
            }
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected File getLicenseFile(Object object) {
        String string = this.getFilePrefix() + object.toString() + this.getFileSuffix();
        if (this.isFileOnClasspath()) {
            URL uRL;
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if ((uRL = this.classLoader.getResource(string)) == null) {
                string = null;
            } else {
                try {
                    return new File(uRL.toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                    return new File(uRL.getPath());
                }
            }
        }
        return string == null ? null : new File(string);
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument filePrefix cannot be null.");
        }
        this.filePrefix = string;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument fileSuffix cannot be null.");
        }
        this.fileSuffix = string;
    }

    public boolean isFileOnClasspath() {
        return this.fileOnClasspath;
    }

    public void setFileOnClasspath(boolean bl) {
        this.fileOnClasspath = bl;
    }

    public boolean isBase64Encoded() {
        return this.base64Encoded;
    }

    public void setBase64Encoded(boolean bl) {
        this.base64Encoded = bl;
    }
}

