/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import net.nicholaswilliams.java.licensing.FeatureObject;
import net.nicholaswilliams.java.licensing.LicensingCharsets;
import net.nicholaswilliams.java.licensing.immutable.ImmutableLinkedHashSet;

public final class License
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5844818190125277296L;
    private final String productKey;
    private final String holder;
    private final String issuer;
    private final String subject;
    private final long issueDate;
    private final long goodAfterDate;
    private final long goodBeforeDate;
    private final int numberOfLicenses;
    private final ImmutableLinkedHashSet<Feature> features;

    private License(Builder builder) {
        this.productKey = builder.productKey == null ? "" : builder.productKey;
        this.holder = builder.holder == null ? "" : builder.holder;
        this.issuer = builder.issuer == null ? "" : builder.issuer;
        this.subject = builder.subject == null ? "" : builder.subject;
        this.issueDate = builder.issueDate;
        this.goodAfterDate = builder.goodAfterDate;
        this.goodBeforeDate = builder.goodBeforeDate;
        this.numberOfLicenses = builder.numberOfLicenses;
        this.features = new ImmutableLinkedHashSet(builder.features);
    }

    private License(String[] stringArray) {
        if (stringArray == null || stringArray.length != 9) {
            throw new IllegalArgumentException("There should be exactly nine parts to the serialized license.");
        }
        this.productKey = stringArray[0] == null ? "" : stringArray[0];
        this.holder = stringArray[1] == null ? "" : stringArray[1];
        this.issuer = stringArray[2] == null ? "" : stringArray[2];
        this.subject = stringArray[3] == null ? "" : stringArray[3];
        this.issueDate = Long.parseLong(stringArray[4]);
        this.goodAfterDate = Long.parseLong(stringArray[5]);
        this.goodBeforeDate = Long.parseLong(stringArray[6]);
        this.numberOfLicenses = Integer.parseInt(stringArray[7]);
        LinkedHashSet<Feature> linkedHashSet = new LinkedHashSet<Feature>();
        if (stringArray[8] != null && stringArray[8].trim().length() > 0) {
            for (String string : stringArray[8].split("\\, ")) {
                linkedHashSet.add(Feature.fromString(string));
            }
        }
        this.features = new ImmutableLinkedHashSet(linkedHashSet);
    }

    public byte[] serialize() {
        return this.toString().getBytes(LicensingCharsets.UTF_8);
    }

    protected static License deserialize(byte[] byArray) {
        String string = new String(byArray, LicensingCharsets.UTF_8);
        String[] stringArray = string.substring(1, string.length() - 1).split("\\]\\[", -1);
        return new License(stringArray);
    }

    public final String getProductKey() {
        return this.productKey;
    }

    public final String getIssuer() {
        return this.issuer;
    }

    public final String getHolder() {
        return this.holder;
    }

    public final String getSubject() {
        return this.subject;
    }

    public final long getIssueDate() {
        return this.issueDate;
    }

    public final long getGoodAfterDate() {
        return this.goodAfterDate;
    }

    public final long getGoodBeforeDate() {
        return this.goodBeforeDate;
    }

    public final int getNumberOfLicenses() {
        return this.numberOfLicenses;
    }

    public final ImmutableLinkedHashSet<Feature> getFeatures() {
        return this.features.clone();
    }

    public final boolean hasLicenseForFeature(String string) {
        return this.hasLicenseForFeature(System.currentTimeMillis(), string);
    }

    public final boolean hasLicenseForFeature(long l, String string) {
        Feature feature = new Feature(string);
        Feature feature2 = this.features.get(feature);
        return feature2 != null && (feature2.getGoodBeforeDate() < 0L || feature2.getGoodBeforeDate() >= l);
    }

    public final boolean hasLicenseForFeature(FeatureObject featureObject) {
        return this.hasLicenseForFeature(System.currentTimeMillis(), featureObject.getName());
    }

    public final boolean hasLicenseForFeature(long l, FeatureObject featureObject) {
        return this.hasLicenseForFeature(l, featureObject.getName());
    }

    public final boolean hasLicenseForAnyFeature(String ... stringArray) {
        return this.hasLicenseForAnyFeature(System.currentTimeMillis(), stringArray);
    }

    public final boolean hasLicenseForAnyFeature(long l, String ... stringArray) {
        for (String string : stringArray) {
            if (!this.hasLicenseForFeature(l, string)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasLicenseForAnyFeature(FeatureObject ... featureObjectArray) {
        return this.hasLicenseForAnyFeature(System.currentTimeMillis(), featureObjectArray);
    }

    public final boolean hasLicenseForAnyFeature(long l, FeatureObject ... featureObjectArray) {
        for (FeatureObject featureObject : featureObjectArray) {
            if (!this.hasLicenseForFeature(l, featureObject)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasLicenseForAllFeatures(String ... stringArray) {
        return this.hasLicenseForAllFeatures(System.currentTimeMillis(), stringArray);
    }

    public final boolean hasLicenseForAllFeatures(long l, String ... stringArray) {
        for (String string : stringArray) {
            if (this.hasLicenseForFeature(l, string)) continue;
            return false;
        }
        return true;
    }

    public final boolean hasLicenseForAllFeatures(FeatureObject ... featureObjectArray) {
        return this.hasLicenseForAllFeatures(System.currentTimeMillis(), featureObjectArray);
    }

    public final boolean hasLicenseForAllFeatures(long l, FeatureObject ... featureObjectArray) {
        for (FeatureObject featureObject : featureObjectArray) {
            if (this.hasLicenseForFeature(l, featureObject)) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object object) {
        boolean bl;
        if (object == null || !object.getClass().equals(License.class)) {
            return false;
        }
        License license = (License)object;
        boolean bl2 = bl = (license.productKey == null && this.productKey == null || license.productKey != null && license.productKey.equals(this.productKey)) && (license.holder == null && this.holder == null || license.holder != null && license.holder.equals(this.holder)) && (license.issuer == null && this.issuer == null || license.issuer != null && license.issuer.equals(this.issuer)) && (license.subject == null && this.subject == null || license.subject != null && license.subject.equals(this.subject)) && license.issueDate == this.issueDate && license.goodAfterDate == this.goodAfterDate && license.goodBeforeDate == this.goodBeforeDate && license.numberOfLicenses == this.numberOfLicenses;
        if (!bl) {
            return false;
        }
        for (Feature feature : this.features) {
            Feature feature2 = license.features.get(feature);
            if (feature2 != null && feature2.getGoodBeforeDate() == feature.getGoodBeforeDate()) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int n = this.numberOfLicenses;
        n = this.productKey != null && this.productKey.length() > 0 ? 31 * n + this.productKey.hashCode() : 31 * n;
        n = this.holder != null && this.holder.length() > 0 ? 31 * n + this.holder.hashCode() : 31 * n;
        n = this.issuer != null && this.issuer.length() > 0 ? 31 * n + this.issuer.hashCode() : 31 * n;
        n = this.subject != null && this.subject.length() > 0 ? 31 * n + this.subject.hashCode() : 31 * n;
        n = 31 * n + Long.valueOf(this.issueDate).hashCode();
        n = 31 * n + Long.valueOf(this.goodAfterDate).hashCode();
        n = 31 * n + Long.valueOf(this.goodBeforeDate).hashCode();
        n = 31 * n + this.features.hashCode();
        return n;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(this.productKey == null ? "" : this.productKey).append("][").append(this.holder == null ? "" : this.holder).append("][").append(this.issuer == null ? "" : this.issuer).append("][").append(this.subject == null ? "" : this.subject).append("][").append(this.issueDate).append("][").append(this.goodAfterDate).append("][").append(this.goodBeforeDate).append("][").append(this.numberOfLicenses).append(']').append(this.features).toString();
        return stringBuilder.toString();
    }

    public final License clone() {
        Builder builder = new Builder().withProductKey(this.productKey).withHolder(this.holder).withIssuer(this.issuer).withSubject(this.subject).withIssueDate(this.issueDate).withGoodAfterDate(this.goodAfterDate).withGoodBeforeDate(this.goodBeforeDate).withNumberOfLicenses(this.numberOfLicenses);
        for (Feature feature : this.features) {
            builder.addFeature(feature.clone());
        }
        return builder.build();
    }

    public static final class Builder {
        private String productKey;
        private String holder;
        private String issuer;
        private String subject;
        private long issueDate = System.currentTimeMillis();
        private long goodAfterDate;
        private long goodBeforeDate;
        private int numberOfLicenses = Integer.MAX_VALUE;
        private Set<Feature> features = new LinkedHashSet<Feature>();

        public Builder withProductKey(String string) {
            this.productKey = string;
            return this;
        }

        public Builder withIssuer(String string) {
            this.issuer = string;
            return this;
        }

        public Builder withHolder(String string) {
            this.holder = string;
            return this;
        }

        public Builder withSubject(String string) {
            this.subject = string;
            return this;
        }

        public Builder withIssueDate(long l) {
            this.issueDate = l;
            return this;
        }

        public Builder withGoodAfterDate(long l) {
            this.goodAfterDate = l;
            return this;
        }

        public Builder withGoodBeforeDate(long l) {
            this.goodBeforeDate = l;
            return this;
        }

        public Builder withNumberOfLicenses(int n) {
            this.numberOfLicenses = n;
            return this;
        }

        public Builder addFeature(String string) {
            this.features.add(new Feature(string));
            return this;
        }

        @Deprecated
        public Builder withFeature(String string) {
            return this.addFeature(string);
        }

        public Builder addFeature(String string, long l) {
            this.features.add(new Feature(string, l));
            return this;
        }

        @Deprecated
        public Builder withFeature(String string, long l) {
            return this.addFeature(string, l);
        }

        public Builder addFeature(Feature feature) {
            this.features.add(feature);
            return this;
        }

        @Deprecated
        public Builder withFeature(Feature feature) {
            return this.addFeature(feature);
        }

        public License build() {
            return new License(this);
        }
    }

    public static final class Feature
    implements Cloneable,
    Serializable,
    FeatureObject {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final long goodBeforeDate;

        private Feature(String string) {
            this(string, -1L);
        }

        private Feature(String string, long l) {
            this.name = string;
            this.goodBeforeDate = l;
        }

        private static Feature fromString(String string) {
            if (string == null) {
                throw new IllegalArgumentException("The input argument did not contain exactly two parts.");
            }
            String[] stringArray = string.split("\u001f");
            if (stringArray == null || stringArray.length != 2) {
                throw new IllegalArgumentException("The input argument did not contain exactly two parts.");
            }
            return new Feature(stringArray[0], Long.parseLong(stringArray[1]));
        }

        @Override
        public final String getName() {
            return this.name;
        }

        public final long getGoodBeforeDate() {
            return this.goodBeforeDate;
        }

        public final boolean equals(Object object) {
            if (object == null || object.getClass() != Feature.class) {
                return false;
            }
            Feature feature = (Feature)object;
            return feature.name.equals(this.name);
        }

        public final int hashCode() {
            return this.name.hashCode();
        }

        public final String toString() {
            return this.name + '\u001f' + Long.toString(this.goodBeforeDate);
        }

        public Feature clone() {
            return new Feature(this.name, this.goodBeforeDate);
        }
    }
}

