/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.encryption;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.nicholaswilliams.java.licensing.LicensingCharsets;
import net.nicholaswilliams.java.licensing.exception.AlgorithmNotSupportedException;
import net.nicholaswilliams.java.licensing.exception.FailedToDecryptException;
import net.nicholaswilliams.java.licensing.exception.InappropriateKeyException;
import net.nicholaswilliams.java.licensing.exception.InappropriateKeySpecificationException;
import org.apache.commons.codec.binary.Base64;

public final class Encryptor {
    private static final int minimumPaddedLength = 20;
    private static final SecureRandom random = new SecureRandom();
    private static Cipher defaultEncryptionCipher;
    private static Cipher defaultDecryptionCipher;
    private static final char[] defaultPassphrase;
    private static final byte[] salt;
    private static final int iterationCount = 1024;
    private static final int aesKeyLength = 128;

    public static String encrypt(String string) {
        return Encryptor.encrypt(string.getBytes(LicensingCharsets.UTF_8));
    }

    public static String encrypt(String string, char[] cArray) {
        return Encryptor.encrypt(string.getBytes(LicensingCharsets.UTF_8), cArray);
    }

    public static String encrypt(byte[] byArray) {
        return new String(Base64.encodeBase64URLSafe((byte[])Encryptor.encryptRaw(byArray)), LicensingCharsets.UTF_8);
    }

    public static String encrypt(byte[] byArray, char[] cArray) {
        return new String(Base64.encodeBase64URLSafe((byte[])Encryptor.encryptRaw(byArray, cArray)), LicensingCharsets.UTF_8);
    }

    public static byte[] encryptRaw(byte[] byArray) {
        try {
            return Encryptor.getDefaultEncryptionCipher().doFinal(Encryptor.pad(byArray, 20));
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException("While encrypting the data...", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("While encrypting the data...", badPaddingException);
        }
    }

    public static byte[] encryptRaw(byte[] byArray, char[] cArray) {
        try {
            return Encryptor.getEncryptionCipher(cArray).doFinal(Encryptor.pad(byArray, 20));
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException("While encrypting the data...", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("While encrypting the data...", badPaddingException);
        }
    }

    public static String decrypt(String string) {
        return Encryptor.decrypt(Base64.decodeBase64((String)string));
    }

    public static String decrypt(String string, char[] cArray) {
        return Encryptor.decrypt(Base64.decodeBase64((String)string), cArray);
    }

    public static String decrypt(byte[] byArray) {
        return new String(Encryptor.decryptRaw(byArray), LicensingCharsets.UTF_8);
    }

    public static String decrypt(byte[] byArray, char[] cArray) {
        return new String(Encryptor.decryptRaw(byArray, cArray), LicensingCharsets.UTF_8);
    }

    public static byte[] decryptRaw(byte[] byArray) {
        try {
            return Encryptor.unPad(Encryptor.getDefaultDecryptionCipher().doFinal(byArray));
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new FailedToDecryptException(illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new FailedToDecryptException(badPaddingException);
        }
    }

    public static byte[] decryptRaw(byte[] byArray, char[] cArray) {
        try {
            return Encryptor.unPad(Encryptor.getDecryptionCipher(cArray).doFinal(byArray));
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new FailedToDecryptException(illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new FailedToDecryptException(badPaddingException);
        }
    }

    private static byte[] pad(byte[] byArray, int n) {
        int n2;
        if (byArray.length >= n) {
            byte[] byArray2 = new byte[byArray.length + 1];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray2[byArray.length] = 1;
            return byArray2;
        }
        byte[] byArray3 = new byte[n + 1];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byArray3[n2] = byArray[n2];
        }
        int n3 = n - n2;
        byte[] byArray4 = new byte[n3 - 1];
        random.nextBytes(byArray4);
        System.arraycopy(byArray4, 0, byArray3, n2, n3 - 1);
        byArray3[n] = (byte)(n3 + 1);
        return byArray3;
    }

    private static byte[] unPad(byte[] byArray) {
        byte by = byArray[byArray.length - 1];
        int n = byArray.length - by;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    private static SecretKey getSecretKey(char[] cArray) {
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, salt, 1024, 128);
            byte[] byArray = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(pBEKeySpec).getEncoded();
            byte[] byArray2 = new byte[16];
            int n = 0;
            for (int i = 0; i < 16; ++i) {
                byArray2[i] = byArray[n];
                if (++n != byArray.length) continue;
                n = 0;
            }
            return new SecretKeySpec(byArray2, "AES");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AlgorithmNotSupportedException("DES with an MD5 Digest", noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InappropriateKeySpecificationException(invalidKeySpecException);
        }
    }

    private static Cipher getDefaultEncryptionCipher() {
        if (defaultEncryptionCipher == null) {
            defaultEncryptionCipher = Encryptor.getEncryptionCipher(defaultPassphrase);
        }
        return defaultEncryptionCipher;
    }

    private static Cipher getEncryptionCipher(char[] cArray) {
        return Encryptor.getEncryptionCipher(Encryptor.getSecretKey(cArray));
    }

    private static Cipher getEncryptionCipher(SecretKey secretKey) {
        try {
            Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
            cipher.init(1, (Key)secretKey, random);
            return cipher;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AlgorithmNotSupportedException("AES With SHA-1 digest", noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new RuntimeException(noSuchPaddingException.getMessage(), noSuchPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InappropriateKeyException(invalidKeyException.getMessage(), invalidKeyException);
        }
    }

    private static Cipher getDefaultDecryptionCipher() {
        if (defaultDecryptionCipher == null) {
            defaultDecryptionCipher = Encryptor.getDecryptionCipher(defaultPassphrase);
        }
        return defaultDecryptionCipher;
    }

    private static Cipher getDecryptionCipher(char[] cArray) {
        return Encryptor.getDecryptionCipher(Encryptor.getSecretKey(cArray));
    }

    private static Cipher getDecryptionCipher(SecretKey secretKey) {
        try {
            Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
            cipher.init(2, (Key)secretKey, random);
            return cipher;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AlgorithmNotSupportedException("AES With SHA-1 digest", noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new RuntimeException(noSuchPaddingException.getMessage(), noSuchPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InappropriateKeyException(invalidKeyException.getMessage(), invalidKeyException);
        }
    }

    private Encryptor() {
        throw new RuntimeException("This class cannot be instantiated.");
    }

    static {
        defaultPassphrase = new char[]{'j', '4', 'K', 'g', 'U', '3', '0', '5', 'P', 'Z', 'p', '\'', 't', '.', '\"', '%', 'o', 'r', 'd', 'A', 'Y', '7', 'q', '*', '?', 'z', '9', '%', '8', ']', 'a', 'm', 'N', 'L', '(', '0', 'W', 'x', '5', 'e', 'G', '4', '9', 'b', '1', 's', 'R', 'j', '(', '^', ';', '8', 'K', 'g', '2', 'w', '0', 'E', 'o', 'M'};
        salt = new byte[]{-87, -94, -75, -34, 42, -118, -102, -26};
    }
}

