/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.encryption;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.nicholaswilliams.java.licensing.encryption.PublicKeyDataProvider;
import net.nicholaswilliams.java.licensing.exception.KeyNotFoundException;
import org.apache.commons.io.FileUtils;

public class FilePublicKeyDataProvider
implements PublicKeyDataProvider {
    private final File publicKeyFile;

    public FilePublicKeyDataProvider(File file) {
        this.publicKeyFile = file.getAbsoluteFile();
    }

    public FilePublicKeyDataProvider(String string) {
        this.publicKeyFile = new File(string).getAbsoluteFile();
    }

    @Override
    public byte[] getEncryptedPublicKeyData() throws KeyNotFoundException {
        try {
            return FileUtils.readFileToByteArray((File)this.publicKeyFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyNotFoundException("The public key file [" + this.publicKeyFile.getPath() + "] does not exist.");
        }
        catch (IOException iOException) {
            throw new KeyNotFoundException("Could not read from the public key file [" + this.publicKeyFile.getPath() + "].", iOException);
        }
    }

    public File getPublicKeyFile() {
        return this.publicKeyFile;
    }
}

