/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.immutable;

import java.io.Serializable;
import java.util.Collection;
import net.nicholaswilliams.java.licensing.immutable.Immutable;
import net.nicholaswilliams.java.licensing.immutable.ImmutableIterator;
import net.nicholaswilliams.java.licensing.immutable.ImmutableModifiedThroughReflectionException;
import net.nicholaswilliams.java.licensing.immutable.ValidObject;

public abstract class ImmutableAbstractCollection<E>
extends ValidObject
implements Immutable,
Collection<E>,
Serializable {
    private static final long serialVersionUID = -4187794066638697055L;
    final Collection<E> internalCollection;
    private final int internalSize;
    private final int internalHashCode;

    protected ImmutableAbstractCollection(Collection<E> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Parameter collection must not be null.");
        }
        this.internalCollection = collection;
        this.internalSize = this.internalCollection.size();
        this.internalHashCode = this.internalCollection.hashCode();
    }

    @Override
    protected final void checkValidity() {
        if (this.internalSize != this.internalCollection.size() || this.internalHashCode != this.internalCollection.hashCode()) {
            throw new ImmutableModifiedThroughReflectionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean equals(Object object) {
        Collection<E> collection = this.internalCollection;
        synchronized (collection) {
            this.checkValidity();
            return object == this || object instanceof ImmutableAbstractCollection && this.internalCollection.equals(((ImmutableAbstractCollection)object).internalCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int hashCode() {
        Collection<E> collection = this.internalCollection;
        synchronized (collection) {
            this.checkValidity();
            return this.internalHashCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean contains(Object object) {
        Collection<E> collection = this.internalCollection;
        synchronized (collection) {
            this.checkValidity();
            try {
                return this.internalCollection.contains(object);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean containsAll(Collection<?> collection) {
        Collection<E> collection2 = this.internalCollection;
        synchronized (collection2) {
            this.checkValidity();
            return this.internalCollection.containsAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEmpty() {
        Collection<E> collection = this.internalCollection;
        synchronized (collection) {
            this.checkValidity();
            return this.internalCollection.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ImmutableIterator<E> iterator() {
        Collection<E> collection = this.internalCollection;
        synchronized (collection) {
            this.checkValidity();
            return new ImmutableIterator<E>(this.internalCollection.iterator(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int size() {
        Collection<E> collection = this.internalCollection;
        synchronized (collection) {
            this.checkValidity();
            return this.internalCollection.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object[] toArray() {
        Collection<E> collection = this.internalCollection;
        synchronized (collection) {
            this.checkValidity();
            return this.internalCollection.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T[] toArray(T[] TArray) {
        Collection<E> collection = this.internalCollection;
        synchronized (collection) {
            this.checkValidity();
            return this.internalCollection.toArray(TArray);
        }
    }

    public final String toString() {
        return this.internalCollection.toString();
    }

    @Override
    public final boolean add(E e) {
        throw new UnsupportedOperationException("This collection cannot be modified.");
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException("This collection cannot be modified.");
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException("This collection cannot be modified.");
    }

    @Override
    public final boolean remove(Object object) {
        throw new UnsupportedOperationException("This collection cannot be modified.");
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("This collection cannot be modified.");
    }

    @Override
    public final boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("This collection cannot be modified.");
    }
}

