/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.encryption;

import java.io.File;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.nicholaswilliams.java.licensing.encryption.KeyFileUtilities;
import net.nicholaswilliams.java.licensing.encryption.RSAKeyPairGeneratorInterface;
import net.nicholaswilliams.java.licensing.exception.AlgorithmNotSupportedException;
import net.nicholaswilliams.java.licensing.exception.InappropriateKeyException;
import net.nicholaswilliams.java.licensing.exception.InappropriateKeySpecificationException;
import net.nicholaswilliams.java.licensing.exception.RSA2048NotSupportedException;

public final class RSAKeyPairGenerator
implements RSAKeyPairGeneratorInterface {
    @Override
    public KeyPair generateKeyPair() throws RSA2048NotSupportedException {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RSA2048NotSupportedException("RSA keys are not supported on your system. Contact your system administrator for assistance.", noSuchAlgorithmException);
        }
        try {
            keyPairGenerator.initialize(2048);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new RSA2048NotSupportedException("RSA is supported on your system, but 2048-bit keys are not. Contact your system administrator for assistance.", invalidParameterException);
        }
        return keyPairGenerator.generateKeyPair();
    }

    @Override
    public void saveKeyPairToFiles(KeyPair keyPair, String string, String string2, char[] cArray) throws IOException, AlgorithmNotSupportedException, InappropriateKeyException, InappropriateKeySpecificationException {
        this.saveKeyPairToFiles(keyPair, string, string2, cArray, cArray);
    }

    @Override
    public void saveKeyPairToFiles(KeyPair keyPair, String string, String string2, char[] cArray, char[] cArray2) throws IOException, AlgorithmNotSupportedException, InappropriateKeyException, InappropriateKeySpecificationException {
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        KeyFileUtilities.writeEncryptedPrivateKey((PrivateKey)privateKey, (File)new File(string), (char[])cArray);
        KeyFileUtilities.writeEncryptedPublicKey((PublicKey)publicKey, (File)new File(string2), (char[])cArray2);
    }

    @Override
    public void saveKeyPairToProviders(KeyPair keyPair, RSAKeyPairGeneratorInterface.GeneratedClassDescriptor generatedClassDescriptor, RSAKeyPairGeneratorInterface.GeneratedClassDescriptor generatedClassDescriptor2, char[] cArray) throws AlgorithmNotSupportedException, InappropriateKeyException, InappropriateKeySpecificationException {
        this.saveKeyPairToProviders(keyPair, generatedClassDescriptor, generatedClassDescriptor2, cArray, cArray);
    }

    @Override
    public void saveKeyPairToProviders(KeyPair keyPair, RSAKeyPairGeneratorInterface.GeneratedClassDescriptor generatedClassDescriptor, RSAKeyPairGeneratorInterface.GeneratedClassDescriptor generatedClassDescriptor2, char[] cArray, char[] cArray2) throws AlgorithmNotSupportedException, InappropriateKeyException, InappropriateKeySpecificationException {
        if (keyPair == null) {
            throw new IllegalArgumentException("Parameter keyPair cannot be null.");
        }
        if (generatedClassDescriptor == null) {
            throw new IllegalArgumentException("Parameter privateKeyProvider cannot be null.");
        }
        if (generatedClassDescriptor2 == null) {
            throw new IllegalArgumentException("Parameter publicKeyProvider cannot be null.");
        }
        if (cArray == null || cArray.length == 0) {
            throw new IllegalArgumentException("Parameter privatePassword cannot be null or zero-length.");
        }
        if (cArray2 == null || cArray2.length == 0) {
            throw new IllegalArgumentException("Parameter publicPassword cannot be null or zero-length.");
        }
        byte[] byArray = KeyFileUtilities.writeEncryptedPrivateKey((PrivateKey)keyPair.getPrivate(), (char[])cArray);
        byte[] byArray2 = KeyFileUtilities.writeEncryptedPublicKey((PublicKey)keyPair.getPublic(), (char[])cArray2);
        String string = this.arrayToCodeString(this.byteArrayToIntArray(byArray), "byte");
        String string2 = this.arrayToCodeString(this.byteArrayToIntArray(byArray2), "byte");
        generatedClassDescriptor.setJavaFileContents(this.generateJavaCode(generatedClassDescriptor.getPackageName(), generatedClassDescriptor.getClassName(), "PrivateKeyDataProvider", new String[]{"net.nicholaswilliams.java.licensing.encryption.PrivateKeyDataProvider", "net.nicholaswilliams.java.licensing.exception.KeyNotFoundException"}, "public byte[] getEncryptedPrivateKeyData() throws KeyNotFoundException", string));
        generatedClassDescriptor2.setJavaFileContents(this.generateJavaCode(generatedClassDescriptor2.getPackageName(), generatedClassDescriptor2.getClassName(), "PublicKeyDataProvider", new String[]{"net.nicholaswilliams.java.licensing.encryption.PublicKeyDataProvider", "net.nicholaswilliams.java.licensing.exception.KeyNotFoundException"}, "public byte[] getEncryptedPublicKeyData() throws KeyNotFoundException", string2));
    }

    @Override
    public void savePasswordToProvider(char[] cArray, RSAKeyPairGeneratorInterface.GeneratedClassDescriptor generatedClassDescriptor) {
        if (cArray == null || cArray.length == 0) {
            throw new IllegalArgumentException("Parameter password cannot be null or zero-length.");
        }
        if (generatedClassDescriptor == null) {
            throw new IllegalArgumentException("Parameter passwordProvider cannot be null.");
        }
        String string = this.arrayToCodeString(this.charArrayToIntArray(cArray), "char");
        generatedClassDescriptor.setJavaFileContents(this.generateJavaCode(generatedClassDescriptor.getPackageName(), generatedClassDescriptor.getClassName(), "PasswordProvider", new String[]{"net.nicholaswilliams.java.licensing.encryption.PasswordProvider"}, "public char[] getPassword()", string));
    }

    protected String generateJavaCode(String string, String string2, String string3, String[] stringArray, String string4, String string5) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.trim().length() > 0) {
            stringBuilder.append("package ").append(string.trim()).append(";\r\n\r\n");
        }
        if (stringArray != null && stringArray.length > 0) {
            for (String string6 : stringArray) {
                stringBuilder.append("import ").append(string6.trim()).append(";\r\n");
            }
            stringBuilder.append("\r\n");
        }
        boolean bl = string3 != null && string3.trim().length() > 0;
        stringBuilder.append("public final class ").append(string2.trim());
        if (bl) {
            stringBuilder.append(" implements ").append(string3.trim());
        }
        stringBuilder.append("\r\n");
        stringBuilder.append("{\r\n");
        if (bl) {
            stringBuilder.append("\t@Override\r\n");
        }
        stringBuilder.append("\t").append(string4.trim()).append("\r\n");
        stringBuilder.append("\t{\r\n");
        stringBuilder.append("\t\treturn ").append(string5).append(";\r\n");
        stringBuilder.append("\t}\r\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    protected String arrayToCodeString(int[] nArray, String string) {
        StringBuilder stringBuilder = new StringBuilder("new ").append(string).append("[] {\r\n\t\t\t\t");
        int n = 0;
        int n2 = 1;
        for (int n3 : nArray) {
            if (n++ > 0) {
                stringBuilder.append(", ");
            }
            if (n2++ > 8) {
                n2 = 2;
                stringBuilder.append("\r\n\t\t\t\t");
            }
            stringBuilder.append("0x");
            stringBuilder.append(String.format("%08x", n3).toUpperCase());
        }
        stringBuilder.append("\r\n\t\t}");
        return stringBuilder.toString();
    }

    protected int[] byteArrayToIntArray(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        int n = 0;
        for (int n2 : byArray) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    protected int[] charArrayToIntArray(char[] cArray) {
        int[] nArray = new int[cArray.length];
        int n = 0;
        for (int n2 : cArray) {
            nArray[n++] = n2;
        }
        return nArray;
    }
}

