/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.licensor;

import java.io.Serializable;
import java.security.PrivateKey;
import java.util.Arrays;
import net.nicholaswilliams.java.licensing.DataSignatureManager;
import net.nicholaswilliams.java.licensing.License;
import net.nicholaswilliams.java.licensing.ObjectSerializer;
import net.nicholaswilliams.java.licensing.SignedLicense;
import net.nicholaswilliams.java.licensing.encryption.Encryptor;
import net.nicholaswilliams.java.licensing.encryption.KeyFileUtilities;
import net.nicholaswilliams.java.licensing.encryption.PasswordProvider;
import net.nicholaswilliams.java.licensing.encryption.PrivateKeyDataProvider;
import net.nicholaswilliams.java.licensing.exception.AlgorithmNotSupportedException;
import net.nicholaswilliams.java.licensing.exception.InappropriateKeyException;
import net.nicholaswilliams.java.licensing.exception.InappropriateKeySpecificationException;
import net.nicholaswilliams.java.licensing.exception.KeyNotFoundException;
import net.nicholaswilliams.java.licensing.exception.ObjectSerializationException;
import net.nicholaswilliams.java.licensing.licensor.LicenseCreatorProperties;

public final class LicenseCreator {
    private static LicenseCreator instance;
    private final PrivateKeyDataProvider privateKeyDataProvider;
    private final PasswordProvider privateKeyPasswordProvider;

    private LicenseCreator() {
        if (LicenseCreatorProperties.getPrivateKeyDataProvider() == null) {
            throw new IllegalArgumentException("Parameter privateKeyDataProvider must not be null.");
        }
        if (LicenseCreatorProperties.getPrivateKeyPasswordProvider() == null) {
            throw new IllegalArgumentException("Parameter privateKeyPasswordProvider must not be null.");
        }
        this.privateKeyPasswordProvider = LicenseCreatorProperties.getPrivateKeyPasswordProvider();
        this.privateKeyDataProvider = LicenseCreatorProperties.getPrivateKeyDataProvider();
    }

    public static synchronized LicenseCreator getInstance() {
        if (instance == null) {
            instance = new LicenseCreator();
        }
        return instance;
    }

    public final SignedLicense signLicense(License license, char[] cArray) throws AlgorithmNotSupportedException, KeyNotFoundException, InappropriateKeySpecificationException, InappropriateKeyException {
        Object[] objectArray = this.privateKeyPasswordProvider.getPassword();
        byte[] byArray = this.privateKeyDataProvider.getEncryptedPrivateKeyData();
        PrivateKey privateKey = KeyFileUtilities.readEncryptedPrivateKey((byte[])byArray, (char[])objectArray);
        Arrays.fill(objectArray, '\u0000');
        Arrays.fill(byArray, (byte)0);
        objectArray = Encryptor.encryptRaw((byte[])license.serialize(), (char[])cArray);
        byArray = new DataSignatureManager().signData(privateKey, (byte[])objectArray);
        SignedLicense signedLicense = new SignedLicense((byte[])objectArray, byArray);
        Arrays.fill((byte[])objectArray, (byte)0);
        Arrays.fill(byArray, (byte)0);
        return signedLicense;
    }

    public final SignedLicense signLicense(License license) throws AlgorithmNotSupportedException, KeyNotFoundException, InappropriateKeySpecificationException, InappropriateKeyException {
        return this.signLicense(license, this.privateKeyPasswordProvider.getPassword());
    }

    public final byte[] signAndSerializeLicense(License license, char[] cArray) throws AlgorithmNotSupportedException, KeyNotFoundException, InappropriateKeySpecificationException, InappropriateKeyException, ObjectSerializationException {
        return new ObjectSerializer().writeObject((Serializable)this.signLicense(license, cArray));
    }

    public final byte[] signAndSerializeLicense(License license) throws AlgorithmNotSupportedException, KeyNotFoundException, InappropriateKeySpecificationException, InappropriateKeyException, ObjectSerializationException {
        return new ObjectSerializer().writeObject((Serializable)this.signLicense(license));
    }
}

